/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.blog;

import com.aimluck.eip.blog.BlogEntryResultData;
import com.aimluck.eip.blog.BlogFileResultData;
import com.aimluck.eip.blog.BlogThemaResultData;
import com.aimluck.eip.blog.util.BlogUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogComment;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogEntry;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogFile;
import com.aimluck.eip.common.ALAbstractMultiFilterSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import javax.imageio.ImageIO;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class BlogEntryLatestSelectData
extends ALAbstractMultiFilterSelectData<EipTBlogEntry, EipTBlogEntry>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)BlogEntryLatestSelectData.class.getName());
    private List<BlogThemaResultData> themaList;
    private int entrySum;
    private List<BlogFileResultData> photoList;
    private int uid;
    private int newEntryId;
    private List<BlogEntryResultData> commentHistoryList;
    private final int DELETE_DATE = 7;
    private final int MAX_COMMENT_HISTORY_COUNT = 20;
    private final List<Integer> users = new ArrayList<Integer>();
    private List<ALEipGroup> postList;
    private String themaId = "";
    private String filterType = "";

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        this.postList = ALEipUtils.getMyGroups((RunData)rundata);
        try {
            String themaId;
            this.filterType = rundata.getParameters().getString("filtertype", "");
            if (this.filterType.equals("thema") && !(themaId = rundata.getParameters().getString("filter", "")).equals("")) {
                this.themaId = themaId;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"blog", (Throwable)ex);
        }
        super.init(action, rundata, context);
    }

    private void loadPhotos() throws Exception {
        this.photoList = new ArrayList<BlogFileResultData>();
        String[] ext = ImageIO.getWriterFormatNames();
        SelectQuery query = Database.query(EipTBlogFile.class);
        Expression exp01 = ExpressionFactory.likeExp((String)"title", (Object)("%" + ext[0]));
        query.setQualifier(exp01);
        for (int i = 1; i < ext.length; ++i) {
            Expression exp02 = ExpressionFactory.likeExp((String)"title", (Object)("%" + ext[i]));
            query.orQualifier(exp02);
        }
        query.orderDesending("updateDate");
        query.limit(5);
        List list = query.fetchList();
        if (list != null && list.size() > 0) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                EipTBlogFile record = (EipTBlogFile)list.get(i);
                BlogFileResultData file = new BlogFileResultData();
                file.initField();
                file.setFileId(record.getFileId().longValue());
                file.setOwnerId(record.getOwnerId().longValue());
                file.setEntryId(record.getEipTBlogEntry().getEntryId().longValue());
                this.photoList.add(file);
            }
        }
    }

    private void loadCommentHistoryList(RunData rundata) throws Exception {
        this.commentHistoryList = new ArrayList<BlogEntryResultData>();
        Integer thisUserId = this.uid;
        Integer beforeEntryId = null;
        SelectQuery comment_query = Database.query(EipTBlogComment.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"ownerId", (Object)thisUserId);
        comment_query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.greaterExp((String)"updateDate", (Object)this.reduceDate(Calendar.getInstance().getTime(), 7));
        comment_query.andQualifier(exp2);
        comment_query.orderAscending("eipTBlogEntry");
        List aList = comment_query.fetchList();
        for (EipTBlogComment record : aList) {
            try {
                EipTBlogEntry entry = record.getEipTBlogEntry();
                if (entry == null || entry.getOwnerId().equals(thisUserId) || entry.getEntryId().equals(beforeEntryId)) continue;
                beforeEntryId = entry.getEntryId();
                BlogEntryResultData rd = new BlogEntryResultData();
                rd.initField();
                rd.setEntryId(entry.getEntryId().longValue());
                rd.setOwnerId(entry.getOwnerId().longValue());
                rd.setTitle(ALCommonUtils.compressString((String)entry.getTitle(), (int)this.getStrLength()));
                rd.setTitleDate(record.getUpdateDate());
                SelectQuery cquery = Database.query(EipTBlogComment.class).select("COMMENT_ID");
                Expression cexp = ExpressionFactory.matchDbExp((String)"eipTBlogEntry.ENTRY_ID", (Object)entry.getEntryId());
                cquery.setQualifier(cexp);
                List list = cquery.fetchList();
                if (list != null && list.size() > 0) {
                    rd.setCommentsNum(list.size());
                }
                rd.setThemaId(entry.getEipTBlogThema().getThemaId().intValue());
                rd.setThemaName(entry.getEipTBlogThema().getThemaName());
                this.commentHistoryList.add(rd);
                if (this.users.contains(entry.getOwnerId())) continue;
                this.users.add(entry.getOwnerId());
            }
            catch (Exception e) {
                logger.warn((Object)"[loadCommentHistoryList]", (Throwable)e);
            }
        }
        Collections.sort(this.commentHistoryList, BlogEntryLatestSelectData.getDateComparator());
        if (this.commentHistoryList.size() > 20) {
            this.commentHistoryList.subList(20, this.commentHistoryList.size()).clear();
        }
    }

    public void loadThemaList(RunData rundata, Context context) {
        this.themaList = BlogUtils.getThemaList(rundata, context);
    }

    public ResultList<EipTBlogEntry> selectList(RunData rundata, Context context) {
        try {
            this.loadPhotos();
            this.loadCommentHistoryList(rundata);
            SelectQuery<EipTBlogEntry> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            query.orderDesending("createDate");
            ResultList list = query.getResultList();
            this.entrySum = list.getTotalCount();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"blog", (Throwable)ex);
            return null;
        }
    }

    protected void parseFilterMap(String key, String val) {
        super.parseFilterMap(key, val);
        HashSet unUse = new HashSet();
        for (Map.Entry pair : this.current_filterMap.entrySet()) {
            if (!((List)pair.getValue()).contains("0")) continue;
            unUse.add(pair.getKey());
        }
        for (String unusekey : unUse) {
            this.current_filterMap.remove(unusekey);
        }
    }

    protected SelectQuery<EipTBlogEntry> buildSelectQueryForFilter(SelectQuery<EipTBlogEntry> query, RunData rundata, Context context) {
        String search;
        super.buildSelectQueryForFilter(query, rundata, context);
        if (this.current_filterMap.containsKey("post")) {
            List postIds = (List)this.current_filterMap.get("post");
            boolean existPost = false;
            for (int i = 0; i < this.postList.size(); ++i) {
                String pid = this.postList.get(i).getName().toString();
                if (!pid.equals(((String)postIds.get(0)).toString())) continue;
                existPost = true;
                break;
            }
            Map map = ALEipManager.getInstance().getPostMap();
            for (Map.Entry entry : map.entrySet()) {
                String pid = ((ALEipPost)entry.getValue()).getGroupName().toString();
                if (!pid.equals(((String)postIds.get(0)).toString())) continue;
                existPost = true;
                break;
            }
            if (existPost) {
                HashSet<Integer> userIds = new HashSet<Integer>();
                for (String post : postIds) {
                    List userId = ALEipUtils.getUserIds((String)post);
                    userIds.addAll(userId);
                }
                if (userIds.isEmpty()) {
                    userIds.add(-1);
                }
                Expression expression = ExpressionFactory.inExp((String)"ownerId", userIds);
                query.andQualifier(expression);
            } else {
                this.current_filterMap.remove("post");
            }
        }
        if ((search = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SEARCH_STR)) != null && !"".equals(search)) {
            this.current_search = search;
            Expression ex1 = ExpressionFactory.likeExp((String)"note", (Object)("%" + search + "%"));
            Expression ex2 = ExpressionFactory.likeExp((String)"title", (Object)("%" + search + "%"));
            SelectQuery q = Database.query(EipTBlogEntry.class);
            q.andQualifier(ex1.orExp(ex2));
            List list = q.fetchList();
            ArrayList<Integer> resultid = new ArrayList<Integer>();
            for (EipTBlogEntry item : list) {
            }
            if (resultid.size() == 0) {
                resultid.add(-1);
            }
            Expression ex = ExpressionFactory.inDbExp((String)"ENTRY_ID", resultid);
            query.andQualifier(ex);
        }
        return query;
    }

    private SelectQuery<EipTBlogEntry> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTBlogEntry.class);
        return this.buildSelectQueryForFilter((SelectQuery<EipTBlogEntry>)query, rundata, context);
    }

    protected Object getResultData(EipTBlogEntry record) {
        try {
            BlogEntryResultData rd = new BlogEntryResultData();
            rd.initField();
            rd.setEntryId(record.getEntryId().longValue());
            rd.setOwnerId(record.getOwnerId().longValue());
            rd.setTitle(ALCommonUtils.compressString((String)record.getTitle(), (int)this.getStrLength()));
            rd.setNote(record.getNote().replaceAll("\\r\\n", " ").replaceAll("\\n", " ").replaceAll("\\r", " "));
            rd.setBlogId(record.getEipTBlog().getBlogId().intValue());
            if (record.getEipTBlogThema() != null) {
                rd.setThemaId(record.getEipTBlogThema().getThemaId().intValue());
                rd.setThemaName(record.getEipTBlogThema().getThemaName());
            }
            rd.setAllowComments("T".equals(record.getAllowComments()));
            rd.setTitleDate(record.getCreateDate());
            List list = record.getEipTBlogComments();
            if (list != null && list.size() > 0) {
                rd.setCommentsNum(list.size());
            }
            if (!this.users.contains(record.getOwnerId())) {
                this.users.add(record.getOwnerId());
            }
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"blog", (Throwable)ex);
            return null;
        }
    }

    public EipTBlogEntry selectDetail(RunData rundata, Context context) {
        return null;
    }

    protected Object getResultDataDetail(EipTBlogEntry obj) {
        return null;
    }

    public List<BlogFileResultData> getPhotoList() {
        return this.photoList;
    }

    public int getLoginUid() {
        return this.uid;
    }

    public int getEntrySum() {
        return this.entrySum;
    }

    public List<BlogThemaResultData> getThemaList() {
        return this.themaList;
    }

    public int getNewEntryId() {
        return this.newEntryId;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("thema", "THEMA_ID");
        map.putValue("update", "updateDate");
        return map;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public List<BlogEntryResultData> getCommentHistoryList() {
        return this.commentHistoryList;
    }

    public static Comparator<BlogEntryResultData> getDateComparator() {
        Comparator<BlogEntryResultData> com = null;
        com = new Comparator<BlogEntryResultData>(){

            @Override
            public int compare(BlogEntryResultData obj0, BlogEntryResultData obj1) {
                Date date1;
                Date date0 = obj0.getTitleDate().getValue();
                if (date0.compareTo(date1 = obj1.getTitleDate().getValue()) < 0) {
                    return 1;
                }
                if (date0.equals(date1)) {
                    return 0;
                }
                return -1;
            }
        };
        return com;
    }

    public static Date toDate(String str) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5(EE)");
            Date date = sdf.parse(str);
            return date;
        }
        catch (Exception ex) {
            logger.error((Object)"blog", (Throwable)ex);
            return null;
        }
    }

    public Date reduceDate(Date date, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, -day);
        return cal.getTime();
    }

    public String getAclPortletFeature() {
        return "blog_entry_other";
    }

    public boolean doViewList(ALAction action, RunData rundata, Context context) {
        boolean result = super.doViewList(action, rundata, context);
        this.loadAggregateUsers();
        return result;
    }

    protected void loadAggregateUsers() {
        ALEipManager.getInstance().getUsers(this.users);
    }

    public List<ALEipGroup> getPostList() {
        return this.postList;
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public void setFiltersPSML(VelocityPortlet portlet, Context context, RunData rundata) {
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR, (String)portlet.getPortletConfig().getInitParameter("p12f-filters"));
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR, (String)portlet.getPortletConfig().getInitParameter("p12g-filtertypes"));
    }

    public String getThemaId() {
        return this.themaId;
    }
}

