/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.xmlmodel.XmlField;

public class BigDecimalField
extends Field {
    public BigDecimalField(XmlField xmlField, Group group) throws Exception {
        super(xmlField, group);
    }

    protected String getDefaultValidator() {
        return "org.apache.fulcrum.intake.validator.NumberValidator";
    }

    protected void doSetValue() {
        if (this.isMultiValued) {
            String[] stringArray = this.pp.getStrings(this.getKey());
            BigDecimal[] bigDecimalArray = new BigDecimal[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null && stringArray[n].length() > 0) {
                    bigDecimalArray[n] = this.canonicalizeDecimalInput(stringArray[n]);
                }
                ++n;
            }
            this.setTestValue(bigDecimalArray);
        } else {
            String string = this.pp.getString(this.getKey());
            if (string != null && string.length() > 0) {
                this.setTestValue(this.canonicalizeDecimalInput(string));
            } else {
                this.set_flag = false;
            }
        }
    }

    protected final BigDecimal canonicalizeDecimalInput(String string) {
        DecimalFormatSymbols decimalFormatSymbols;
        DecimalFormatSymbols decimalFormatSymbols2;
        if (this.getLocale() != null && !(decimalFormatSymbols2 = new DecimalFormatSymbols()).equals(decimalFormatSymbols = new DecimalFormatSymbols(this.getLocale()))) {
            string = string.replace(decimalFormatSymbols.getDecimalSeparator(), decimalFormatSymbols2.getDecimalSeparator());
        }
        return new BigDecimal(string);
    }
}

