/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.transform;

import java.io.BufferedReader;
import java.io.FileReader;
import org.apache.fulcrum.intake.transform.DTDResolver;
import org.apache.fulcrum.intake.xmlmodel.AppData;
import org.apache.fulcrum.intake.xmlmodel.Rule;
import org.apache.fulcrum.intake.xmlmodel.XmlField;
import org.apache.fulcrum.intake.xmlmodel.XmlGroup;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlToAppData
extends DefaultHandler {
    private AppData app = new AppData();
    private XmlGroup currGroup;
    private XmlField currField;
    private Rule currRule;
    private String currElement;

    public AppData parseFile(String string) throws Exception {
        return this.parseFile(string, false);
    }

    public AppData parseFile(String string, boolean bl) throws Exception {
        SAXParser sAXParser = new SAXParser();
        DTDResolver dTDResolver = new DTDResolver();
        sAXParser.setEntityResolver((EntityResolver)dTDResolver);
        sAXParser.setContentHandler((ContentHandler)this);
        sAXParser.setErrorHandler((ErrorHandler)this);
        sAXParser.setFeature("http://apache.org/xml/features/validation/dynamic", true);
        sAXParser.setFeature("http://xml.org/sax/features/validation", true);
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            InputSource inputSource = new InputSource(bufferedReader);
            sAXParser.parse(inputSource);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        return this.app;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this.currElement = string3;
        if (string3.equals("input-data")) {
            this.app.loadFromXML(attributes);
        } else if (string3.equals("group")) {
            this.currGroup = this.app.addGroup(attributes);
        } else if (string3.equals("field")) {
            this.currField = this.currGroup.addField(attributes);
        } else if (string3.equals("rule")) {
            this.currRule = this.currField.addRule(attributes);
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2).trim();
        if ("rule".equals(this.currElement) && string.length() > 0) {
            this.currRule.setMessage(string);
        }
        if ("required-message".equals(this.currElement) && string.length() > 0) {
            this.currField.setIfRequiredMessage(string);
        }
    }

    public void warning(SAXParseException sAXParseException) {
        System.out.println("Warning Line: " + sAXParseException.getLineNumber() + " Row: " + sAXParseException.getColumnNumber() + " Msg: " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) {
        System.out.println("Error Line: " + sAXParseException.getLineNumber() + " Row: " + sAXParseException.getColumnNumber() + " Msg: " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) {
        System.out.println("Fatal Error Line: " + sAXParseException.getLineNumber() + " Row: " + sAXParseException.getColumnNumber() + " Msg: " + sAXParseException.getMessage());
    }
}

