/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.validator;

import java.util.Map;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.intake.validator.Constraint;
import org.apache.fulcrum.intake.validator.InitableByConstraintMap;
import org.apache.fulcrum.intake.validator.ValidationException;
import org.apache.fulcrum.intake.validator.Validator;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class DefaultValidator
implements Validator,
InitableByConstraintMap {
    protected boolean required;
    protected String requiredMessage;
    protected RE mask;
    protected String maskMessage;
    protected int minLength;
    protected String minLengthMessage;
    protected int maxLength;
    protected String maxLengthMessage;
    protected String message;

    public DefaultValidator(Map map) throws ServiceException {
        this.init(map);
    }

    public DefaultValidator() {
    }

    public void init(Map map) throws ServiceException {
        String string;
        this.mask = null;
        this.maskMessage = null;
        this.minLength = 0;
        this.minLengthMessage = null;
        this.maxLength = 0;
        this.maxLengthMessage = null;
        Constraint constraint = (Constraint)map.get("mask");
        if (constraint != null) {
            string = constraint.getValue();
            this.setMask(string);
            this.maskMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)map.get("minLength")) != null) {
            string = constraint.getValue();
            this.minLength = Integer.parseInt(string);
            this.minLengthMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)map.get("maxLength")) != null) {
            string = constraint.getValue();
            this.maxLength = Integer.parseInt(string);
            this.maxLengthMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)map.get("required")) == null) {
            this.required = false;
        } else {
            string = constraint.getValue();
            this.required = new Boolean(string);
            this.requiredMessage = constraint.getMessage();
        }
    }

    public boolean isValid(String string) {
        boolean bl = false;
        try {
            this.assertValidity(string);
            bl = true;
        }
        catch (ValidationException validationException) {
            bl = false;
        }
        return bl;
    }

    public void assertValidity(String string) throws ValidationException {
        this.message = null;
        if (!(this.required || this.minLength != 0 || string != null && string.length() != 0)) {
            return;
        }
        if (this.required && (string == null || string.length() == 0)) {
            this.message = this.requiredMessage;
            throw new ValidationException(this.requiredMessage);
        }
        this.doAssertValidity(string);
        if (this.mask != null && !this.mask.match(string)) {
            this.message = this.maskMessage;
            throw new ValidationException(this.maskMessage);
        }
        if (this.minLength > 0 && string.length() < this.minLength) {
            this.message = this.minLengthMessage;
            throw new ValidationException(this.minLengthMessage);
        }
        if (this.maxLength > 0 && string.length() > this.maxLength) {
            this.message = this.maxLengthMessage;
            throw new ValidationException(this.maxLengthMessage);
        }
    }

    public String getMessage() {
        if (this.message == null) {
            return "";
        }
        return this.message;
    }

    protected void doAssertValidity(String string) throws ValidationException {
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public String getRequiredMessage() {
        return this.requiredMessage;
    }

    public void setRequiredMessage(String string) {
        this.requiredMessage = string;
    }

    public String getMask() {
        return this.mask.toString();
    }

    public void setMask(String string) throws ServiceException {
        try {
            this.mask = new RE(string);
        }
        catch (RESyntaxException rESyntaxException) {
            throw new ServiceException(rESyntaxException);
        }
    }

    public String getMaskMessage() {
        return this.maskMessage;
    }

    public void setMaskMessage(String string) {
        this.maskMessage = string;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int n) {
        this.minLength = n;
    }

    public String getMinLengthMessage() {
        return this.minLengthMessage;
    }

    public void setMinLengthMessage(String string) {
        this.minLengthMessage = string;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
    }

    public String getMaxLengthMessage() {
        return this.maxLengthMessage;
    }

    public void setMaxLengthMessage(String string) {
        this.maxLengthMessage = string;
    }
}

