/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.mimetype;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.mimetype.MimeTypeService;
import org.apache.fulcrum.mimetype.util.CharSetMap;
import org.apache.fulcrum.mimetype.util.MimeType;
import org.apache.fulcrum.mimetype.util.MimeTypeMap;

public class TurbineMimeTypeService
extends BaseService
implements MimeTypeService {
    public static final String MIME_TYPES = "mime.types";
    public static final String CHARSETS = "charsets";
    private MimeTypeMap mimeTypeMap;
    private CharSetMap charSetMap;

    public void init() throws InitializationException {
        String string = null;
        if (this.getConfiguration() != null && (string = this.getConfiguration().getString(MIME_TYPES)) != null) {
            string = this.getRealPath(string);
        }
        if (string != null) {
            try {
                this.mimeTypeMap = new MimeTypeMap(string);
            }
            catch (IOException iOException) {
                throw new InitializationException(string, iOException);
            }
        } else {
            this.mimeTypeMap = new MimeTypeMap();
        }
        if (this.getConfiguration() != null && (string = this.getConfiguration().getString(CHARSETS)) != null) {
            string = this.getRealPath(string);
        }
        if (string != null) {
            try {
                this.charSetMap = new CharSetMap(string);
            }
            catch (IOException iOException) {
                throw new InitializationException(string, iOException);
            }
        } else {
            this.charSetMap = new CharSetMap();
        }
        this.setInit(true);
    }

    public void setContentType(String string) {
        this.mimeTypeMap.setContentType(string);
    }

    public String getContentType(File file) {
        return this.mimeTypeMap.getContentType(file);
    }

    public String getContentType(String string) {
        return this.mimeTypeMap.getContentType(string);
    }

    public String getContentType(String string, String string2) {
        return this.mimeTypeMap.getContentType(string, string2);
    }

    public MimeType getMimeContentType(File file) {
        return this.mimeTypeMap.getMimeContentType(file);
    }

    public MimeType getMimeContentType(String string) {
        return this.mimeTypeMap.getMimeContentType(string);
    }

    public MimeType getMimeContentType(String string, String string2) {
        return this.mimeTypeMap.getMimeContentType(string, string2);
    }

    public String getDefaultExtension(String string) {
        return this.mimeTypeMap.getDefaultExtension(string);
    }

    public String getDefaultExtension(MimeType mimeType) {
        return this.mimeTypeMap.getDefaultExtension(mimeType);
    }

    public void setCharSet(String string, String string2) {
        this.charSetMap.setCharSet(string, string2);
    }

    public String getCharSet(Locale locale) {
        return this.charSetMap.getCharSet(locale);
    }

    public String getCharSet(Locale locale, String string) {
        return this.charSetMap.getCharSet(locale, string);
    }

    public String getCharSet(String string) {
        return this.charSetMap.getCharSet(string);
    }

    public String getCharSet(String string, String string2) {
        return this.charSetMap.getCharSet(string, string2);
    }
}

