/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.pool;

import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.TurbineServices;
import org.apache.fulcrum.factory.FactoryService;
import org.apache.fulcrum.factory.TurbineFactoryService;
import org.apache.fulcrum.pool.ArrayCtorRecyclable;
import org.apache.fulcrum.pool.BoundedBuffer;
import org.apache.fulcrum.pool.PoolService;
import org.apache.fulcrum.pool.Recyclable;

public class TurbinePoolService
extends TurbineFactoryService
implements PoolService {
    public static final String POOL_CAPACITY = "pool.capacity";
    private int poolCapacity = 128;
    private HashMap poolRepository = new HashMap();

    public void init() throws InitializationException {
        if (this.getConfiguration() != null) {
            try {
                int n = this.getConfiguration().getInt(POOL_CAPACITY, 128);
                if (n <= 0) {
                    throw new IllegalArgumentException("Capacity must be >0");
                }
                this.poolCapacity = n;
            }
            catch (Exception exception) {
                throw new InitializationException("Failed to initialize TurbinePoolService", exception);
            }
        }
        this.setInit(true);
    }

    public Object getInstance(String string) throws ServiceException {
        Object object = this.pollInstance(string, null, null);
        return object == null ? this.getFactory().getInstance(string) : object;
    }

    public Object getInstance(String string, ClassLoader classLoader) throws ServiceException {
        Object object = this.pollInstance(string, null, null);
        return object == null ? this.getFactory().getInstance(string, classLoader) : object;
    }

    public Object getInstance(String string, Object[] objectArray, String[] stringArray) throws ServiceException {
        Object object = this.pollInstance(string, objectArray, stringArray);
        return object == null ? this.getFactory().getInstance(string, objectArray, stringArray) : object;
    }

    public Object getInstance(String string, ClassLoader classLoader, Object[] objectArray, String[] stringArray) throws ServiceException {
        Object object = this.pollInstance(string, objectArray, stringArray);
        return object == null ? this.getFactory().getInstance(string, classLoader, objectArray, stringArray) : object;
    }

    public boolean isLoaderSupported(String string) throws ServiceException {
        return this.getFactory().isLoaderSupported(string);
    }

    public Object getInstance(Class clazz) throws ServiceException {
        Object object = this.pollInstance(clazz.getName(), null, null);
        return object == null ? super.getInstance(clazz) : object;
    }

    public Object getInstance(Class clazz, Object[] objectArray, String[] stringArray) throws ServiceException {
        Object object = this.pollInstance(clazz.getName(), objectArray, stringArray);
        return object == null ? super.getInstance(clazz, objectArray, stringArray) : object;
    }

    public boolean putInstance(Object object) {
        if (object != null) {
            HashMap hashMap = this.poolRepository;
            String string = object.getClass().getName();
            PoolBuffer poolBuffer = (PoolBuffer)hashMap.get(string);
            if (poolBuffer == null) {
                poolBuffer = new PoolBuffer(this.getCapacity(string));
                hashMap = (HashMap)hashMap.clone();
                hashMap.put(string, poolBuffer);
                this.poolRepository = hashMap;
                if (object instanceof ArrayCtorRecyclable) {
                    poolBuffer.setArrayCtorRecyclable(true);
                }
            }
            return poolBuffer.offer(object);
        }
        return false;
    }

    public int getCapacity(String string) {
        PoolBuffer poolBuffer = (PoolBuffer)this.poolRepository.get(string);
        if (poolBuffer == null) {
            int n = this.poolCapacity;
            if (this.getConfiguration() != null) {
                try {
                    n = this.getConfiguration().getInt("pool.capacity." + string, this.poolCapacity);
                    if (n <= 0) {
                        n = this.poolCapacity;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return n;
        }
        return poolBuffer.capacity();
    }

    public void setCapacity(String string, int n) {
        HashMap<String, PoolBuffer> hashMap = this.poolRepository;
        hashMap = hashMap != null ? (HashMap)hashMap.clone() : new HashMap<String, PoolBuffer>();
        hashMap.put(string, new PoolBuffer(n));
        this.poolRepository = hashMap;
    }

    public int getSize(String string) {
        PoolBuffer poolBuffer = (PoolBuffer)this.poolRepository.get(string);
        return poolBuffer != null ? poolBuffer.size() : 0;
    }

    public void clearPool(String string) {
        HashMap hashMap = this.poolRepository;
        if (hashMap.get(string) != null) {
            hashMap = (HashMap)hashMap.clone();
            hashMap.remove(string);
            this.poolRepository = hashMap;
        }
    }

    public void clearPool() {
        this.poolRepository = new HashMap();
    }

    private Object pollInstance(String string, Object[] objectArray, String[] stringArray) throws ServiceException {
        PoolBuffer poolBuffer = (PoolBuffer)this.poolRepository.get(string);
        return poolBuffer != null ? poolBuffer.poll(objectArray, stringArray) : null;
    }

    private FactoryService getFactory() {
        return (FactoryService)TurbineServices.getInstance().getService("FactoryService");
    }

    private class PoolBuffer {
        private BoundedBuffer pool;
        private boolean arrayCtorRecyclable;
        private ArrayList recyclers;

        public PoolBuffer(int n) {
            this.pool = new BoundedBuffer(n);
        }

        public void setArrayCtorRecyclable(boolean bl) {
            this.arrayCtorRecyclable = bl;
        }

        public Object poll(Object[] objectArray, String[] stringArray) throws ServiceException {
            Object object;
            block12: {
                object = this.pool.poll();
                if (object != null) {
                    if (this.arrayCtorRecyclable) {
                        ((ArrayCtorRecyclable)object).recycle(objectArray);
                    } else if (object instanceof Recyclable) {
                        try {
                            if (stringArray != null && stringArray.length > 0) {
                                Method method = this.getRecycle(stringArray);
                                if (method == null) {
                                    PoolBuffer poolBuffer = this;
                                    synchronized (poolBuffer) {
                                        method = this.getRecycle(stringArray);
                                        if (method == null) {
                                            Class<?> clazz = object.getClass();
                                            method = clazz.getMethod("recycle", TurbinePoolService.super.getSignature(clazz, objectArray, stringArray));
                                            ArrayList arrayList = this.recyclers != null ? (ArrayList)this.recyclers.clone() : new ArrayList();
                                            arrayList.add(new Recycler(method, stringArray));
                                            this.recyclers = arrayList;
                                        }
                                    }
                                }
                                method.invoke(object, objectArray);
                                break block12;
                            }
                            ((Recyclable)object).recycle();
                        }
                        catch (Exception exception) {
                            throw new ServiceException("Recycling failed for " + object.getClass().getName(), exception);
                        }
                    }
                }
            }
            return object;
        }

        public boolean offer(Object object) {
            if (object instanceof Recyclable) {
                try {
                    ((Recyclable)object).dispose();
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return this.pool.offer(object);
        }

        public int capacity() {
            return this.pool.capacity();
        }

        public int size() {
            return this.pool.size();
        }

        private Method getRecycle(String[] stringArray) {
            ArrayList arrayList = this.recyclers;
            if (arrayList != null) {
                Iterator iterator = ((AbstractList)arrayList).iterator();
                while (iterator.hasNext()) {
                    Method method = ((Recycler)iterator.next()).match(stringArray);
                    if (method == null) continue;
                    return method;
                }
            }
            return null;
        }

        private class Recycler {
            private final Method recycle;
            private final String[] signature;

            public Recycler(Method method, String[] stringArray) {
                this.recycle = method;
                this.signature = stringArray != null && stringArray.length > 0 ? stringArray : null;
            }

            public Method match(String[] stringArray) {
                if (stringArray != null && stringArray.length > 0) {
                    if (this.signature != null && stringArray.length == this.signature.length) {
                        int n = 0;
                        while (n < this.signature.length) {
                            if (!this.signature[n].equals(stringArray[n])) {
                                return null;
                            }
                            ++n;
                        }
                        return this.recycle;
                    }
                    return null;
                }
                if (this.signature == null) {
                    return this.recycle;
                }
                return null;
            }
        }
    }
}

