/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.impl.db.entity;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Hashtable;
import org.apache.fulcrum.security.TurbineSecurity;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbineUser;
import org.apache.fulcrum.security.session.SessionBindingEvent;

public class TurbineUser
extends BaseTurbineUser
implements User {
    private Date lastAccessDate = null;
    private Hashtable permStorage = null;
    private Hashtable tempStorage = null;

    public TurbineUser() {
        this.setCreateDate(new Date());
        this.tempStorage = new Hashtable(10);
        this.setHasLoggedIn(Boolean.FALSE);
    }

    public int getAccessCounter() {
        try {
            return (Integer)this.getPerm("_access_counter");
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getAccessCounterForSession() {
        try {
            return (Integer)this.getTemp("_session_access_counter");
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void incrementAccessCounter() {
        this.setAccessCounter(this.getAccessCounter() + 1);
    }

    public void incrementAccessCounterForSession() {
        this.setAccessCounterForSession(this.getAccessCounterForSession() + 1);
    }

    public void setAccessCounter(int n) {
        this.setPerm("_access_counter", new Integer(n));
    }

    public void setAccessCounterForSession(int n) {
        this.setTemp("_session_access_counter", new Integer(n));
    }

    public boolean isConfirmed() {
        String string = this.getConfirmed();
        return string != null && string.equals("CONFIRMED");
    }

    public boolean hasLoggedIn() {
        Boolean bl = this.getHasLoggedIn();
        return bl != null && bl != false;
    }

    public void setHasLoggedIn(Boolean bl) {
        this.setTemp("_has_logged_in", bl);
    }

    private Boolean getHasLoggedIn() {
        return (Boolean)this.getTemp("_has_logged_in");
    }

    public Date getLastAccessDate() {
        if (this.lastAccessDate == null) {
            this.setLastAccessDate();
        }
        return this.lastAccessDate;
    }

    public void setLastAccessDate() {
        this.lastAccessDate = new Date();
    }

    public Object getPerm(String string) {
        return this.permStorage.get(string);
    }

    public Object getPerm(String string, Object object) {
        try {
            Object v = this.permStorage.get(string);
            return v == null ? object : v;
        }
        catch (Exception exception) {
            return object;
        }
    }

    public Hashtable getPermStorage() {
        if (this.permStorage == null) {
            this.permStorage = new Hashtable();
        }
        return this.permStorage;
    }

    public void setPerm(String string, Object object) {
        TurbineUser.safeAddToHashtable(this.getPermStorage(), string, object);
    }

    public void setPermStorage(Hashtable hashtable) {
        this.permStorage = hashtable;
    }

    public Object getTemp(String string) {
        return this.tempStorage.get(string);
    }

    public Object getTemp(String string, Object object) {
        Object object2;
        try {
            object2 = this.tempStorage.get(string);
            if (object2 == null) {
                object2 = object;
            }
        }
        catch (Exception exception) {
            object2 = object;
        }
        return object2;
    }

    public Hashtable getTempStorage() {
        if (this.tempStorage == null) {
            this.tempStorage = new Hashtable();
        }
        return this.tempStorage;
    }

    public Object removeTemp(String string) {
        return this.tempStorage.remove(string);
    }

    public void setTemp(String string, Object object) {
        TurbineUser.safeAddToHashtable(this.tempStorage, string, object);
    }

    public void setTempStorage(Hashtable hashtable) {
        this.tempStorage = hashtable;
    }

    public void updateLastLogin() throws Exception {
        this.setPerm("LAST_LOGIN", new Date());
    }

    public void valueBound(SessionBindingEvent sessionBindingEvent) {
    }

    public void valueUnbound(SessionBindingEvent sessionBindingEvent) {
        try {
            if (this.hasLoggedIn()) {
                TurbineSecurity.saveUser(this);
            }
        }
        catch (Exception exception) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            exception.printStackTrace(new PrintWriter(byteArrayOutputStream, true));
            String string = byteArrayOutputStream.toString();
            System.out.println(string);
        }
    }

    public void setName(String string) {
        this.setUserName(string);
    }

    public String getName() {
        return this.getUserName();
    }

    public static final void safeAddToHashtable(Hashtable hashtable, Object object, Object object2) throws NullPointerException {
        if (object2 == null) {
            hashtable.put(object, "");
        } else {
            hashtable.put(object, object2);
        }
    }
}

