/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.Strings;
import org.apache.commons.mail.SimpleEmail;
import org.apache.fulcrum.template.TemplateContext;
import org.apache.fulcrum.template.TurbineTemplate;

public class TemplateEmail {
    private String toName = null;
    private String toEmail = null;
    private String fromName = null;
    private String fromEmail = null;
    private String ccName = null;
    private String ccEmail = null;
    private String subject = null;
    private List toList = null;
    private List ccList = null;
    private int wordWrap = 0;
    private String template = null;
    private TemplateContext context = null;

    public TemplateEmail() {
        this(null);
    }

    public TemplateEmail(TemplateContext templateContext) {
        this.context = templateContext;
    }

    public void addTo(String string, String string2) throws Exception {
        try {
            if (string2 == null || string2.trim().equals("")) {
                string2 = string;
            }
            if (this.toList == null) {
                this.toList = new ArrayList();
            }
            this.toList.add(new InternetAddress(string, string2));
        }
        catch (Exception exception) {
            throw new Exception("Cannot add 'To' recipient: " + exception);
        }
    }

    public void addCc(String string, String string2) throws Exception {
        try {
            if (string2 == null || string2.trim().equals("")) {
                string2 = string;
            }
            if (this.ccList == null) {
                this.ccList = new ArrayList();
            }
            this.ccList.add(new InternetAddress(string, string2));
        }
        catch (Exception exception) {
            throw new Exception("Cannot add 'CC' recipient: " + exception);
        }
    }

    public TemplateEmail setTo(String string, String string2) {
        this.toName = string;
        this.toEmail = string2;
        return this;
    }

    public TemplateEmail setFrom(String string, String string2) {
        this.fromName = string;
        this.fromEmail = string2;
        return this;
    }

    public TemplateEmail setCC(String string, String string2) {
        this.ccName = string;
        this.ccEmail = string2;
        return this;
    }

    public TemplateEmail setSubject(String string) {
        this.subject = string == null ? "" : string;
        return this;
    }

    public TemplateEmail setTemplate(String string) {
        this.template = string;
        return this;
    }

    public TemplateEmail setWordWrap(int n) {
        this.wordWrap = n;
        return this;
    }

    public TemplateEmail setContext(TemplateContext templateContext) {
        this.context = templateContext;
        return this;
    }

    public TemplateContext getContext() {
        return this.context;
    }

    public void send() throws Exception {
        if (this.toEmail == null || this.toName == null) {
            throw new Exception("Must set a To:");
        }
        String string = TurbineTemplate.handleRequest(this.context, this.template);
        if (this.wordWrap > 0) {
            string = Strings.wrapText((String)string, (String)System.getProperty("line.separator"), (int)this.wordWrap);
        }
        SimpleEmail simpleEmail = new SimpleEmail();
        simpleEmail.setFrom(this.fromEmail, this.fromName);
        simpleEmail.addTo(this.toEmail, this.toName);
        if (this.ccEmail != null && this.ccName != null) {
            simpleEmail.addCc(this.ccEmail, this.ccName);
        }
        simpleEmail.setSubject(this.subject);
        simpleEmail.setMsg(string);
        simpleEmail.send();
    }

    public void sendMultiple() throws Exception {
        if (this.toList == null || this.toList.isEmpty()) {
            throw new Exception("Must set a To:");
        }
        String string = TurbineTemplate.handleRequest(this.context, this.template);
        if (this.wordWrap > 0) {
            string = Strings.wrapText((String)string, (String)System.getProperty("line.separator"), (int)this.wordWrap);
        }
        SimpleEmail simpleEmail = new SimpleEmail();
        simpleEmail.setFrom(this.fromEmail, this.fromName);
        simpleEmail.setTo((Collection)this.toList);
        if (this.ccList != null && !this.ccList.isEmpty()) {
            simpleEmail.setCc((Collection)this.ccList);
        }
        simpleEmail.setSubject(this.subject);
        simpleEmail.setMsg(string);
        simpleEmail.send();
    }

    public String toString() {
        try {
            this.send();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

