/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.util.parser;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.fulcrum.pool.Recyclable;
import org.apache.fulcrum.util.parser.BaseValueParser;
import org.apache.fulcrum.util.parser.CookieParser;
import org.apache.log4j.Category;

public class DefaultCookieParser
extends BaseValueParser
implements CookieParser,
Recyclable {
    private HttpServletRequest request;
    private HttpServletResponse response;
    Category category = Category.getInstance((String)this.getClass().getName());

    public void dispose() {
        this.request = null;
        super.dispose();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.clear();
        String string = httpServletRequest.getCharacterEncoding();
        this.setCharacterEncoding(string != null ? string : "US-ASCII");
        Cookie[] cookieArray = httpServletRequest.getCookies();
        this.category.info((Object)("Number of Cookies " + cookieArray.length));
        int n = 0;
        while (n < cookieArray.length) {
            String string2 = this.convert(cookieArray[n].getName());
            String string3 = cookieArray[n].getValue();
            this.category.info((Object)("Adding " + string2 + "=" + string3));
            this.add(string2, string3);
            ++n;
        }
        this.request = httpServletRequest;
        this.response = httpServletResponse;
    }

    public void set(String string, String string2) {
        this.set(string, string2, -1);
    }

    public void set(String string, String string2, int n) {
        if (this.response == null) {
            throw new IllegalStateException("Servlet response not available");
        }
        Cookie cookie = new Cookie(string, string2);
        cookie.setMaxAge(n);
        cookie.setPath(this.request.getServletPath());
        this.response.addCookie(cookie);
    }

    public void unset(String string) {
        this.set(string, " ", 0);
    }
}

