/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.common;

import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public abstract class ALAbstractMultiFilterSelectData<M1, M2>
extends ALAbstractSelectData<M1, M2> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALAbstractMultiFilterSelectData.class.getName());
    protected Map<String, List<String>> current_filterMap;

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.parseFilterMap(rundata, context);
    }

    @Override
    public void initField() {
    }

    protected void parseFilterMap(String key, String val) {
        if (this.current_filterMap == null) {
            this.current_filterMap = new HashMap<String, List<String>>();
        }
        if (key == null || val == null) {
            return;
        }
        String[] keys = key.split(",");
        String[] vals = val.split(",");
        this.current_filterMap.clear();
        int n = Math.min(keys.length, vals.length);
        for (int i = 0; i < n; ++i) {
            if (keys[i] == null || "".equals(keys[i]) || vals[i] == null || "".equals(vals[i])) continue;
            ArrayList<String> childs = new ArrayList<String>(Arrays.asList(vals[i].trim().split(" ")));
            if (this.current_filterMap.containsKey(keys[i])) {
                List<String> exists = this.current_filterMap.get(keys[i]);
                exists.addAll(childs);
                this.current_filterMap.put(keys[i], exists);
                continue;
            }
            this.current_filterMap.put(keys[i], childs);
        }
    }

    protected void parseFilterMap(RunData rundata, Context context) {
        String filter = ALEipUtils.getTemp(rundata, context, this.LIST_FILTER_STR);
        String filter_type = ALEipUtils.getTemp(rundata, context, this.LIST_FILTER_TYPE_STR);
        this.current_filter = filter;
        this.current_filter_type = filter_type;
        this.parseFilterMap(filter_type, filter);
    }

    @Override
    protected SelectQuery<M1> buildSelectQueryForFilter(SelectQuery<M1> query, RunData rundata, Context context) {
        Attributes map = this.getColumnMap();
        String crt_key = null;
        for (Map.Entry<String, List<String>> pair : this.current_filterMap.entrySet()) {
            String type = pair.getKey();
            List<String> param = pair.getValue();
            crt_key = map.getValue(type);
            if (crt_key == null || param.size() <= 0) continue;
            Expression exp = ExpressionFactory.inDbExp((String)crt_key, param);
            query.andQualifier(exp);
        }
        return query;
    }

    public boolean issetFilter() {
        return this.current_filterMap != null && !this.current_filterMap.isEmpty();
    }

    public boolean issetFilter(String key) {
        return this.issetFilter() && this.current_filterMap.containsKey(key);
    }

    public boolean issetFilter(String key, Object value) {
        return this.issetFilter(key) && this.current_filterMap.get(key).contains(value.toString());
    }

    public List<String> getFilters(String key) {
        if (this.issetFilter()) {
            return this.current_filterMap.get(key);
        }
        return null;
    }

    public String getFilter(String key, int offset) {
        List<String> filters = this.getFilters(key);
        if (filters != null && filters.size() > offset) {
            return filters.get(offset);
        }
        return null;
    }

    public String getFilter(String key) {
        return this.getFilter(key, 0);
    }

    @Override
    @Deprecated
    public String getCurrentFilterType() {
        return this.current_filter_type;
    }

    @Override
    @Deprecated
    public String getCurrentFilter() {
        return super.getCurrentSortType();
    }
}

