/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.common;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALOAuthConsumer;
import com.aimluck.eip.services.social.gadgets.ALUserPref;
import com.aimluck.eip.util.ALCommonUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ALApplication
implements ALData,
Serializable {
    private static final long serialVersionUID = -7371342588788650173L;
    private ALStringField appId;
    private ALStringField title;
    private ALStringField description;
    private ALStringField url;
    private ALStringField icon;
    private ALStringField consumerKey;
    private ALStringField consumerSecret;
    private List<ALOAuthConsumer> OAuthConsumers;
    private List<ALUserPref> userPrefs;
    private int status;

    public ALApplication() {
        this.initField();
    }

    @Override
    public void initField() {
        this.appId = new ALStringField();
        this.title = new ALStringField();
        this.description = new ALStringField();
        this.url = new ALStringField();
        this.consumerKey = new ALStringField();
        this.consumerSecret = new ALStringField();
        this.OAuthConsumers = new ArrayList<ALOAuthConsumer>();
        this.userPrefs = new ArrayList<ALUserPref>();
        this.icon = new ALStringField();
        this.status = 0;
    }

    public ALStringField getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId.setValue(appId);
    }

    public ALStringField getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.setValue(title);
    }

    public ALStringField getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description.setValue(description);
    }

    public ALStringField getUrl() {
        return this.url;
    }

    public String getUrlCR() {
        return ALCommonUtils.replaceToAutoCR(this.url.toString());
    }

    public void setUrl(String url) {
        this.url.setValue(url);
    }

    public ALStringField getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey.setValue(consumerKey);
    }

    public ALStringField getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret.setValue(consumerSecret);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void addOAuthConsumers(ALOAuthConsumer oAuthConsumers) {
        this.OAuthConsumers.add(oAuthConsumers);
    }

    public void addOAuthConsumers(List<ALOAuthConsumer> oAuthConsumers) {
        for (ALOAuthConsumer service : oAuthConsumers) {
            this.OAuthConsumers.add(service);
        }
    }

    public List<ALOAuthConsumer> getOAuthConsumers() {
        return this.OAuthConsumers;
    }

    public void setUserPrefs(List<ALUserPref> userPrefs) {
        this.userPrefs = userPrefs;
    }

    public void addUserPref(ALUserPref userPref) {
        this.userPrefs.add(userPref);
    }

    public List<ALUserPref> getUserPrefs() {
        return this.userPrefs;
    }

    public void setIcon(String icon) {
        this.icon.setValue(icon);
    }

    public ALStringField getIcon() {
        return this.icon;
    }
}

