/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.common;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALCsvTokenizer;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.upload.FileItem;
import org.apache.velocity.context.Context;

public abstract class ALCsvAbstractUploadFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALCsvAbstractUploadFormData.class.getName());
    private final int FIELD_ATTACHMENT_MAX_LEN = 128;
    private FileItem attachmentItem = null;
    private ALStringField attachmentName = null;
    protected int page_count;
    protected int line_count;

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.page_count = 0;
        this.line_count = 0;
    }

    public abstract String getTempFilePath();

    @Override
    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        ParameterParser parser = rundata.getParameters();
        this.attachmentItem = parser.getFileItem("attachment");
        if (this.attachmentItem != null) {
            if (this.attachmentItem.getSize() > 0L) {
                this.attachmentName.setValue(this.attachmentItem.getName());
                return true;
            }
            msgList.add(ALLocalizationUtils.getl10n("COMMON_NOT_ADD_FILE_ZERO_KB"));
            return false;
        }
        msgList.add(ALLocalizationUtils.getl10n("COMMON_NO_FILE"));
        return false;
    }

    @Override
    protected void setValidator() {
        this.attachmentName.setNotNull(true);
        this.attachmentName.limitMaxLength(128);
        this.attachmentName.setCharacterType(0);
    }

    @Override
    protected boolean validate(List<String> msgList) {
        this.attachmentName.validate(msgList);
        return msgList.size() == 0;
    }

    @Override
    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        return true;
    }

    @Override
    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    @Override
    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            String filepath = this.getTempFilePath();
            ALStorageService.createNewFile(this.attachmentItem.getInputStream(), filepath);
            ALCsvTokenizer reader = new ALCsvTokenizer();
            if (!reader.init(filepath)) {
                return false;
            }
            try {
                this.page_count = 0;
                this.line_count = 0;
                while (reader.eof != -1) {
                    for (int i = 0; i < 1000; ++i) {
                        while (reader.eof != -1) {
                            reader.nextToken();
                            if (reader.eof != -1 && !reader.line) continue;
                        }
                        if (reader.eof == -1) break;
                        ++this.line_count;
                    }
                    ++this.page_count;
                }
            }
            catch (Exception e) {
            }
        }
        catch (Exception ex) {
            logger.error((Object)"ALCsvAbstractUploadFormData.updateFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    @Override
    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            ALStorageService.deleteFile(this.getTempFilePath());
        }
        catch (Exception ex) {
            logger.error((Object)"ALCsvAbstractUploadFormData.deleteFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    @Override
    public void initField() {
        this.attachmentName = new ALStringField();
        this.attachmentName.setFieldName(ALLocalizationUtils.getl10n("COMMON_CSV_FILE_NAME"));
        this.attachmentName.setTrim(true);
    }

    public int getPageCount() {
        return this.page_count;
    }

    public int getLineCount() {
        return this.line_count;
    }
}

