/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.actions;

import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.http.ServletContextLocator;
import com.aimluck.eip.services.config.ALConfigHandler;
import com.aimluck.eip.services.config.ALConfigService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.modules.ActionEvent;
import org.apache.turbine.util.RunData;

public class ALJLogoutUser
extends ActionEvent {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALJLogoutUser.class.getName());

    public void doPerform(RunData data) throws Exception {
        ALEipUser logoutuser;
        String username = data.getParameters().getString("user");
        if (JetspeedResources.getBoolean((String)"automatic.logon.enable", (boolean)false)) {
            Cookie userName = new Cookie("username", "");
            Cookie loginCookie = new Cookie("logincookie", "");
            String comment = JetspeedResources.getString((String)"automatic.logon.cookie.comment", (String)"");
            String domain = JetspeedResources.getString((String)"automatic.logon.cookie.domain");
            String path = JetspeedResources.getString((String)"automatic.logon.cookie.path", (String)"/");
            if (domain == null) {
                String server = data.getServerName();
                domain = "." + server;
            }
            userName.setMaxAge(0);
            userName.setComment(comment);
            userName.setDomain(domain);
            userName.setPath(path);
            loginCookie.setMaxAge(0);
            loginCookie.setComment(comment);
            loginCookie.setDomain(domain);
            loginCookie.setPath(path);
            data.getResponse().addCookie(userName);
            data.getResponse().addCookie(loginCookie);
            if (data.getRequest().getCookies() != null) {
                data.getCookies().remove("logincookie");
                data.getCookies().remove("username");
            }
        }
        if (JetspeedResources.getBoolean((String)"automatic.logout.save", (boolean)false)) {
            JetspeedSecurity.saveUser((JetspeedUser)((JetspeedUser)data.getUserFromSession()));
        }
        JetspeedSecurity.logout();
        if (username != null && !"".equals(username) && (logoutuser = ALEipUtils.getALEipUser(username)) != null) {
            int logoutUserId = (int)logoutuser.getUserId().getValue();
            ALEventlogFactoryService.getInstance().getEventlogHandler().logLogout(logoutUserId);
        }
        data.setMessage(JetspeedResources.getString((String)"logout.message"));
        JetspeedLink jsLink = null;
        data.setScreen(JetspeedResources.getString((String)"screen.homepage"));
        try {
            jsLink = JetspeedLinkFactory.getInstance((RunData)data);
        }
        catch (Exception e) {
            logger.error((Object)"Error getting jsLink", (Throwable)e);
        }
        String externalLoginUrl = ALConfigService.get(ALConfigHandler.Property.EXTERNAL_LOGIN_URL);
        if ("".equals(externalLoginUrl)) {
            String contextPath;
            ServletContext servletContext;
            if (ALEipUtils.isCellularPhone(data)) {
                servletContext = ServletContextLocator.get();
                contextPath = servletContext.getContextPath();
                if ("".equals(contextPath)) {
                    contextPath = "/";
                }
                data.setRedirectURI(contextPath.concat("?logout=T"));
            } else {
                servletContext = ServletContextLocator.get();
                contextPath = servletContext.getContextPath();
                if ("".equals(contextPath)) {
                    contextPath = "/";
                }
                data.setRedirectURI(contextPath);
            }
        } else {
            data.setRedirectURI(externalLoginUrl);
        }
        JetspeedLinkFactory.putInstance((JetspeedLink)jsLink);
        jsLink = null;
        if (data.getSession() != null) {
            try {
                data.getSession().invalidate();
            }
            catch (IllegalStateException ex) {
                logger.debug((Object)ALLocalizationUtils.getl10n("LOGOUTACTION_ALREADY_SESSION_DELETE"));
            }
        }
    }
}

