/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.turbine.modules.screens.RawScreen;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public abstract class ALXlsScreen
extends RawScreen
implements ALAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALXlsScreen.class.getName());
    protected boolean hasAuthority;

    protected void doOutput(RunData rundata) throws Exception {
        VelocityContext context = new VelocityContext();
        try {
            this.init(rundata, (Context)context);
            this.doCheckAclPermission(rundata, (Context)context, this.getDefineAclType());
            HSSFWorkbook wb = this.createXLSFile(rundata, (Context)context);
            HttpServletResponse response = rundata.getResponse();
            response.setHeader("Content-disposition", "attachment; filename=\"" + this.getFileName() + "\"");
            response.setHeader("Cache-Control", "aipo");
            response.setHeader("Pragma", "aipo");
            if (wb != null) {
                wb.write((OutputStream)response.getOutputStream());
            }
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError(rundata);
        }
        catch (Exception e) {
            logger.error((Object)"ALXlsScreen.doOutput", (Throwable)e);
        }
    }

    public void init(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
    }

    protected HSSFWorkbook createXLSFile(RunData rundata, Context context) {
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            this.createHSSFWorkbook(rundata, context, wb);
            return wb;
        }
        catch (Exception e) {
            logger.error((Object)"ALXlsScreen.createXLSFile", (Throwable)e);
            return null;
        }
    }

    protected abstract boolean createHSSFWorkbook(RunData var1, Context var2, HSSFWorkbook var3);

    protected abstract String getFileName();

    protected HSSFSheet createHSSFSheet(HSSFWorkbook wb, String sheet_name, String[] headers, short[] cell_enc_types) {
        HSSFSheet sheet = wb.createSheet(sheet_name);
        wb.setSheetName(0, sheet_name, (short)1);
        HSSFRow row1 = sheet.createRow(0);
        int len = headers.length;
        for (int i = 0; i < len; ++i) {
            HSSFCell cell_row1 = row1.createCell((short)i);
            cell_row1.setEncoding((short)1);
            cell_row1.setCellValue(headers[i]);
        }
        return sheet;
    }

    protected void addRow(HSSFRow newrow, short[] cell_enc_types, String[] rows) {
        int len = rows.length;
        for (int j = 0; j < len; ++j) {
            HSSFCell cell_newrow = newrow.createCell((short)j);
            if (cell_enc_types[j] == 0) {
                try {
                    cell_newrow.setCellValue(Double.parseDouble(rows[j]));
                }
                catch (Exception e) {
                    cell_newrow.setCellValue("");
                }
                continue;
            }
            if (cell_enc_types[j] == 1) {
                cell_newrow.setEncoding(cell_enc_types[j]);
                cell_newrow.setCellValue(rows[j]);
                continue;
            }
            cell_newrow.setCellValue(rows[j]);
        }
    }

    protected void addFooter(HSSFRow newrow, short[] cell_enc_types, String[] rows) {
        int len = rows.length;
        for (int j = 0; j < len; ++j) {
            HSSFCell cell_newrow = newrow.createCell((short)j);
            if (cell_enc_types[j] == 0) {
                cell_enc_types[j] = 2;
                cell_newrow.setCellValue(rows[j]);
                continue;
            }
            if (cell_enc_types[j] == 1) {
                cell_newrow.setEncoding(cell_enc_types[j]);
                cell_newrow.setCellValue(rows[j]);
                continue;
            }
            cell_newrow.setCellValue(rows[j]);
        }
    }

    protected String getContentType(RunData rundata) {
        return "application/octet-stream";
    }

    @Override
    public void setResultData(Object obj) {
    }

    @Override
    public void addResultData(Object obj) {
    }

    @Override
    public void setResultDataList(List<Object> objList) {
    }

    @Override
    public void addErrorMessage(String msg) {
    }

    @Override
    public void addErrorMessages(List<String> msgs) {
    }

    @Override
    public void setErrorMessages(List<String> msgs) {
    }

    @Override
    public void setMode(String mode) {
    }

    @Override
    public String getMode() {
        return null;
    }

    @Override
    public void putData(RunData rundata, Context context) {
    }

    protected boolean doCheckAclPermission(RunData rundata, Context context, int defineAclType) throws ALPermissionException {
        if (defineAclType == 0) {
            return true;
        }
        String pfeature = this.getAclPortletFeature();
        if (pfeature == null || "".equals(pfeature)) {
            return true;
        }
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId(rundata), pfeature, defineAclType);
        if (!this.hasAuthority) {
            throw new ALPermissionException();
        }
        return true;
    }

    public boolean hasAuthority() {
        return this.hasAuthority;
    }

    protected int getDefineAclType() {
        return 32;
    }

    public String getAclPortletFeature() {
        return null;
    }
}

