/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.common.ALApplication;
import com.aimluck.eip.modules.screens.ALJSONScreen;
import com.aimluck.eip.services.social.ALApplicationService;
import com.aimluck.eip.services.social.model.ALApplicationGetRequest;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.CustomizeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import org.apache.jetspeed.om.profile.Control;
import org.apache.jetspeed.om.profile.Controller;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.IdentityElement;
import org.apache.jetspeed.om.profile.Layout;
import org.apache.jetspeed.om.profile.MetaInfo;
import org.apache.jetspeed.om.profile.Parameter;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.Reference;
import org.apache.jetspeed.om.profile.psml.PsmlControl;
import org.apache.jetspeed.om.profile.psml.PsmlController;
import org.apache.jetspeed.om.profile.psml.PsmlEntry;
import org.apache.jetspeed.om.profile.psml.PsmlLayout;
import org.apache.jetspeed.om.profile.psml.PsmlParameter;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.portal.PortletController;
import org.apache.jetspeed.portal.security.portlets.PortletWrapper;
import org.apache.jetspeed.services.PortalToolkit;
import org.apache.jetspeed.services.PortletFactory;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.idgenerator.JetspeedIdGenerator;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.jetspeed.util.PortletSessionState;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CustomizeFormJSONScreen
extends ALJSONScreen {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CustomizeFormJSONScreen.class.getName());

    @Override
    protected String getJSONString(RunData rundata, Context context) throws Exception {
        String result = new JSONArray().toString();
        try {
            String mode = rundata.getParameters().get("mode");
            if ("add".equals(mode)) {
                this.doAdd(rundata, context);
            }
            if ("delete".equals(mode)) {
                this.doDelete(rundata, context);
            }
            if ("layout".equals(mode)) {
                this.doLayout(rundata, context);
            }
            if ("page_title".equals(mode)) {
                this.doPageTitleEdit(rundata, context);
            }
        }
        catch (Exception e) {
            logger.error((Object)"CustomizeFormJSONScreen.getJSONString", (Throwable)e);
        }
        return result;
    }

    public void doPageTitleEdit(RunData rundata, Context context) throws Exception {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        Profile profile = jdata.getProfile();
        String pid = rundata.getParameters().get("portlet_id");
        Portlets portlets = profile.getDocument().getPortletsById(pid);
        this.setController(rundata, context, portlets);
        this.editPageTitle(rundata, context);
        if (portlets != null) {
            this.doSaveAddAction(rundata, context, portlets);
        }
        SessionState customizationState = ((JetspeedRunData)rundata).getPageSessionState();
        customizationState.setAttribute("customize-mode", (Object)"layout");
    }

    private void editPageTitle(RunData rundata, Context context) {
        String pid = rundata.getParameters().get("portlet_id");
        Portlets[] portletArrays = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets().getPortletsArray();
        String pageTitle = rundata.getParameters().getString("pageTitle");
        if (pageTitle != null && pageTitle.length() > 0 && !"\u30de\u30a4\u30da\u30fc\u30b8".equals(pageTitle)) {
            for (Portlets p : portletArrays) {
                if (!p.getId().equals(pid)) continue;
                MetaInfo info = p.getMetaInfo();
                if (info != null) {
                    info.setTitle(pageTitle);
                }
                p.setTitle(pageTitle);
            }
        }
    }

    public void doAdd(RunData rundata, Context context) throws Exception {
        this.maintainUserSelections(rundata);
        Map<String, PortletEntry> userSelections = CustomizeUtils.getUserSelections(rundata);
        String[] pnames = new String[userSelections.size()];
        userSelections.keySet().toArray(pnames);
        PsmlControl ctrl = new PsmlControl();
        ctrl.setName("ClearPortletControl");
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        Profile profile = jdata.getProfile();
        String pid = rundata.getParameters().get("portlet_id");
        Portlets portlets = profile.getDocument().getPortletsById(pid);
        this.setController(rundata, context, portlets);
        if (pnames != null) {
            for (int i = 0; i < pnames.length; ++i) {
                boolean addIt;
                String pname = pnames[i];
                PortletEntry entry = null;
                boolean isGadgets = false;
                ALApplication app = null;
                if (pname.startsWith("GadgetsTemplate::")) {
                    String[] split = pname.split("::");
                    String appId = split[1];
                    app = ALApplicationService.get(new ALApplicationGetRequest().withAppId(appId));
                    entry = (PortletEntry)Registry.getEntry((String)Registry.PORTLET, (String)"GadgetsTemplate");
                    isGadgets = true;
                } else {
                    entry = (PortletEntry)Registry.getEntry((String)Registry.PORTLET, (String)pnames[i]);
                }
                if (!ALEipUtils.getHasAuthority(rundata, context, 4) || entry == null || portlets == null || !(addIt = true)) continue;
                PsmlEntry p = new PsmlEntry();
                p.setParent(isGadgets ? "GadgetsTemplate" : pnames[i]);
                p.setId(JetspeedIdGenerator.getNextPeid());
                if (isGadgets) {
                    p.setTitle(app.getTitle().getValue());
                    PsmlParameter p1 = new PsmlParameter();
                    p1.setName("aid");
                    p1.setValue(app.getAppId().getValue());
                    p.addParameter((Parameter)p1);
                    PsmlParameter p2 = new PsmlParameter();
                    p2.setName("url");
                    p2.setValue(app.getUrl().getValue());
                    p.addParameter((Parameter)p2);
                    PsmlParameter p3 = new PsmlParameter();
                    p3.setName("mid");
                    String moduleId = String.valueOf(ALApplicationService.getNextModuleId());
                    p3.setValue(moduleId);
                    p.addParameter((Parameter)p3);
                    p.setId(moduleId);
                }
                portlets.addEntry((Entry)p);
            }
        }
        this.editPageTitle(rundata, context);
        if (portlets != null) {
            this.doSaveAddAction(rundata, context, portlets);
        }
        SessionState customizationState = ((JetspeedRunData)rundata).getPageSessionState();
        customizationState.setAttribute("customize-mode", (Object)"layout");
    }

    public void doDelete(RunData rundata, Context context) {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        ALEipUtils.checkAclPermissionForCustomize(rundata, context, 16);
        String portletId = rundata.getParameters().get("js_peid");
        Portlets portlets = jdata.getProfile().getDocument().getPortlets();
        Portlets[] portletList = portlets.getPortletsArray();
        if (portletList == null) {
            return;
        }
        Profile profile = jdata.getProfile();
        List<PortletEntry> normalPortlets = CustomizeUtils.buildAllPortletList(rundata, profile.getMediaType(), new ArrayList<PortletEntry>());
        ArrayList<String> editablePortlets = new ArrayList<String>();
        for (PortletEntry entry : normalPortlets) {
            editablePortlets.add(entry.getName());
        }
        try {
            String parent;
            int j;
            int ent_length;
            Entry[] entries;
            int i;
            int length = portletList.length;
            int timelineCount = 0;
            for (i = 0; i < length; ++i) {
                entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                ent_length = entries.length;
                for (j = 0; j < ent_length; ++j) {
                    parent = entries[j].getParent();
                    if (!parent.equals("Timeline")) continue;
                    ++timelineCount;
                }
            }
            block5: for (i = 0; i < length; ++i) {
                entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                ent_length = entries.length;
                for (j = 0; j < ent_length; ++j) {
                    PortletWrapper wrapper;
                    parent = entries[j].getParent();
                    if (!entries[j].getId().equals(portletId) || !editablePortlets.contains(entries[j].getParent()) && !parent.startsWith("GadgetsTemplate") || parent.equals("Timeline") && timelineCount <= 1 || (wrapper = (PortletWrapper)PortletFactory.getPortlet((Entry)entries[j])) == null) continue;
                    portletList[i].removeEntry(j);
                    break block5;
                }
            }
            profile.store();
        }
        catch (Exception e) {
            logger.error((Object)"MultiColumnControllerAction: Probably got wrong coordinates", (Throwable)e);
        }
        jdata.getUser().removeTemp("js_peid");
        rundata.setRedirectURI("/aipo/portal");
    }

    public void doLayout(RunData rundata, Context context) {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        ALEipUtils.checkAclPermissionForCustomize(rundata, context, 8);
        Portlets portlets = jdata.getProfile().getDocument().getPortlets();
        Portlets[] portletList = portlets.getPortletsArray();
        if (portletList == null) {
            return;
        }
        Profile profile = jdata.getProfile();
        List<PortletEntry> normalPortlets = CustomizeUtils.buildAllPortletList(rundata, profile.getMediaType(), new ArrayList<PortletEntry>());
        ArrayList<String> editablePortlets = new ArrayList<String>();
        for (PortletEntry entry : normalPortlets) {
            editablePortlets.add(entry.getName());
        }
        try {
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    String parent = entries[j].getParent();
                    if (!editablePortlets.contains(parent) && !parent.startsWith("GadgetsTemplate")) continue;
                    String pid = entries[j].getId();
                    int col = rundata.getParameters().getInt(pid + "_col", -1);
                    int row = rundata.getParameters().getInt(pid + "_row", -1);
                    if (col == -1 || row == -1) continue;
                    CustomizeFormJSONScreen.setPosition((IdentityElement)entries[j], col, row);
                }
            }
            profile.store();
        }
        catch (Exception e) {
            logger.error((Object)"MultiColumnControllerAction: Probably got wrong coordinates", (Throwable)e);
        }
    }

    protected void maintainUserSelections(RunData rundata) throws Exception {
        String[] pnames = rundata.getParameters().getStrings("pname");
        Map<String, PortletEntry> userSelections = CustomizeUtils.getUserSelections(rundata);
        List portlets = (List)PortletSessionState.getAttribute((RunData)rundata, (String)"session.portlets.list", null);
        if (portlets == null) {
            throw new Exception("Master Portlet List is null!");
        }
        if (pnames != null) {
            block0: for (String pname : pnames) {
                for (PortletEntry entry : portlets) {
                    String name = entry.getName();
                    if (!name.equals(pname)) continue;
                    userSelections.put(pname, userSelections.get(pname));
                    continue block0;
                }
            }
        }
        PortletSessionState.setAttribute((RunData)rundata, (String)"session.portlets.user.selections", userSelections);
    }

    public void doSaveAddAction(RunData data, Context context, Portlets portlets) {
        this.setPageLayout(data, context, portlets);
        SessionState customizationState = ((JetspeedRunData)data).getPageSessionState();
        List[] columns = (List[])customizationState.getAttribute("customize-columns");
        for (int col = 0; col < columns.length; ++col) {
            for (int row = 0; row < columns[col].size(); ++row) {
                CustomizeFormJSONScreen.setPosition((IdentityElement)columns[col].get(row), col, row);
            }
        }
        try {
            ((JetspeedRunData)data).getProfile().store();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to save profile ", (Throwable)e);
        }
    }

    protected static void setPosition(IdentityElement identityElement, int col, int row) {
        boolean colFound = false;
        boolean rowFound = false;
        if (identityElement != null) {
            Layout layout = identityElement.getLayout();
            if (layout == null) {
                layout = new PsmlLayout();
                identityElement.setLayout(layout);
            }
            for (int i = 0; i < layout.getParameterCount(); ++i) {
                Parameter p = layout.getParameter(i);
                if (p.getName().equals("column")) {
                    p.setValue(String.valueOf(col));
                    colFound = true;
                    continue;
                }
                if (!p.getName().equals("row")) continue;
                p.setValue(String.valueOf(row));
                rowFound = true;
            }
            if (!colFound) {
                PsmlParameter p = new PsmlParameter();
                p.setName("column");
                p.setValue(String.valueOf(col));
                layout.addParameter((Parameter)p);
            }
            if (!rowFound) {
                PsmlParameter p = new PsmlParameter();
                p.setName("row");
                p.setValue(String.valueOf(row));
                layout.addParameter((Parameter)p);
            }
        }
    }

    private void setPageLayout(RunData rundata, Context context, Portlets portlets) {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        SessionState customizationState = jdata.getPageSessionState();
        Object[] columns = (List[])customizationState.getAttribute("customize-columns");
        String controllerName = portlets.getController().getName();
        int colNum = 2;
        if (controllerName.startsWith("One")) {
            colNum = 1;
        } else if (controllerName.startsWith("Three")) {
            colNum = 3;
        }
        Portlets set = portlets;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MultiCol: columns " + Arrays.toString(columns) + " set " + set));
        }
        if (columns != null && columns.length == colNum) {
            int eCount = 0;
            for (int i = 0; i < columns.length; ++i) {
                eCount += columns[i].size();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("MultiCol: eCount " + eCount + " setCount" + set.getEntryCount() + set.getPortletsCount()));
            }
            if (eCount != set.getEntryCount() + set.getPortletsCount()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"MultiCol: rebuilding columns ");
                }
                columns = CustomizeUtils.buildColumns(set, colNum);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"MultiCol: rebuilding columns ");
            }
            columns = CustomizeUtils.buildColumns(set, colNum);
        }
        customizationState.setAttribute("customize-columns", (Object)columns);
        context.put("portlets", (Object)columns);
        HashMap<String, String> titles = new HashMap<String, String>();
        for (int col = 0; col < columns.length; ++col) {
            for (int row = 0; row < columns[col].size(); ++row) {
                IdentityElement identityElement = (IdentityElement)columns[col].get(row);
                MetaInfo metaInfo = identityElement.getMetaInfo();
                if (metaInfo != null && metaInfo.getTitle() != null) {
                    titles.put(identityElement.getId(), metaInfo.getTitle());
                    continue;
                }
                if (identityElement instanceof Entry) {
                    Entry entry = (Entry)identityElement;
                    PortletEntry pentry = (PortletEntry)Registry.getEntry((String)Registry.PORTLET, (String)entry.getParent());
                    if (pentry != null && pentry.getTitle() != null) {
                        titles.put(entry.getId(), pentry.getTitle());
                        continue;
                    }
                    titles.put(entry.getId(), entry.getParent());
                    continue;
                }
                if (identityElement instanceof Reference) {
                    titles.put(identityElement.getId(), Localization.getString((RunData)rundata, (String)"CUSTOMIZER_REF_DEFAULTTITLE"));
                    continue;
                }
                titles.put(identityElement.getId(), Localization.getString((RunData)rundata, (String)"CUSTOMIZER_NOTITLESET"));
            }
        }
        HashMap<String, String> descriptions = new HashMap<String, String>();
        for (int col = 0; col < columns.length; ++col) {
            for (int row = 0; row < columns[col].size(); ++row) {
                IdentityElement identityElement = (IdentityElement)columns[col].get(row);
                MetaInfo metaInfo = identityElement.getMetaInfo();
                if (metaInfo != null && metaInfo.getDescription() != null) {
                    descriptions.put(identityElement.getId(), metaInfo.getDescription());
                    continue;
                }
                if (!(identityElement instanceof Entry)) continue;
                Entry entry = (Entry)identityElement;
                PortletEntry pentry = (PortletEntry)Registry.getEntry((String)Registry.PORTLET, (String)entry.getParent());
                if (pentry != null && pentry.getDescription() != null) {
                    descriptions.put(entry.getId(), pentry.getDescription());
                    continue;
                }
                descriptions.put(entry.getId(), entry.getParent());
            }
        }
    }

    private void setController(RunData rundata, Context context, Portlets portlets) {
        ALEipUtils.checkAclPermissionForCustomize(rundata, context, 8);
        try {
            PortletController pc;
            String controller = rundata.getParameters().getString("controller");
            if (controller != null && (pc = PortalToolkit.getController((String)controller)) != null) {
                Controller c = portlets.getController();
                if (c == null) {
                    c = new PsmlController();
                }
                c.setName(controller);
                portlets.setController(c);
                String linkedControl = pc.getConfig().getInitParameter("control");
                if (linkedControl != null) {
                    PsmlControl ctl = new PsmlControl();
                    ctl.setName(linkedControl);
                    portlets.setControl((Control)ctl);
                } else {
                    portlets.setControl(null);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"CustomizeFormJSONScreen.setController", (Throwable)e);
        }
    }
}

