/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.modules.screens.ALVelocityScreen;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import com.aimluck.eip.util.CustomizeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.MetaInfo;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.PortletSessionState;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CustomizeFormScreen
extends ALVelocityScreen {
    private static final String USER_SELECTIONS = "session.portlets.user.selections";
    private static final String UI_PORTLETS_SELECTED = "portletsSelected";
    private static final String PORTLET_LIST = "session.portlets.list";
    public static final String FILTER_FIELDS = "filter_fields";
    public static final String FILTER_VALUES = "filter_values";
    protected boolean hasAuthority;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CustomizeFormScreen.class.getName());

    @Override
    protected void doOutput(RunData rundata, Context context) {
        int n;
        Entry[] currentPortletEntries;
        VelocityPortlet portlet = ALEipUtils.getPortlet(rundata, context);
        if (!ALEipUtils.getHasAuthority(rundata, context, 8) && !ALEipUtils.getHasAuthority(rundata, context, 4)) {
            ALEipUtils.redirectPermissionError(rundata);
            return;
        }
        if (ALEipUtils.getHasAuthority(rundata, context, 4)) {
            context.put("insert", (Object)1);
        } else {
            context.put("insert", (Object)0);
        }
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        Profile profile = jdata.getProfile();
        String mediaType = profile.getMediaType();
        ArrayList<Entry> portletList = new ArrayList<Entry>();
        String pid = rundata.getParameters().get("js_pane");
        Portlets tabPortlets = profile.getDocument().getPortletsById(pid);
        for (Entry entry : currentPortletEntries = tabPortlets.getEntriesArray()) {
            portletList.add(entry);
        }
        context.put("runs", portletList);
        Portlets[] portletArrays = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets().getPortletsArray();
        ALStringField pageTitle = new ALStringField();
        String mypageId = "";
        for (Portlets p : portletArrays) {
            if ("\u30de\u30a4\u30da\u30fc\u30b8".equals(p.getTitle())) {
                mypageId = p.getId();
            }
            if (!p.getId().equals(pid)) continue;
            MetaInfo info = p.getMetaInfo();
            pageTitle.setValue(info.getTitle());
        }
        context.put("isMypage", (Object)"\u30de\u30a4\u30da\u30fc\u30b8".equals(pageTitle.getValue()));
        context.put("mypageId", (Object)mypageId);
        context.put("globalPortlets", ALEipUtils.getGlobalPortlets(rundata));
        context.put("pageTitle", (Object)pageTitle);
        int n2 = rundata.getParameters().getInt("start", -1);
        if (n2 < 0) {
            n = 0;
            PortletSessionState.clearAttribute((RunData)rundata, (String)USER_SELECTIONS);
            PortletSessionState.clearAttribute((RunData)rundata, (String)PORTLET_LIST);
        }
        ArrayList<PortletEntry> allPortlets = new ArrayList<PortletEntry>();
        List<PortletEntry> portlets = CustomizeUtils.buildPortletList(rundata, mediaType, allPortlets);
        Map<String, PortletEntry> userSelections = CustomizeUtils.getUserSelections(rundata);
        int size = this.getSize(portlet);
        int end = Math.min(n + size, portlets.size());
        if (n > 0) {
            context.put("prev", (Object)String.valueOf(Math.max(n - size, 0)));
        }
        if (n + size < portlets.size()) {
            context.put("next", (Object)String.valueOf(n + size));
        }
        context.put("browser", portlets.subList(n, end));
        context.put("size", (Object)size);
        context.put(UI_PORTLETS_SELECTED, userSelections);
        context.put("portlets", portlets);
        context.put("js_peid", (Object)pid);
        rundata.getParameters().setString("js_peid", pid);
        context.put("controller", (Object)tabPortlets.getController().getName());
        context.put("secid", rundata.getUser().getTemp("secid"));
        ALEipUtils.setupContext(rundata, context);
        context.put("l10n", (Object)ALLocalizationUtils.createLocalization(rundata));
        context.put("utils", (Object)new ALCommonUtils());
        context.put("client", (Object)ALEipUtils.getClient(rundata));
        String layout_template = "portlets/html/ja/ajax-customize-form.vm";
        this.setTemplate(rundata, context, layout_template);
    }

    private void addFiltersToContext(RunData data, Context context) {
        String[] filterFields = (String[])PortletSessionState.getAttribute((RunData)data, (String)FILTER_FIELDS);
        String[] filterValues = (String[])PortletSessionState.getAttribute((RunData)data, (String)FILTER_VALUES);
        if (filterFields != null && filterValues != null && filterFields.length == filterValues.length) {
            for (int i = 0; i < filterFields.length; ++i) {
                String field = filterFields[i];
                String value = filterValues[i];
                context.put(field + "_filter_value", (Object)value);
            }
        }
    }

    public int getSize(VelocityPortlet portlet) {
        int size = 30;
        try {
            size = Integer.parseInt(portlet.getPortletConfig().getInitParameter("size"));
        }
        catch (Exception e) {
            logger.debug((Object)"CustomizeSetAction: Init param 'size' not parsed");
        }
        return size;
    }

    @Override
    protected String getPortletName() {
        return "Customize";
    }
}

