/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.orm.access.trans;

import java.util.ArrayList;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.trans.SelectTranslator;

public class CustomSelectTranslator
extends SelectTranslator {
    private String customScript;
    private ColumnDescriptor[] columns;
    private String[] columnNames;
    private int offset;
    private int limit;
    private boolean isDistinct;

    public String createSqlString() throws Exception {
        String ret = null;
        ret = super.createSqlString();
        String postStr = "";
        if (this.limit > 0) {
            postStr = postStr + " LIMIT " + this.limit;
        }
        if (this.offset > 0) {
            postStr = postStr + " OFFSET " + this.offset;
        }
        if (this.customScript == null) {
            if (this.isDistinct && !ret.startsWith("SELECT DISTINCT ")) {
                ret = ret.replaceFirst("SELECT ", "SELECT DISTINCT ");
            }
            return ret + postStr;
        }
        int fromIndex = ret.indexOf(" FROM ");
        ret = String.format("SELECT %s %s", this.customScript, ret.substring(fromIndex));
        return ret + postStr;
    }

    public ColumnDescriptor[] getResultColumns() {
        if (this.columnNames == null || this.columnNames.length == 0) {
            if (this.columns == null || this.columns.length == 0) {
                return super.getResultColumns();
            }
            return this.columns;
        }
        ColumnDescriptor[] resultColumns = super.getResultColumns();
        ArrayList<ColumnDescriptor> list = new ArrayList<ColumnDescriptor>();
        block0: for (String columnName : this.columnNames) {
            for (ColumnDescriptor resultColumn : resultColumns) {
                if (!resultColumn.getName().equalsIgnoreCase(columnName)) continue;
                list.add(resultColumn);
                continue block0;
            }
        }
        return list.toArray(new ColumnDescriptor[list.size()]);
    }

    public void setCustomScript(String customScript) {
        this.customScript = customScript;
    }

    public void setCustomColumns(ColumnDescriptor[] columns) {
        this.columns = columns;
    }

    public void setCustomColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public void setFetchOffset(int offset) {
        this.offset = offset;
    }

    public void setFetchLimit(int limit) {
        this.limit = limit;
    }

    public void setIsDistinct(boolean isDistinct) {
        this.isDistinct = isDistinct;
    }
}

