/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.util;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.account.AipoLicense;
import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.cayenne.om.portlet.EipMFacilityGroup;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.cayenne.om.security.TurbineUserGroupRole;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALMyGroups;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.http.HttpServletRequestLocator;
import com.aimluck.eip.modules.actions.controls.Restore;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.config.ALConfigHandler;
import com.aimluck.eip.services.config.ALConfigService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.security.Principal;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.capability.CapabilityMapFactory;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Layout;
import org.apache.jetspeed.om.profile.PSMLDocument;
import org.apache.jetspeed.om.profile.Parameter;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileException;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.profile.psml.PsmlLayout;
import org.apache.jetspeed.om.profile.psml.PsmlParameter;
import org.apache.jetspeed.om.registry.ClientEntry;
import org.apache.jetspeed.om.registry.ClientRegistry;
import org.apache.jetspeed.om.registry.MediaTypeEntry;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.portal.security.portlets.PortletWrapper;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.PortletFactory;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.util.MimeType;
import org.apache.jetspeed.util.template.BaseJetspeedLink;
import org.apache.jetspeed.util.template.ContentTemplateLink;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class ALEipUtils {
    public static final String dummy_user_head = "dummy_";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALEipUtils.class.getName());
    public static String[] IPHONE_APPS = new String[]{"Timeline", "Schedule", "ExtTimecard", "Activity", "Blog", "Msgboard", "ToDo", "Cabinet", "Workflow", "Note", "Report", "WebMail", "AddressBook", "UserList", "Memo"};

    public static void setTemp(RunData rundata, Context context, String key, String value) {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        VelocityPortlet portlet = (VelocityPortlet)context.get("portlet");
        if (portlet == null) {
            String js_peid = rundata.getParameters().getString("js_peid");
            jdata.getUser().setTemp(new StringBuffer().append(js_peid).append(key).toString(), (Object)value);
        } else {
            jdata.getUser().setTemp(new StringBuffer().append(portlet.getID()).append(key).toString(), (Object)value);
        }
    }

    public static void removeTemp(RunData rundata, Context context, String key) {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        VelocityPortlet portlet = (VelocityPortlet)context.get("portlet");
        if (portlet == null) {
            String js_peid = rundata.getParameters().getString("js_peid");
            jdata.getUser().removeTemp(new StringBuffer().append(js_peid).append(key).toString());
        } else {
            jdata.getUser().removeTemp(new StringBuffer().append(portlet.getID()).append(key).toString());
        }
    }

    public static void removeTemp(RunData rundata, Context context, List<String> list) {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        VelocityPortlet portlet = (VelocityPortlet)context.get("portlet");
        int size = list.size();
        if (portlet == null) {
            String js_peid = rundata.getParameters().getString("js_peid");
            for (int i = 0; i < size; ++i) {
                jdata.getUser().removeTemp(new StringBuffer().append(js_peid).append(list.get(i).toString()).toString());
            }
        } else {
            String peid = portlet.getID();
            for (int i = 0; i < size; ++i) {
                jdata.getUser().removeTemp(new StringBuffer().append(peid).append(list.get(i).toString()).toString());
            }
        }
    }

    public static String getTemp(RunData rundata, Context context, String key) {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        Object obj = null;
        VelocityPortlet portlet = (VelocityPortlet)context.get("portlet");
        if (portlet == null) {
            String js_peid = rundata.getParameters().getString("js_peid");
            obj = jdata.getUser().getTemp(new StringBuffer().append(js_peid).append(key).toString());
        } else {
            obj = jdata.getUser().getTemp(new StringBuffer().append(portlet.getID()).append(key).toString());
        }
        return obj == null ? null : obj.toString();
    }

    public static int getEntityId(RunData rundata, Context context) {
        int entity_id = 0;
        String entity_id_str = ALEipUtils.getTemp(rundata, context, "entityid");
        try {
            entity_id = Integer.parseInt(entity_id_str);
        }
        catch (Exception e) {
            entity_id = 0;
        }
        return entity_id;
    }

    public static int getUserId(RunData rundata) {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        String id = jdata.getJetspeedUser().getUserId();
        return Integer.parseInt(id);
    }

    public static VelocityPortlet getPortlet(RunData rundata, Context context) {
        return (VelocityPortlet)context.get("portlet");
    }

    public static Portlet getPortlet(RunData rundata, String portletId) {
        try {
            Profile profile = ((JetspeedRunData)rundata).getProfile();
            if (profile == null) {
                return null;
            }
            Portlets portlets = profile.getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Iterator iterator = portlets.getEntriesIterator();
            while (iterator.hasNext()) {
                PortletWrapper activityWrapper;
                Entry next = (Entry)iterator.next();
                if (!portletId.equals(next.getId()) || (activityWrapper = (PortletWrapper)PortletFactory.getPortlet((Entry)next)) == null) continue;
                return activityWrapper.getPortlet();
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return null;
            }
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getId().equals(portletId)) continue;
                    PortletWrapper wrapper = (PortletWrapper)PortletFactory.getPortlet((Entry)entries[j]);
                    if (wrapper != null) {
                        return wrapper.getPortlet();
                    }
                    return null;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"ALEipUtils.getPortlet", (Throwable)ex);
            return null;
        }
        return null;
    }

    public static HashMap<String, String> getPortletFromAppIdMap(RunData rundata) {
        HashMap<String, String> hash = new HashMap<String, String>();
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return hash;
            }
            Iterator it = portlets.getEntriesIterator();
            while (it.hasNext()) {
                Entry next = (Entry)it.next();
                if (hash.containsKey(next.getParent())) continue;
                hash.put(next.getParent(), next.getId());
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return hash;
            }
            for (Portlets portlet : portletList) {
                Entry[] entries = portlet.getEntriesArray();
                if (entries == null) continue;
                for (Entry entry : entries) {
                    hash.put(entry.getParent(), entry.getId());
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"ALEipUtils.getPortletFromAppIdMap", (Throwable)ex);
            return hash;
        }
        return hash;
    }

    public static boolean isMatch(RunData rundata, Context context) {
        VelocityPortlet portlet = ALEipUtils.getPortlet(rundata, context);
        if (portlet == null) {
            return true;
        }
        String peid1 = portlet.getID();
        String peid2 = rundata.getParameters().getString("js_peid");
        if (peid1 == null || peid2 == null) {
            return false;
        }
        return peid1.equals(peid2);
    }

    public static List<ALEipUser> getUsers(String groupname) {
        ArrayList<ALEipUser> list = new ArrayList<ALEipUser>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("  B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME, D.POSITION ");
        statement.append("FROM turbine_user_group_role as A ");
        statement.append("LEFT JOIN turbine_user as B ");
        statement.append("  on A.USER_ID = B.USER_ID ");
        statement.append("LEFT JOIN turbine_group as C ");
        statement.append("  on A.GROUP_ID = C.GROUP_ID ");
        statement.append("LEFT JOIN eip_m_user_position as D ");
        statement.append("  on A.USER_ID = D.USER_ID ");
        statement.append("WHERE B.USER_ID > 3 AND B.DISABLED = 'F'");
        statement.append(" AND C.GROUP_NAME = #bind($groupName) ");
        statement.append("ORDER BY D.POSITION");
        String query = statement.toString();
        try {
            List<TurbineUser> list2 = Database.sql(TurbineUser.class, query).param("groupName", groupname).fetchList();
            for (TurbineUser tuser : list2) {
                list.add(ALEipUtils.getALEipUser(tuser));
            }
        }
        catch (Throwable t) {
            logger.error((Object)"ALEipUtils.getUsers", t);
        }
        return list;
    }

    public static List<ALEipUser> getUsersIncludingN(String groupname) {
        ArrayList<ALEipUser> list = new ArrayList<ALEipUser>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("  B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME, D.POSITION ");
        statement.append("FROM turbine_user_group_role as A ");
        statement.append("LEFT JOIN turbine_user as B ");
        statement.append("  on A.USER_ID = B.USER_ID ");
        statement.append("LEFT JOIN turbine_group as C ");
        statement.append("  on A.GROUP_ID = C.GROUP_ID ");
        statement.append("LEFT JOIN eip_m_user_position as D ");
        statement.append("  on A.USER_ID = D.USER_ID ");
        statement.append("WHERE B.USER_ID > 3 AND B.DISABLED != 'T'");
        statement.append(" AND C.GROUP_NAME = #bind($groupName) ");
        statement.append("ORDER BY D.POSITION");
        String query = statement.toString();
        try {
            List<TurbineUser> list2 = Database.sql(TurbineUser.class, query).param("groupName", groupname).fetchList();
            for (TurbineUser tuser : list2) {
                list.add(ALEipUtils.getALEipUser(tuser));
            }
        }
        catch (Throwable t) {
            logger.error((Object)"ALEipUtils.getUsersIncludingN", t);
        }
        return list;
    }

    public static List<Integer> getUserIds(String groupname) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("  B.USER_ID, D.POSITION ");
        statement.append("FROM turbine_user_group_role as A ");
        statement.append("LEFT JOIN turbine_user as B ");
        statement.append("  on A.USER_ID = B.USER_ID ");
        statement.append("LEFT JOIN turbine_group as C ");
        statement.append("  on A.GROUP_ID = C.GROUP_ID ");
        statement.append("LEFT JOIN eip_m_user_position as D ");
        statement.append("  on A.USER_ID = D.USER_ID ");
        statement.append("WHERE B.USER_ID > 3 AND B.DISABLED = 'F'");
        statement.append(" AND C.GROUP_NAME = #bind($groupName) ");
        statement.append("ORDER BY D.POSITION");
        String query = statement.toString();
        try {
            List<TurbineUser> list2 = Database.sql(TurbineUser.class, query).param("groupName", groupname).fetchList();
            for (TurbineUser tuser : list2) {
                list.add(tuser.getUserId());
            }
        }
        catch (Throwable t) {
            logger.error((Object)"ALEipUtils.getUsersFromPost", t);
        }
        return list;
    }

    public static List<ALEipUser> getUsersFromPost(int postid) {
        ArrayList<ALEipUser> list = new ArrayList<ALEipUser>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("  B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME, D.POSITION ");
        statement.append("FROM turbine_user_group_role as A ");
        statement.append("LEFT JOIN turbine_user as B ");
        statement.append("  on A.USER_ID = B.USER_ID ");
        statement.append("LEFT JOIN turbine_group as C ");
        statement.append("  on A.GROUP_ID = C.GROUP_ID ");
        statement.append("LEFT JOIN eip_m_user_position as D ");
        statement.append("  on A.USER_ID = D.USER_ID ");
        statement.append("WHERE B.USER_ID > 3 AND B.DISABLED = 'F'");
        statement.append(" AND B.POST_ID = #bind($postId) ");
        statement.append("ORDER BY D.POSITION");
        String query = statement.toString();
        try {
            List<TurbineUser> list2 = Database.sql(TurbineUser.class, query).param("postId", postid).fetchList();
            for (TurbineUser tuser : list2) {
                list.add(ALEipUtils.getALEipUser(tuser));
            }
        }
        catch (Throwable t) {
            logger.error((Object)"ALEipUtils.getUsersFromPost", t);
        }
        return list;
    }

    public static List<ALEipUser> getUsersFromSelectQuery(SelectQuery<TurbineUser> query) {
        ArrayList<ALEipUser> list = new ArrayList<ALEipUser>();
        try {
            List<TurbineUser> ulist = query.orderAscending("eipMUserPosition.position").fetchList();
            for (TurbineUser tuser : ulist) {
                list.add(ALEipUtils.getALEipUser(tuser));
            }
        }
        catch (Throwable t) {
            logger.error((Object)"ALEipUtils.getUsersFromSelectQuery", t);
        }
        return list;
    }

    public static ALEipUser getALEipUser(RunData rundata) {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        ALBaseUser baseuser = (ALBaseUser)jdata.getJetspeedUser();
        ALEipUser user = new ALEipUser();
        user.initField();
        user.setUserId(Integer.parseInt(baseuser.getUserId()));
        user.setName(baseuser.getUserName());
        user.setAliasName(baseuser.getFirstName(), baseuser.getLastName());
        user.setCreated(baseuser.getCreated());
        return user;
    }

    public static ALEipUser getALEipUser(int id) throws ALDBErrorException {
        TurbineUser tuser = ALEipUtils.getTurbineUser(id);
        return ALEipUtils.getALEipUser(tuser);
    }

    public static ALEipUser getALEipUser(TurbineUser tuser) throws ALDBErrorException {
        if (tuser == null) {
            return null;
        }
        ALEipUser user = new ALEipUser();
        user.initField();
        user.setUserId(tuser.getUserId());
        user.setName(tuser.getLoginName());
        user.setAliasName(tuser.getFirstName(), tuser.getLastName());
        user.setHasPhoto("T".equals(tuser.getHasPhoto()));
        user.setPhotoModified(tuser.getPhotoModified() != null ? tuser.getPhotoModified().getTime() : 0L);
        user.setCreated(tuser.getCreated());
        return user;
    }

    public static ALEipUser getALEipUser(String loginname) throws ALDBErrorException {
        TurbineUser tuser = ALEipUtils.getTurbineUser(loginname);
        if (tuser == null) {
            return null;
        }
        return ALEipUtils.getALEipUser(tuser);
    }

    public static ALBaseUser getBaseUser(Integer userid) {
        if (userid == null) {
            logger.debug((Object)"Empty ID...");
            return null;
        }
        String uid = String.valueOf(userid);
        try {
            return (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(uid));
        }
        catch (Exception ex) {
            logger.error((Object)"ALEipUtils.getBaseUser", (Throwable)ex);
            return null;
        }
    }

    public static TurbineUser getTurbineUser(int id) throws ALDBErrorException {
        Object obj = ALEipManager.getInstance().getTurbineUser(id);
        TurbineUser tuser = null;
        if (obj == null) {
            tuser = Database.get(TurbineUser.class, id);
            ALEipManager.getInstance().setTurbineUser(id, (Object)tuser);
        } else {
            tuser = (TurbineUser)obj;
        }
        return tuser;
    }

    public static TurbineUser getTurbineUser(String login_name) throws ALDBErrorException {
        Object obj = ALEipManager.getInstance().getTurbineUser(login_name);
        TurbineUser tuser = null;
        if (obj == null) {
            tuser = (TurbineUser)Database.query(TurbineUser.class).where(Operations.eq("loginName", login_name)).fetchSingle();
            ALEipManager.getInstance().setTurbineUser(login_name, (Object)tuser);
        } else {
            tuser = (TurbineUser)obj;
        }
        return tuser;
    }

    public static boolean isEnabledUser(int id) throws ALDBErrorException {
        TurbineUser tuser = ALEipUtils.getTurbineUser(id);
        if (tuser == null) {
            return false;
        }
        return "F".equals(tuser.getDisabled());
    }

    public static String getUserFullName(int userid) {
        String userName = "";
        ALBaseUser user = ALEipUtils.getBaseUser(userid);
        if (user != null) {
            userName = new StringBuffer().append(user.getLastName()).append(" ").append(user.getFirstName()).toString();
        }
        return userName;
    }

    public static boolean changePost(RunData rundata, String username, int postid) throws ALDBErrorException {
        try {
            ALBaseUser user = (ALBaseUser)JetspeedSecurity.getUser((String)username);
            JetspeedSecurity.joinGroup((String)username, (String)ALEipManager.getInstance().getPostMap().get(postid).getGroupName().getValue());
            user.setPostId(postid);
            JetspeedSecurity.saveUser((JetspeedUser)user);
            ALBaseUser currentUser = (ALBaseUser)rundata.getUser();
            if (currentUser.getUserName().equals(user.getUserName())) {
                currentUser.setPostId(user.getPostId());
            }
        }
        catch (JetspeedSecurityException ex) {
            logger.error((Object)"ALEipUtils.changePost", (Throwable)ex);
            throw new ALDBErrorException();
        }
        return true;
    }

    public static void reloadMygroup(RunData rundata) throws ALDBErrorException {
        ArrayList<ALEipGroup> ulist = new ArrayList<ALEipGroup>();
        try {
            Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId(rundata));
            List<TurbineGroup> list = Database.query(TurbineGroup.class, exp).fetchList();
            for (TurbineGroup record : list) {
                ALEipGroup group = new ALEipGroup();
                group.initField();
                group.setName(record.getGroupName());
                group.setAliasName(record.getGroupAliasName());
                ulist.add(group);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"ALEipUtils.reloadMygroup", (Throwable)ex);
            throw new ALDBErrorException();
        }
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        ALMyGroups mygroups = new ALMyGroups();
        mygroups.addList(ulist);
        jdata.getUser().setTemp("mygroup", (Object)mygroups);
    }

    public static List<ALEipGroup> getMyGroups(RunData rundata) throws ALDBErrorException {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        Object obj = jdata.getUser().getTemp("mygroup");
        if (obj == null || !(obj instanceof ALMyGroups)) {
            ALEipUtils.reloadMygroup(rundata);
            obj = jdata.getUser().getTemp("mygroup");
        }
        ALMyGroups mygroups = (ALMyGroups)obj;
        return mygroups.getList();
    }

    public static List<ALEipGroup> getFacilityGroups() {
        ArrayList<ALEipGroup> facilityGroupAllList = new ArrayList<ALEipGroup>();
        try {
            SelectQuery<EipMFacilityGroup> query = Database.query(EipMFacilityGroup.class);
            List<EipMFacilityGroup> facility_list = query.orderAscending("groupName").fetchList();
            for (EipMFacilityGroup record : facility_list) {
                ALEipGroup bean = new ALEipGroup();
                bean.initField();
                bean.setAliasName(record.getGroupName());
                bean.setName(record.getGroupId().toString());
                facilityGroupAllList.add(bean);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"ALEipUtils.getFacilityGroups", (Throwable)ex);
        }
        return facilityGroupAllList;
    }

    public static List<ALEipGroup> getALEipGroups() {
        ArrayList<ALEipGroup> facilityGroupAllList = new ArrayList<ALEipGroup>();
        try {
            SelectQuery<EipMFacilityGroup> query = Database.query(EipMFacilityGroup.class);
            List<EipMFacilityGroup> facility_list = query.orderAscending("groupName").fetchList();
            for (EipMFacilityGroup record : facility_list) {
                ALEipGroup bean = new ALEipGroup();
                bean.initField();
                bean.setAliasName(record.getGroupName());
                bean.setName(record.getGroupId().toString());
                facilityGroupAllList.add(bean);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"ALEipUtils.getALEipGroups", (Throwable)ex);
        }
        return facilityGroupAllList;
    }

    public static String getCompanyName(int id) {
        String companyName = null;
        try {
            Expression exp = ExpressionFactory.matchDbExp((String)"COMPANY_ID", (Object)id);
            List<EipMCompany> list = Database.query(EipMCompany.class, exp).select("COMPANY_NAME").fetchList();
            if (list == null || list.size() == 0) {
                logger.debug((Object)"[ALEipUtils] Not found ComapnyID...");
                return null;
            }
            EipMCompany record = list.get(0);
            companyName = record.getCompanyName();
        }
        catch (Exception ex) {
            logger.error((Object)"ALEipUtils.getCompanyName", (Throwable)ex);
            companyName = null;
        }
        return companyName;
    }

    public static String getPostName(int id) {
        if (ALEipManager.getInstance().getPostMap().containsKey(id)) {
            return ALEipManager.getInstance().getPostMap().get(id).getPostName().getValue();
        }
        return null;
    }

    public static String getPositionName(int id) {
        if (ALEipManager.getInstance().getPositionMap().containsKey(id)) {
            return ALEipManager.getInstance().getPositionMap().get(id).getPositionName().getValue();
        }
        return null;
    }

    public static boolean redirectPageNotFound(RunData rundata) {
        try {
            JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
            DynamicURI duri = jsLink.getPage();
            String template = rundata.getParameters().getString("template");
            if (template != null && !"".equals(template) && (template.endsWith("DetailScreen") || template.endsWith("FormScreen"))) {
                VelocityContext context = new VelocityContext();
                ALEipUtils.setupContext(rundata, (Context)context);
                try {
                    ServletOutputStream out = null;
                    HttpServletResponse response = rundata.getResponse();
                    out = response.getOutputStream();
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, ALEipConstants.DEF_CONTENT_ENCODING));
                    context.put("l10n", (Object)ALLocalizationUtils.createLocalization(rundata));
                    Template templete = Velocity.getTemplate((String)"screens/html/AjaxPageNotFound.vm");
                    templete.merge((Context)context, (Writer)writer);
                    writer.flush();
                    writer.close();
                }
                catch (ResourceNotFoundException e) {
                    logger.error((Object)"ALEipUtils.redirectPageNotFound", (Throwable)e);
                    throw new RuntimeException(e);
                }
                catch (ParseErrorException e) {
                    logger.error((Object)"ALEipUtils.redirectPageNotFound", (Throwable)e);
                    throw new RuntimeException(e);
                }
                catch (Exception e) {
                    logger.error((Object)"ALEipUtils.redirectPageNotFound", (Throwable)e);
                    throw new RuntimeException(e);
                }
                return true;
            }
            duri.addPathInfo("template", "PageNotFound");
            rundata.setRedirectURI(duri.toString());
            rundata.getResponse().sendRedirect(rundata.getRedirectURI());
            JetspeedLinkFactory.putInstance((JetspeedLink)jsLink);
            jsLink = null;
            return true;
        }
        catch (TurbineException e) {
            logger.error((Object)"ALEipUtils.redirectPageNotFound", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            logger.error((Object)"ALEipUtils.redirectPageNotFound", (Throwable)e);
            return false;
        }
    }

    public static boolean redirectDBError(RunData rundata) {
        try {
            JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
            DynamicURI duri = jsLink.getPage();
            String template = rundata.getParameters().getString("template");
            if (template != null && !"".equals(template) && (template.endsWith("DetailScreen") || template.endsWith("FormScreen"))) {
                Context context = TurbineVelocity.getContext((RunData)rundata);
                if (null == context) {
                    context = new VelocityContext();
                    ALEipUtils.setupContext(rundata, context);
                }
                try {
                    ServletOutputStream out = null;
                    HttpServletResponse response = rundata.getResponse();
                    out = response.getOutputStream();
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, ALEipConstants.DEF_CONTENT_ENCODING));
                    context.put("l10n", (Object)ALLocalizationUtils.createLocalization(rundata));
                    context.put("utils", (Object)new ALCommonUtils());
                    Template templete = Velocity.getTemplate((String)"screens/html/AjaxDBError.vm");
                    templete.merge(context, (Writer)writer);
                    writer.flush();
                    writer.close();
                }
                catch (ResourceNotFoundException e) {
                    logger.error((Object)"ALEipUtils.redirectDBError", (Throwable)e);
                    throw new RuntimeException(e);
                }
                catch (ParseErrorException e) {
                    logger.error((Object)"ALEipUtils.redirectDBError", (Throwable)e);
                    throw new RuntimeException(e);
                }
                catch (Exception e) {
                    logger.error((Object)"ALEipUtils.redirectDBError", (Throwable)e);
                    throw new RuntimeException(e);
                }
                return true;
            }
            duri.addPathInfo("template", "DBError");
            rundata.setRedirectURI(duri.toString());
            rundata.getResponse().sendRedirect(rundata.getRedirectURI());
            JetspeedLinkFactory.putInstance((JetspeedLink)jsLink);
            jsLink = null;
            return true;
        }
        catch (TurbineException e) {
            logger.error((Object)"ALEipUtils.redirectDBError", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            logger.error((Object)"ALEipUtils.redirectDBError", (Throwable)e);
            return false;
        }
    }

    public static boolean redirectPermissionError(RunData rundata) {
        try {
            JetspeedRunData jdata;
            JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
            DynamicURI duri = jsLink.getPage();
            String template = rundata.getParameters().getString("template");
            if (template != null && !"".equals(template)) {
                if (template.endsWith("JSONScreen")) {
                    VelocityContext context = new VelocityContext();
                    ALEipUtils.setupContext(rundata, (Context)context);
                    ServletOutputStream out = null;
                    HttpServletResponse response = rundata.getResponse();
                    out = response.getOutputStream();
                    ArrayList<String> list = new ArrayList<String>();
                    list.add("PermissionError");
                    list.add("\u30a2\u30af\u30bb\u30b9\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u30b7\u30b9\u30c6\u30e0\u7ba1\u7406\u8005\u306b\u304a\u554f\u3044\u5408\u308f\u305b\u304f\u3060\u3055\u3044\u3002");
                    JSONArray json = JSONArray.fromObject(list);
                    StringBuffer result = new StringBuffer().append("/* ").append(json.toString()).append(" */");
                    byte[] byteResult = result.toString().getBytes(ALEipConstants.DEF_CONTENT_ENCODING);
                    out.write(byteResult);
                    out.flush();
                    out.close();
                    return true;
                }
                if (template.endsWith("FormScreen") || template.endsWith("DetailScreen")) {
                    VelocityContext context = new VelocityContext();
                    ALEipUtils.setupContext(rundata, (Context)context);
                    try {
                        ServletOutputStream out = null;
                        HttpServletResponse response = rundata.getResponse();
                        out = response.getOutputStream();
                        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, ALEipConstants.DEF_CONTENT_ENCODING));
                        context.put("l10n", (Object)ALLocalizationUtils.createLocalization(rundata));
                        Template templete = Velocity.getTemplate((String)"screens/html/AjaxPermissionError.vm");
                        templete.merge((Context)context, (Writer)writer);
                        writer.flush();
                        writer.close();
                    }
                    catch (ResourceNotFoundException e) {
                        logger.error((Object)"ALEipUtils.redirectPermissionError", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    catch (ParseErrorException e) {
                        logger.error((Object)"ALEipUtils.redirectPermissionError", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    catch (Exception e) {
                        logger.error((Object)"ALEipUtils.redirectPermissionError", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    return true;
                }
                if (template.endsWith("Screen")) {
                    VelocityContext context = new VelocityContext();
                    ALEipUtils.setupContext(rundata, (Context)context);
                    try {
                        ServletOutputStream out = null;
                        HttpServletResponse response = rundata.getResponse();
                        out = response.getOutputStream();
                        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, ALEipConstants.DEF_CONTENT_ENCODING));
                        context.put("l10n", (Object)ALLocalizationUtils.createLocalization(rundata));
                        Template templete = Velocity.getTemplate((String)"portlets/html/PermissionError.vm");
                        templete.merge((Context)context, (Writer)writer);
                        writer.flush();
                        writer.close();
                    }
                    catch (Exception e) {
                        return false;
                    }
                    return true;
                }
                if (template.equals("Customize") || template.equals("Home")) {
                    duri.addPathInfo("template", "PermissionError");
                    rundata.setRedirectURI(duri.toString());
                    rundata.getResponse().sendRedirect(rundata.getRedirectURI());
                    JetspeedLinkFactory.putInstance((JetspeedLink)jsLink);
                    jsLink = null;
                    return true;
                }
                if (ALEipUtils.isCellularPhone(rundata)) {
                    duri.addPathInfo("template", "CellPermissionError");
                    rundata.setRedirectURI(duri.toString());
                    rundata.getResponse().sendRedirect(rundata.getRedirectURI());
                    JetspeedLinkFactory.putInstance((JetspeedLink)jsLink);
                    jsLink = null;
                    Restore restore = new Restore();
                    try {
                        restore.doPerform(rundata);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return true;
                }
                if (ALEipUtils.isSmartPhone(rundata)) {
                    duri.addPathInfo("template", "CellPermissionError");
                    rundata.setRedirectURI(duri.toString());
                    rundata.getResponse().sendRedirect(rundata.getRedirectURI());
                    JetspeedLinkFactory.putInstance((JetspeedLink)jsLink);
                    jsLink = null;
                    Restore restore = new Restore();
                    try {
                        restore.doPerform(rundata);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return true;
                }
            }
            if ((jdata = (JetspeedRunData)rundata).getMode() == 2) {
                rundata.getRequest().setAttribute("redirectTemplate", (Object)"permission-error-maximize");
            } else {
                Context context = (Context)jdata.getTemplateInfo().getTemplateContext("VelocityPortletContext");
                context.put("template", (Object)"PermissionError");
            }
            return true;
        }
        catch (TurbineException e) {
            logger.error((Object)"ALEipUtils.redirectPermissionError", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            logger.error((Object)"ALEipUtils.redirectPermissionError", (Throwable)e);
            return false;
        }
    }

    public static String getMessageList(String msgline) {
        StringBuffer sb = new StringBuffer();
        ALStringField field = null;
        if (msgline == null || msgline.equals("")) {
            return "";
        }
        if ((msgline = Normalizer.normalize(msgline, Normalizer.Form.NFC)).indexOf("\r") < 0 && msgline.indexOf("\n") < 0 && msgline.indexOf("\r\n") < 0) {
            field = new ALStringField();
            field.setTrim(false);
            field.setValue(msgline);
            return ALCommonUtils.replaceToAutoCR(ALEipUtils.replaceStrToLink(ALEipUtils.replaseLeftSpace(field.toString())));
        }
        String token = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new StringReader(msgline));
            while ((token = reader.readLine()) != null) {
                field = new ALStringField();
                field.setTrim(false);
                field.setValue(token);
                sb.append(ALCommonUtils.replaceToAutoCR(ALEipUtils.replaceStrToLink(ALEipUtils.replaseLeftSpace(field.toString())))).append("<br/>");
            }
            reader.close();
        }
        catch (IOException ioe) {
            try {
                reader.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return "";
        }
        int index = sb.lastIndexOf("<br/>");
        if (index == -1) {
            return sb.toString();
        }
        return sb.substring(0, index).replaceAll("<wbr/><br/>", "<br/>");
    }

    public static String replaseLeftSpace(String str) {
        if (str == null || str.length() <= 0) {
            return str;
        }
        int len = str.length();
        char[] val = str.toCharArray();
        StringBuffer sb = new StringBuffer();
        boolean left = true;
        for (int st = 0; st < len; ++st) {
            if (val[st] == ' ' && left) {
                sb.append("&nbsp;");
                continue;
            }
            sb.append(val[st]);
            left = false;
        }
        return sb.length() > 0 ? sb.toString() : str;
    }

    public static boolean isCellularPhone(RunData data) {
        MediaTypeEntry media;
        String mediatype;
        boolean isCellularPhone = false;
        CapabilityMap cm = CapabilityMapFactory.getCapabilityMap((String)data.getRequest().getHeader("User-Agent"));
        MimeType mime = cm.getPreferredType();
        if (mime != null && ("docomo_imode".equals(mediatype = (media = (MediaTypeEntry)Registry.getEntry((String)Registry.MEDIA_TYPE, (String)cm.getPreferredMediaType())).getName()) || "docomo_foma".equals(mediatype) || "au".equals(mediatype) || "vodafone".equals(mediatype))) {
            isCellularPhone = true;
        }
        return isCellularPhone;
    }

    public static boolean isSmartPhone(RunData data) {
        MediaTypeEntry media;
        String mediatype;
        boolean isSmartPhone = false;
        CapabilityMap cm = CapabilityMapFactory.getCapabilityMap((String)data.getRequest().getHeader("User-Agent"));
        MimeType mime = cm.getPreferredType();
        if (mime != null && ("iphone".equals(mediatype = (media = (MediaTypeEntry)Registry.getEntry((String)Registry.MEDIA_TYPE, (String)cm.getPreferredMediaType())).getName()) || "wm".equals(mediatype))) {
            isSmartPhone = true;
        }
        return isSmartPhone;
    }

    public static int compareToDate(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        int date1Year = cal1.get(1);
        int date1Month = cal1.get(2) + 1;
        int date1Day = cal1.get(5);
        int date1Hour = cal1.get(10);
        int date1Minute = cal1.get(12);
        int date1Second = cal1.get(13);
        int date2Year = cal2.get(1);
        int date2Month = cal2.get(2) + 1;
        int date2Day = cal2.get(5);
        int date2Hour = cal2.get(10);
        int date2Minute = cal2.get(12);
        int date2Second = cal2.get(13);
        if (date1Year == date2Year && date1Month == date2Month && date1Day == date2Day && date1Hour == date2Hour && date1Minute == date2Minute && date1Second == date2Second) {
            return 0;
        }
        if (cal1.after(cal2)) {
            return 2;
        }
        return 1;
    }

    public static Object getObjFromDataRow(DataRow dataRow, String key) {
        String lowerKey = key.toLowerCase();
        if (dataRow.containsKey((Object)lowerKey)) {
            return dataRow.get((Object)lowerKey);
        }
        return dataRow.get((Object)key.toUpperCase());
    }

    public static EipMCompany getEipMCompany(String id) {
        Expression exp = ExpressionFactory.matchDbExp((String)"COMPANY_ID", (Object)Integer.valueOf(id));
        List<EipMCompany> list = Database.query(EipMCompany.class, exp).fetchList();
        if (list == null || list.size() == 0) {
            logger.debug((Object)"Not found ID...");
            return null;
        }
        return list.get(0);
    }

    @Deprecated
    public static String getUrl(String ip, int port, String servername, boolean isGlobal) {
        if (ip == null || ip.length() == 0 || port == -1) {
            return "";
        }
        String protocol = isGlobal ? ALConfigService.get(ALConfigHandler.Property.ACCESS_GLOBAL_URL_PROTOCOL) : ALConfigService.get(ALConfigHandler.Property.ACCESS_LOCAL_URL_PROTOCOL);
        StringBuffer url = new StringBuffer();
        if (port == 80 || port == 443) {
            url.append(protocol).append("://").append(ip).append("/").append(servername).append(servername.isEmpty() ? "" : "/");
        } else {
            url.append(protocol).append("://").append(ip).append(":").append(port).append("/").append(servername).append(servername.isEmpty() ? "" : "/");
        }
        return url.toString();
    }

    public static void setupContext(RunData rundata, Context context) {
        if (!rundata.getParameters().containsKey((Object)"js_peid")) {
            return;
        }
        String js_peid = rundata.getParameters().getString("js_peid");
        Portlet portlet = ALEipUtils.getPortlet(rundata, js_peid);
        context.put("portlet", (Object)portlet);
        context.put("jslink", (Object)new BaseJetspeedLink(rundata));
        context.put("clink", (Object)new ContentTemplateLink(rundata));
    }

    public static void setupContext(String js_peid, RunData rundata, Context context) {
        Portlet portlet = ALEipUtils.getPortlet(rundata, js_peid);
        context.put("portlet", (Object)portlet);
        context.put("jslink", (Object)new BaseJetspeedLink(rundata));
        context.put("clink", (Object)new ContentTemplateLink(rundata));
    }

    public static String getParameter(RunData rundata, Context context, String key) {
        String name = null;
        String idParam = rundata.getParameters().getString(key);
        name = ALEipUtils.getTemp(rundata, context, key);
        if (idParam == null && name == null) {
            ALEipUtils.removeTemp(rundata, context, key);
            name = null;
        } else if (idParam != null) {
            ALEipUtils.setTemp(rundata, context, key, idParam);
            name = idParam;
        }
        return name;
    }

    public static String getPortletURI(RunData rundata, String portletEntryId) {
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return null;
            }
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getId().equals(portletEntryId)) continue;
                    JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
                    DynamicURI duri = jsLink.getLink(101, null, null, 101, null);
                    duri = duri.addPathInfo("js_pane", portletList[i].getId()).addPathInfo("js_peid", entries[j].getId()).addQueryData("action", "controls.Maximize");
                    return duri.toString();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"ALEipUtils.getPortletURI", (Throwable)ex);
            return null;
        }
        return null;
    }

    public static String getPortletURItoTopPage(RunData rundata, String portletEntryId) {
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return null;
            }
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getId().equals(portletEntryId)) continue;
                    JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
                    DynamicURI duri = jsLink.getLink(101, null, null, 101, null);
                    duri = duri.addPathInfo("js_pane", portletList[i].getId()).addQueryData("action", "controls.Restore");
                    return duri.toString();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"ALEipUtils.getPortletURItoTopPage", (Throwable)ex);
            return null;
        }
        return null;
    }

    public static String replaceStrToLink(String msg) {
        if (msg != null) {
            String regex = "(https?|ftp|gopher|telnet|whois|news)\\:([\\w|\\:\\!\\#\\$\\%\\=\\&\\-\\^\\`\\\\|\\@\\~\\[\\{\\]\\}\\;\\+\\*\\,\\.\\?\\/]+)";
            Pattern p = Pattern.compile(regex);
            boolean check = true;
            while (check) {
                check = false;
                Matcher m = p.matcher(msg);
                while (m.find()) {
                    if (!m.group(0).contains("@")) continue;
                    String matchString = m.group(0);
                    matchString = matchString.replaceAll("@", "%40");
                    String pre = msg.substring(0, m.start(0));
                    String post = msg.substring(m.end(0), msg.length());
                    msg = pre + matchString + post;
                    check = true;
                }
            }
            String newMsg = msg.replaceAll("(https?|ftp|gopher|telnet|whois|news)\\:([\\w|\\:\\!\\#\\$\\%\\=\\&\\-\\^\\`\\\\|\\@\\~\\[\\{\\]\\}\\;\\+\\*\\,\\.\\?\\/]+)", "<a href=\"$1\\:$2\" target=\"_blank\">$1\\:$2</a>");
            return newMsg.replaceAll("[\\w\\.\\-]+@([\\w\\-]+\\.)+[\\w\\-]+", "<a href='mailto:$0'>$0</a>");
        }
        return "";
    }

    public static List<ALStringField> getPostNameList(int id) {
        SelectQuery<TurbineUserGroupRole> query = Database.query(TurbineUserGroupRole.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"turbineUser", (Object)id);
        Expression exp2 = ExpressionFactory.greaterExp((String)"turbineGroup", (Object)3);
        Expression exp3 = ExpressionFactory.matchExp((String)"turbineGroup.ownerId", (Object)1);
        query.setQualifier(exp1);
        query.andQualifier(exp2);
        query.andQualifier(exp3);
        List<TurbineUserGroupRole> list = query.fetchList();
        ALStringField sf = null;
        ArrayList<ALStringField> postNames = new ArrayList<ALStringField>();
        for (TurbineUserGroupRole role : list) {
            sf = new ALStringField(role.getTurbineGroup().getGroupAliasName());
            postNames.add(sf);
        }
        return postNames;
    }

    public static List<Integer> getPostIdList(int id) {
        SelectQuery<TurbineUserGroupRole> query = Database.query(TurbineUserGroupRole.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"turbineUser", (Object)id);
        Expression exp2 = ExpressionFactory.greaterExp((String)"turbineGroup", (Object)3);
        Expression exp3 = ExpressionFactory.matchExp((String)"turbineGroup.ownerId", (Object)1);
        query.setQualifier(exp1);
        query.andQualifier(exp2);
        query.andQualifier(exp3);
        List<TurbineUserGroupRole> list = query.fetchList();
        ArrayList<Integer> postIds = new ArrayList<Integer>();
        for (TurbineUserGroupRole role : list) {
            postIds.add(role.getTurbineGroup().getEipMPost().getPostId());
        }
        return postIds;
    }

    public static boolean checkAclPermissionForCustomize(RunData rundata, Context context, int defineAclType) {
        try {
            if (defineAclType == 0) {
                return true;
            }
            boolean hasAuthority = ALEipUtils.getHasAuthority(rundata, context, defineAclType);
            if (!hasAuthority) {
                throw new ALPermissionException();
            }
            return true;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError(rundata);
            return false;
        }
    }

    public static boolean getHasAuthority(RunData rundata, Context context, int defineAclType) {
        String pfeature = "portlet_customize";
        if (pfeature == null || "".equals(pfeature)) {
            return true;
        }
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        return aclhandler.hasAuthority(ALEipUtils.getUserId(rundata), pfeature, defineAclType);
    }

    public static int getLimitUsers() {
        try {
            List<AipoLicense> list = Database.query(AipoLicense.class).select("LIMIT_USERS").fetchList();
            if (list != null && list.size() > 0) {
                AipoLicense record = list.get(0);
                Integer result = record.getLimitUsers();
                return result;
            }
        }
        catch (Exception e) {
            logger.error((Object)"ALEipUtils.getLimitUsers", (Throwable)e);
        }
        return 0;
    }

    public static int getCurrentUserNumEnabledOnly(RunData rundata) {
        int registeredUserNum = -1;
        try {
            Expression exp = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
            List<TurbineUser> list = Database.query(TurbineUser.class, exp).fetchList();
            if (list == null || list.size() <= 0) {
                return -1;
            }
            int size = list.size();
            registeredUserNum = size - 2;
        }
        catch (Exception ex) {
            logger.error((Object)"\u30e6\u30fc\u30b6\u30fc\u60c5\u5831\u3092DB\u304b\u3089\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            logger.error((Object)"ALEipUtils.getCurrentUserNumEnabledOnly", (Throwable)ex);
            return -1;
        }
        return registeredUserNum;
    }

    public static int getCurrentUserNum(RunData rundata) {
        int registeredUserNum = -1;
        try {
            Expression exp = ExpressionFactory.noMatchExp((String)"disabled", (Object)"T");
            List<TurbineUser> list = Database.query(TurbineUser.class, exp).fetchList();
            if (list == null || list.size() <= 0) {
                return -1;
            }
            int size = list.size();
            registeredUserNum = size - 2;
        }
        catch (Exception ex) {
            logger.error((Object)"\u30e6\u30fc\u30b6\u30fc\u60c5\u5831\u3092DB\u304b\u3089\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            logger.error((Object)"ALEipUtils.getCurrentUserNum", (Throwable)ex);
            return -1;
        }
        return registeredUserNum;
    }

    public static boolean isAdmin(int uid) {
        boolean res = false;
        try {
            Role adminrole = JetspeedSecurity.getRole((String)"admin");
            TurbineUserGroupRole role = (TurbineUserGroupRole)Database.query(TurbineUserGroupRole.class).where(Operations.eq("turbineRole", adminrole.getId()), Operations.eq("turbineUser", uid)).fetchSingle();
            res = role != null;
        }
        catch (JetspeedSecurityException e) {
            logger.error((Object)"\u7ba1\u7406\u8005\u30ed\u30fc\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            logger.error((Object)"ALEipUtils.isAdmin", (Throwable)e);
        }
        return res;
    }

    public static boolean isAdmin(RunData rundata) {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        return ALEipUtils.isAdmin(Integer.valueOf(jdata.getUserId()));
    }

    public static boolean isAdminUser(RunData runData) {
        int userId = ALEipUtils.getUserId(runData);
        return ALEipUtils.isAdminUser(userId);
    }

    public static boolean isAdminUser(int userId) {
        return userId == 1;
    }

    public static String getLoginName(RunData runData) {
        JetspeedRunData jdata = (JetspeedRunData)runData;
        return jdata.getJetspeedUser().getUserName();
    }

    public static ALDateTimeField getFormattedTime(Date date) {
        GregorianCalendar Now = new GregorianCalendar();
        Now.setTime(new Date());
        GregorianCalendar Time2 = new GregorianCalendar();
        Time2.setTime(date);
        ALDateTimeField rtn = Now.get(1) == Time2.get(1) ? (Now.get(2) == Time2.get(2) && Now.get(5) == Time2.get(5) ? new ALDateTimeField("H:mm") : new ALDateTimeField("M\u6708d\u65e5")) : new ALDateTimeField("yyyy\u5e74M\u6708d\u65e5");
        rtn.setValue(date);
        return rtn;
    }

    public static ALDateTimeField getFormattedTime(ALDateTimeField timeField) {
        if (!timeField.isNotNullValue()) {
            return null;
        }
        return ALEipUtils.getFormattedTime(timeField.getValue());
    }

    public static ALDateTimeField getFormattedTimeDetail(Date date) {
        GregorianCalendar Now = new GregorianCalendar();
        Now.setTime(new Date());
        GregorianCalendar Time2 = new GregorianCalendar();
        Time2.setTime(date);
        ALDateTimeField rtn = Now.get(1) == Time2.get(1) ? new ALDateTimeField("M\u6708d\u65e5 H:mm") : new ALDateTimeField("yyyy\u5e74M\u6708d\u65e5 H:mm");
        rtn.setValue(date);
        return rtn;
    }

    public static ALDateTimeField getFormattedTimeDetail(ALDateTimeField timeField) {
        if (!timeField.isNotNullValue()) {
            return null;
        }
        return ALEipUtils.getFormattedTimeDetail(timeField.getValue());
    }

    public static void addAdminPage(String user_name) throws Exception {
        ProfileLocator locator = Profiler.createLocator();
        locator.createFromPath(String.format("user/%s/media-type/html", user_name));
        ALEipManager.getInstance().removeProfile(locator);
        Profile profile = Profiler.getProfile((ProfileLocator)locator);
        Portlets portlets = profile.getDocument().getPortlets();
        if (portlets != null) {
            long max_position = 0L;
            int portlet_size = portlets.getPortletsCount();
            for (int i = 0; i < portlet_size; ++i) {
                Portlets p = portlets.getPortlets(i);
                if (p.getSecurityRef().getParent().equals("admin-view")) {
                    return;
                }
                if (p.getLayout().getPosition() <= max_position) continue;
                max_position = p.getLayout().getPosition();
            }
            PsmlLayout newLayout = new PsmlLayout();
            newLayout.setPosition(max_position + 1L);
            newLayout.setSize(-1L);
            ProfileLocator admin_locator = Profiler.createLocator();
            admin_locator.createFromPath("user/admin/media-type/html");
            Portlets admin_portlets = Profiler.createProfile((ProfileLocator)admin_locator).getDocument().getPortlets();
            admin_portlets = admin_portlets.getPortlets(0);
            Entry[] entriesArray = admin_portlets.getEntriesArray();
            int size = entriesArray.length;
            for (int i = 0; i < size; ++i) {
                if (!entriesArray[i].getParent().equals("DeleteSample")) continue;
                admin_portlets.removeEntry(i);
                break;
            }
            admin_portlets.setLayout((Layout)newLayout);
            portlets.addPortlets(admin_portlets);
            PsmlManager.store((Profile)profile);
        }
    }

    public static String getFirstPortletId(String username) {
        try {
            ProfileLocator locator = Profiler.createLocator();
            locator.createFromPath(String.format("user/%s/media-type/html", username));
            Profile profile = Profiler.getProfile((ProfileLocator)locator);
            Portlets portlets = profile.getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return null;
            }
            for (Portlets portlet : portletList) {
                Entry[] entries = portlet.getEntriesArray();
                if (entries == null || entries.length == 0) continue;
                for (String name : IPHONE_APPS) {
                    for (Entry entry : entries) {
                        String portletName = entry.getParent();
                        if (portletName.equals("AjaxScheduleWeekly")) {
                            portletName = "Schedule";
                        }
                        if (!name.equals(portletName)) continue;
                        return entry.getId();
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"ALEipUtils.getFirstPortletId", (Throwable)ex);
            return null;
        }
        return null;
    }

    public static String getClient(RunData rundata) {
        if (Boolean.parseBoolean((String)rundata.getSession().getAttribute("changeToPc"))) {
            return "PCIPHONE";
        }
        return ALEipUtils.getClient(rundata.getUserAgent().trim());
    }

    public static String getClient(String userAgent) {
        return ALEipUtils.getClientEntry(userAgent).getKey();
    }

    public static boolean isMatchUserAgent(String expect, RunData rundata) {
        String userAgent = rundata.getUserAgent().trim();
        if (userAgent == null || "".equals(userAgent)) {
            return false;
        }
        return userAgent.indexOf(expect) > -1;
    }

    public static boolean isMsieBrowser(RunData rundata) {
        return ALEipUtils.isMatchUserAgent("Win", rundata) && (ALEipUtils.isMatchUserAgent("MSIE", rundata) || ALEipUtils.isMatchUserAgent("Trident", rundata));
    }

    public static boolean isAndroidBrowser(RunData rundata) {
        return ALEipUtils.isMatchUserAgent("Android", rundata);
    }

    public static boolean isAndroid2Browser(RunData rundata) {
        int[] version = ALEipUtils.getAndroidVersion(rundata);
        return version != null && version[0] == 2;
    }

    public static int[] getAndroidVersion(RunData rundata) {
        String userAgent = rundata.getUserAgent().trim();
        if (userAgent == null || "".equals(userAgent)) {
            return null;
        }
        Pattern androidVersion = Pattern.compile("Android ([\\d]+).([\\d]+).([\\d]+)", 2);
        Matcher matcher = androidVersion.matcher(userAgent);
        if (matcher.find()) {
            return new int[]{Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3))};
        }
        return null;
    }

    public static String getClientVersion(RunData rundata) {
        return ALEipUtils.getClientVersion(rundata.getUserAgent().trim());
    }

    public static String getClientVersion(String userAgent) {
        return ALEipUtils.getClientEntry(userAgent).getValue();
    }

    protected static Map.Entry<String, String> getClientEntry(String userAgent) {
        ClientRegistry registry;
        ClientEntry entry;
        HashMap<String, String> map = new HashMap<String, String>(1);
        String key = "com.aimluck.eip.util.getClient.client";
        String keyVer = "com.aimluck.eip.util.getClient.clientVer";
        String client = null;
        String clientVer = "0";
        HttpServletRequest request = HttpServletRequestLocator.get();
        if (request != null) {
            client = (String)request.getAttribute(key);
            clientVer = (String)request.getAttribute(keyVer);
            if (client != null && client.length() > 0) {
                if (clientVer == null) {
                    clientVer = "";
                }
                map.put(client, clientVer);
                return map.entrySet().iterator().next();
            }
        }
        String string = client = (entry = (registry = (ClientRegistry)Registry.get((String)Registry.CLIENT)).findEntry(userAgent)) == null ? "OUTER" : entry.getManufacturer();
        if ("IPAD".equals(client) || "IPHONE".equals(client)) {
            clientVer = String.valueOf(userAgent.charAt(userAgent.indexOf("OS") + 3));
        }
        if (ALEipUtils.isIE(userAgent)) {
            client = "IE";
            clientVer = ALEipUtils.getIEVersion(userAgent);
        }
        if (request != null) {
            request.setAttribute(key, (Object)client);
            request.setAttribute(keyVer, (Object)clientVer);
        }
        if (clientVer == null) {
            clientVer = "";
        }
        map.put(client, clientVer);
        return map.entrySet().iterator().next();
    }

    public static boolean isIE(String userAgent) {
        return userAgent.matches(".*((MSIE)+ [0-9]\\.[0-9]).*") || userAgent.matches(".*(.*(Trident/)+[0-9]\\.[0-9]).*");
    }

    public static boolean setPsmlParameters(RunData rundata, Context context, String key, String value) {
        try {
            String portletEntryId = rundata.getParameters().getString("js_peid", null);
            if (value == null || "".equals(value)) {
                return false;
            }
            Profile profile = ((JetspeedRunData)rundata).getProfile();
            Portlets portlets = profile.getDocument().getPortlets();
            if (portlets == null) {
                return false;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return false;
            }
            PsmlParameter param = null;
            int length = portletList.length;
            block2: for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getId().equals(portletEntryId)) continue;
                    boolean hasParam = false;
                    Parameter[] params = entries[j].getParameter();
                    int param_len = params.length;
                    for (int k = 0; k < param_len; ++k) {
                        if (!params[k].getName().equals(key)) continue;
                        hasParam = true;
                        params[k].setValue(value);
                        entries[j].setParameter(k, params[k]);
                    }
                    if (hasParam) continue block2;
                    param = new PsmlParameter();
                    param.setName(key);
                    param.setValue(value);
                    entries[j].addParameter((Parameter)param);
                    continue block2;
                }
            }
            profile.store();
        }
        catch (Exception ex) {
            logger.error((Object)"ALEipUtils.setPsmlParameters", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static String passPSML(RunData rundata, Context context, String key, String value) {
        VelocityPortlet portlet = ALEipUtils.getPortlet(rundata, context);
        PortletConfig config = portlet.getPortletConfig();
        if (value == null || "".equals(value)) {
            value = config != null ? config.getInitParameter(key) : "";
        } else {
            ALEipUtils.setPsmlParameters(rundata, context, key, value);
        }
        return value;
    }

    public static boolean isFileUploadable(RunData rundata) {
        Integer num;
        String iOSver;
        return !ALEipUtils.isMatchUserAgent("iPhone", rundata) || (iOSver = ALEipUtils.getIOSVersion(rundata.getUserAgent().trim())).length() <= 1 || (num = Integer.valueOf(Integer.parseInt(iOSver.substring(0, 1)))) >= 6;
    }

    public static String getIOSVersion(String userAgent) {
        Pattern pattern = Pattern.compile("OS\\s[0-9_]+");
        Matcher matcher = pattern.matcher(userAgent);
        if (matcher.find()) {
            String words = matcher.group();
            return words.replaceAll("OS\\s", "");
        }
        return "";
    }

    public static String getIEVersion(String userAgent) {
        Pattern pattern = Pattern.compile("MSIE\\s[0-9_]+");
        Matcher matcher = pattern.matcher(userAgent);
        Pattern pattern2 = Pattern.compile("rv:[0-9_]+");
        Matcher matcher2 = pattern2.matcher(userAgent);
        if (matcher.find()) {
            String words = matcher.group();
            return words.replaceAll("MSIE\\s", "");
        }
        if (matcher2.find()) {
            String words2 = matcher2.group();
            return words2.replaceAll("rv:", "");
        }
        return "";
    }

    public static Map<String, Entry> getGlobalPortlets(RunData rundata) {
        PSMLDocument doc;
        User user;
        HashMap<String, Entry> maps = new HashMap<String, Entry>();
        Profile profile = ((JetspeedRunData)rundata).getProfile();
        if (profile == null && (user = rundata.getUser()) != null) {
            ProfileLocator locator = Profiler.createLocator();
            locator.createFromPath(String.format("user/%s/media-type/html", user.getUserName()));
            try {
                profile = Profiler.getProfile((ProfileLocator)locator);
            }
            catch (ProfileException ignore) {
                // empty catch block
            }
        }
        if (profile != null && (doc = profile.getDocument()) != null) {
            Iterator iterator = doc.getPortlets().getEntriesIterator();
            while (iterator.hasNext()) {
                Entry next = (Entry)iterator.next();
                maps.put(next.getParent(), next);
            }
        }
        return maps;
    }
}

