/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets;

import org.apache.jetspeed.modules.actions.portlets.JspPortletAction;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.util.PortletConfigState;
import org.apache.jetspeed.util.PortletSessionState;
import org.apache.jetspeed.util.StringUtils;
import org.apache.jetspeed.webservices.finance.stockmarket.StockQuote;
import org.apache.jetspeed.webservices.finance.stockmarket.StockQuoteService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Comparable;
import org.apache.turbine.util.QuickSort;
import org.apache.turbine.util.RunData;

public class JspStockQuoteAction
extends JspPortletAction
implements Comparable {
    private static final String SYMBOLS = "symbols";
    private static final String COLUMNS = "columns";
    private static final String QUOTES = "quotes";
    private static final String SORT = "sort";
    private static final String SELECTED_COLUMNS = "selected-columns";
    private static final String[] ALL_COLUMNS = new String[]{"Symbol", "Price", "Change", "Volume"};
    private String sort = null;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JspStockQuoteAction.class.getName());

    protected void buildNormalContext(Portlet portlet, RunData rundata) {
        this.doRefresh(rundata, portlet);
    }

    public void doSort(RunData rundata, Portlet portlet) {
        this.doRefresh(rundata, portlet);
        logger.info("JspStockQuoteAction: sorting...");
    }

    public void doRefresh(RunData rundata, Portlet portlet) {
        try {
            StockQuoteService service = (StockQuoteService)TurbineServices.getInstance().getService("StockQuoteService");
            String symbols = (String)PortletSessionState.getAttributeWithFallback(portlet, rundata, SYMBOLS);
            this.sort = (String)PortletSessionState.getAttributeWithFallback(portlet, rundata, SORT);
            if (this.sort != null) {
                PortletSessionState.setAttribute(portlet, rundata, SORT, (Object)this.sort);
                rundata.getRequest().setAttribute(SORT, (Object)this.sort);
            }
            String columns = PortletConfigState.getParameter(portlet, rundata, COLUMNS, StringUtils.arrayToString(ALL_COLUMNS, ","));
            String[] selectedColumnsArray = StringUtils.stringToArray(columns, ",");
            String[] symbolArray = StringUtils.stringToArray(symbols, ",");
            Object[] quotes = service.fullQuotes(symbolArray);
            if (this.sort != null) {
                QuickSort.quickSort((Object[])quotes, (int)0, (int)(quotes.length - 1), (Comparable)this);
                rundata.getRequest().setAttribute(SORT, (Object)this.sort);
            }
            rundata.getRequest().setAttribute(QUOTES, (Object)quotes);
            rundata.getRequest().setAttribute(COLUMNS, (Object)selectedColumnsArray);
            rundata.getRequest().setAttribute(SELECTED_COLUMNS, (Object)columns);
            logger.info("JspStockQuoteAction: refreshing...");
        }
        catch (Exception e) {
            logger.error("Exception", e);
        }
    }

    public int compare(Object entry1, Object entry2) {
        if (this.sort.equalsIgnoreCase("price")) {
            Float entrycol1 = new Float(((StockQuote)entry1).getPrice());
            Float entrycol2 = new Float(((StockQuote)entry2).getPrice());
            return entrycol1.compareTo(entrycol2);
        }
        if (this.sort.equalsIgnoreCase("symbol")) {
            String entrycol1 = ((StockQuote)entry1).getSymbol();
            String entrycol2 = ((StockQuote)entry2).getSymbol();
            return entrycol1.compareTo(entrycol2);
        }
        if (this.sort.equalsIgnoreCase("change")) {
            Double entrycol1 = new Double(((StockQuote)entry1).getChange());
            Double entrycol2 = new Double(((StockQuote)entry2).getChange());
            return entrycol1.compareTo(entrycol2);
        }
        Long entrycol1 = new Long(((StockQuote)entry1).getVolume());
        Long entrycol2 = new Long(((StockQuote)entry2).getVolume());
        return entrycol1.compareTo(entrycol2);
    }
}

