/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets;

import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.jetspeed.modules.actions.portlets.JspPortletAction;
import org.apache.jetspeed.om.registry.Parameter;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.util.RunData;

public class QuestionnaireAction
extends JspPortletAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(QuestionnaireAction.class.getName());

    protected void buildNormalContext(Portlet portlet, RunData rundata) {
        PortletEntry entry = (PortletEntry)Registry.getEntry(Registry.PORTLET, portlet.getName());
        Iterator i = entry.getParameterNames();
        Hashtable<String, String> qa = new Hashtable<String, String>();
        while (i.hasNext()) {
            String name = (String)i.next();
            Parameter param = entry.getParameter(name);
            if (param.isHidden()) continue;
            String title = param.getTitle();
            String value = portlet.getPortletConfig().getInitParameter(name);
            qa.put(title, value);
        }
        rundata.getRequest().setAttribute("questions", qa);
        if (rundata.getRequest().getAttribute("email") == null) {
            this.resetTemplate(rundata);
        }
    }

    public void doContinue(RunData rundata, Portlet portlet) {
        this.resetTemplate(rundata);
    }

    public void doEmail(RunData rundata, Portlet portlet) {
        StringBuffer emailBody = new StringBuffer();
        PortletEntry entry = (PortletEntry)Registry.getEntry(Registry.PORTLET, portlet.getName());
        Iterator i = entry.getParameterNames();
        while (i.hasNext()) {
            String name = (String)i.next();
            Parameter param = entry.getParameter(name);
            if (param.isHidden()) continue;
            String title = param.getTitle();
            String value = portlet.getPortletConfig().getInitParameter(name);
            value = value == null || value.length() == 0 ? "NOT PROVIDED" : value;
            emailBody.append(title);
            emailBody.append(" ===> ");
            emailBody.append(value);
            emailBody.append("\n\n");
        }
        String emailSmtp = JetspeedResources.getString("mail.server");
        String emailFrom = JetspeedResources.getString("mail.support", "david@bluesunrise.com");
        String emailTo = rundata.getParameters().getString("emailTo", "jetspeed-dev@jakarta.apache.org");
        String emailAttachment = rundata.getRequest().getParameter("emailAttachment");
        try {
            String emailText = emailBody.toString();
            Properties properties = System.getProperties();
            properties.put("mail.smtp.host", emailSmtp);
            Session emailSession = Session.getInstance((Properties)properties, null);
            MimeMessage message = new MimeMessage(emailSession);
            InternetAddress fromAddress = new InternetAddress(emailFrom);
            message.setFrom((Address)fromAddress);
            InternetAddress[] toAddresses = InternetAddress.parse((String)emailTo);
            message.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
            message.setSubject("Jetspeed Questionnaire from " + rundata.getUser().getEmail());
            message.setText(emailText);
            if (emailAttachment != null) {
                File file = new File(emailAttachment);
                if (file.exists()) {
                    MimeBodyPart mbp1 = new MimeBodyPart();
                    mbp1.setText(emailText);
                    MimeBodyPart mbp2 = new MimeBodyPart();
                    FileDataSource fds = new FileDataSource(emailAttachment);
                    mbp2.setDataHandler(new DataHandler((DataSource)fds));
                    mbp2.setFileName(fds.getName());
                    MimeMultipart mp = new MimeMultipart();
                    mp.addBodyPart((BodyPart)mbp1);
                    mp.addBodyPart((BodyPart)mbp2);
                    message.setContent((Multipart)mp);
                } else {
                    message.setText(emailBody.toString());
                }
            }
            Transport.send((Message)message);
            rundata.getRequest().setAttribute("email", (Object)emailBody.toString());
            String confirmTemplate = portlet.getPortletConfig().getInitParameter("confirm.template", "JetspeedQuestionnaireConfirmation.jsp");
            this.setTemplate(rundata, confirmTemplate, true);
            rundata.setMessage("Email successfully sent");
        }
        catch (Exception e) {
            logger.error("Exception", e);
            rundata.setMessage("Error sending email: " + e);
        }
    }
}

