/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets.security;

import org.apache.jetspeed.modules.actions.portlets.SecureVelocityPortletAction;
import org.apache.jetspeed.modules.actions.portlets.security.SecurityConstants;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.JetspeedGroupFactory;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.security.GroupException;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;
import org.apache.velocity.context.Context;

public class GroupUpdateAction
extends SecureVelocityPortletAction {
    private static final String TEMP_GROUP = "tempGroup";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(GroupUpdateAction.class.getName());

    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
    }

    protected void buildConfigureContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
    }

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) {
        try {
            String msgid;
            Group group = null;
            String mode = rundata.getParameters().getString("mode");
            if (mode != null && (mode.equals("update") || mode.equals("delete"))) {
                String groupname = rundata.getParameters().getString("entityid");
                group = JetspeedSecurity.getGroup(groupname);
                context.put("group", (Object)group);
            }
            if ((msgid = rundata.getParameters().getString("msgid")) != null) {
                Group tempGroup;
                int id = Integer.parseInt(msgid);
                if (id < SecurityConstants.MESSAGES.length) {
                    context.put("msg", (Object)SecurityConstants.MESSAGES[id]);
                }
                if ((tempGroup = (Group)rundata.getUser().getTemp(TEMP_GROUP)) != null) {
                    context.put("group", (Object)tempGroup);
                }
            }
            context.put("mode", (Object)mode);
        }
        catch (Exception e) {
            logger.error("Error in Jetspeed User Security", e);
            rundata.setMessage("Error in Jetspeed User Security: " + e.toString());
            rundata.setStackTrace(StringUtils.stackTrace((Throwable)e), (Throwable)e);
            rundata.setScreenTemplate(JetspeedResources.getString("template.error", "Error"));
        }
    }

    public void doInsert(RunData rundata, Context context) throws Exception {
        block3: {
            Group group = null;
            try {
                String name = rundata.getParameters().getString("name");
                if (name == null || name.trim().length() == 0) {
                    DynamicURI duri = new DynamicURI(rundata);
                    duri.addPathInfo("js_panename", "GroupForm");
                    duri.addPathInfo("msgid", 2);
                    rundata.setRedirectURI(duri.toString());
                    rundata.getUser().setTemp(TEMP_GROUP, null);
                    return;
                }
                group = JetspeedGroupFactory.getInstance();
                group.setName(name);
                JetspeedSecurity.addGroup(group);
            }
            catch (GroupException e) {
                logger.error("Exception", (Throwable)((Object)e));
                DynamicURI duri = new DynamicURI(rundata);
                duri.addPathInfo("js_panename", "GroupForm");
                duri.addPathInfo("msgid", 3);
                rundata.setRedirectURI(duri.toString());
                if (group == null) break block3;
                rundata.getUser().setTemp(TEMP_GROUP, (Object)group);
            }
        }
    }

    public void doUpdate(RunData rundata, Context context) throws Exception {
        block3: {
            Group group = null;
            try {
                group = JetspeedSecurity.getGroup(rundata.getParameters().getString("entityid"));
                JetspeedSecurity.saveGroup(group);
            }
            catch (Exception e) {
                logger.error("Exception", e);
                DynamicURI duri = new DynamicURI(rundata);
                duri.addPathInfo("js_panename", "GroupForm");
                duri.addPathInfo("msgid", 0);
                if (group != null) {
                    duri.addPathInfo("entityid", group.getName());
                }
                duri.addQueryData("mode", "update");
                rundata.setRedirectURI(duri.toString());
                if (group == null) break block3;
                rundata.getUser().setTemp(TEMP_GROUP, (Object)group);
            }
        }
    }

    public void doDelete(RunData rundata, Context context) throws Exception {
        block3: {
            Group group = null;
            try {
                group = JetspeedSecurity.getGroup(rundata.getParameters().getString("entityid"));
                JetspeedSecurity.removeGroup(group.getName());
            }
            catch (Exception e) {
                logger.error("Exception", e);
                DynamicURI duri = new DynamicURI(rundata);
                duri.addPathInfo("js_panename", "GroupForm");
                duri.addPathInfo("msgid", 1);
                if (group != null) {
                    duri.addPathInfo("entityid", group.getName());
                }
                duri.addQueryData("mode", "delete");
                rundata.setRedirectURI(duri.toString());
                if (group == null) break block3;
                rundata.getUser().setTemp(TEMP_GROUP, (Object)group);
            }
        }
    }
}

