/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets.security;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.mail.SimpleEmail;
import org.apache.jetspeed.modules.actions.portlets.SecureVelocityPortletAction;
import org.apache.jetspeed.modules.actions.portlets.security.SecurityConstants;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.TemplateLocator;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.security.NotUniqueUserException;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;
import org.apache.velocity.context.Context;

public class UserUpdateAction
extends SecureVelocityPortletAction {
    private static final String TEMP_USER = "tempUser";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(UserUpdateAction.class.getName());

    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
    }

    protected void buildConfigureContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
        this.setTemplate(rundata, "user-form.vm");
    }

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) {
        try {
            String msgid;
            JetspeedUser user = null;
            String mode = rundata.getParameters().getString("mode");
            if (mode != null && (mode.equals("update") || mode.equals("delete"))) {
                String username = rundata.getParameters().getString("entityid");
                user = JetspeedSecurity.getUser(username);
                context.put("user", (Object)user);
            }
            if ((msgid = rundata.getParameters().getString("msgid")) != null) {
                JetspeedUser tempUser;
                int id = Integer.parseInt(msgid);
                if (id < SecurityConstants.MESSAGES.length) {
                    context.put("msg", (Object)SecurityConstants.MESSAGES[id]);
                }
                if ((tempUser = (JetspeedUser)rundata.getUser().getTemp(TEMP_USER)) != null) {
                    context.put("user", (Object)tempUser);
                }
            }
            context.put("mode", (Object)mode);
        }
        catch (Exception e) {
            logger.error("Error in Jetspeed User Security", e);
            rundata.setMessage("Error in Jetspeed User Security: " + e.toString());
            rundata.setStackTrace(StringUtils.stackTrace((Throwable)e), (Throwable)e);
            rundata.setScreenTemplate(JetspeedResources.getString("template.error", "Error"));
        }
    }

    public void doInsert(RunData rundata, Context context) throws Exception {
        block5: {
            JetspeedUser user = null;
            try {
                String name = rundata.getParameters().getString("username");
                if (name == null || name.trim().length() == 0) {
                    DynamicURI duri = new DynamicURI(rundata);
                    duri.addPathInfo("js_panename", "UserForm");
                    duri.addPathInfo("msgid", 2);
                    rundata.setRedirectURI(duri.toString());
                    if (user != null) {
                        rundata.getUser().setTemp(TEMP_USER, (Object)user);
                    }
                    return;
                }
                user = JetspeedSecurity.getUserInstance();
                rundata.getParameters().setProperties((Object)user);
                String password = rundata.getParameters().getString("password");
                if (password == null) {
                    password = "";
                }
                user.setUserName(JetspeedSecurity.convertUserName(user.getUserName()));
                Date now = new Date();
                user.setCreateDate(now);
                user.setLastLogin(now);
                user.setConfirmed("CONFIRMED");
                String disabled = rundata.getParameters().getString("disabled");
                user.setDisabled(disabled);
                user.setPassword(password);
                JetspeedSecurity.addUser(user);
            }
            catch (NotUniqueUserException e) {
                logger.error("Exception", (Throwable)((Object)e));
                DynamicURI duri = new DynamicURI(rundata);
                duri.addPathInfo("js_panename", "UserForm");
                duri.addPathInfo("msgid", 3);
                rundata.setRedirectURI(duri.toString());
                if (user == null) break block5;
                rundata.getUser().setTemp(TEMP_USER, (Object)user);
            }
        }
    }

    public void doAccept(RunData rundata, Context context) throws Exception {
        block3: {
            JetspeedUser user = null;
            try {
                user = JetspeedSecurity.getUser(rundata.getParameters().getString("entityid"));
                user.setConfirmed("CONFIRMED");
                JetspeedSecurity.saveUser(user);
                DynamicURI url = new DynamicURI(rundata);
                StringWriter email_body = new StringWriter();
                SimpleEmail se = new SimpleEmail();
                String charset = JetspeedResources.getString("newuser.notification.charset", "iso-8859-1");
                se.setCharset(charset);
                Context emailContext = TurbineVelocity.getContext();
                emailContext.put("firstname", (Object)StringEscapeUtils.unescapeHtml(user.getFirstName()));
                emailContext.put("lastname", (Object)StringEscapeUtils.unescapeHtml(user.getLastName()));
                emailContext.put("username", (Object)StringEscapeUtils.unescapeHtml(user.getUserName()));
                emailContext.put("data", (Object)rundata);
                emailContext.put("user", (Object)user);
                emailContext.put("config", (Object)new JetspeedResources());
                emailContext.put("urltojetspeed", (Object)url);
                emailContext.put("email", (Object)se);
                String language = (String)user.getPerm("language", TurbineResources.getString((String)"locale.default.language", (String)"en"));
                String country = (String)user.getPerm("country", TurbineResources.getString((String)"locale.default.country", (String)"US"));
                Locale locale = new Locale(language, country);
                String templateFile = JetspeedResources.getString("newuser.approval.accept.template");
                String templatePath = TemplateLocator.locateEmailTemplate(rundata, templateFile, locale);
                TurbineVelocity.handleRequest((Context)emailContext, (String)templatePath, (Writer)email_body);
                se.setMsg(email_body.toString());
                Properties props = System.getProperties();
                String mailServerMachine = JetspeedResources.getString("mail.server");
                props.put("mail.host", mailServerMachine);
                props.put("mail.smtp.host", mailServerMachine);
                se.send();
            }
            catch (Exception e) {
                logger.error("Exception", e);
                DynamicURI duri = new DynamicURI(rundata);
                duri.addPathInfo("js_panename", "UserForm");
                duri.addPathInfo("msgid", 0);
                if (user != null) {
                    duri.addPathInfo("entityid", user.getUserName());
                }
                duri.addQueryData("mode", "update");
                rundata.setRedirectURI(duri.toString());
                if (user == null) break block3;
                rundata.getUser().setTemp(TEMP_USER, (Object)user);
            }
        }
    }

    public void doReject(RunData rundata, Context context) throws Exception {
        block3: {
            JetspeedUser user = null;
            try {
                user = JetspeedSecurity.getUser(rundata.getParameters().getString("entityid"));
                user.setConfirmed("REJECTED");
                JetspeedSecurity.saveUser(user);
                DynamicURI url = new DynamicURI(rundata);
                StringWriter email_body = new StringWriter();
                SimpleEmail se = new SimpleEmail();
                String charset = JetspeedResources.getString("newuser.notification.charset", "iso-8859-1");
                se.setCharset(charset);
                Context emailContext = TurbineVelocity.getContext();
                emailContext.put("firstname", (Object)StringEscapeUtils.unescapeHtml(user.getFirstName()));
                emailContext.put("lastname", (Object)StringEscapeUtils.unescapeHtml(user.getLastName()));
                emailContext.put("username", (Object)StringEscapeUtils.unescapeHtml(user.getUserName()));
                emailContext.put("data", (Object)rundata);
                emailContext.put("user", (Object)user);
                emailContext.put("config", (Object)new JetspeedResources());
                emailContext.put("urltojetspeed", (Object)url);
                emailContext.put("email", (Object)se);
                String language = (String)user.getPerm("language", TurbineResources.getString((String)"locale.default.language", (String)"en"));
                String country = (String)user.getPerm("country", TurbineResources.getString((String)"locale.default.country", (String)"US"));
                Locale locale = new Locale(language, country);
                String templateFile = JetspeedResources.getString("newuser.approval.reject.template");
                String templatePath = TemplateLocator.locateEmailTemplate(rundata, templateFile, locale);
                TurbineVelocity.handleRequest((Context)emailContext, (String)templatePath, (Writer)email_body);
                se.setMsg(email_body.toString());
                Properties props = System.getProperties();
                String mailServerMachine = JetspeedResources.getString("mail.server");
                props.put("mail.host", mailServerMachine);
                props.put("mail.smtp.host", mailServerMachine);
                se.send();
            }
            catch (Exception e) {
                logger.error("Exception", e);
                DynamicURI duri = new DynamicURI(rundata);
                duri.addPathInfo("js_panename", "UserForm");
                duri.addPathInfo("msgid", 0);
                if (user != null) {
                    duri.addPathInfo("entityid", user.getUserName());
                }
                duri.addQueryData("mode", "update");
                rundata.setRedirectURI(duri.toString());
                if (user == null) break block3;
                rundata.getUser().setTemp(TEMP_USER, (Object)user);
            }
        }
    }

    public void doUpdate(RunData rundata, Context context) throws Exception {
        block8: {
            JetspeedUser user = null;
            try {
                user = JetspeedSecurity.getUser(rundata.getParameters().getString("entityid"));
                String name = rundata.getParameters().getString("username");
                if (name == null || name.trim().length() == 0) {
                    DynamicURI duri = new DynamicURI(rundata);
                    duri.addPathInfo("js_panename", "UserForm");
                    duri.addPathInfo("msgid", 2);
                    if (user != null) {
                        duri.addPathInfo("entityid", user.getUserName());
                    }
                    duri.addQueryData("mode", "update");
                    rundata.setRedirectURI(duri.toString());
                    if (user != null) {
                        rundata.getUser().setTemp(TEMP_USER, (Object)user);
                    }
                    return;
                }
                String oldDisabled = user.getDisabled();
                rundata.getParameters().setProperties((Object)user);
                user.setLastAccessDate();
                JetspeedSecurity.forcePassword(user, rundata.getParameters().getString("password"));
                String strDisabled = rundata.getParameters().getString("disabled");
                boolean disabled = strDisabled != null && "T".equals(strDisabled);
                user.setDisabled(strDisabled);
                if (!disabled && "T".equals(oldDisabled) && JetspeedSecurity.isDisableAccountCheckEnabled()) {
                    JetspeedSecurity.resetDisableAccountCheck(name);
                }
                JetspeedSecurity.saveUser(user);
                JetspeedUser currentUser = (JetspeedUser)rundata.getUser();
                if (currentUser.getUserName().equals(user.getUserName())) {
                    currentUser.setPassword(user.getPassword());
                    currentUser.setFirstName(user.getFirstName());
                    currentUser.setLastName(user.getLastName());
                    currentUser.setEmail(user.getEmail());
                }
            }
            catch (Exception e) {
                logger.error("Exception", e);
                DynamicURI duri = new DynamicURI(rundata);
                duri.addPathInfo("js_panename", "UserForm");
                duri.addPathInfo("msgid", 0);
                if (user != null) {
                    duri.addPathInfo("entityid", user.getUserName());
                }
                duri.addQueryData("mode", "update");
                rundata.setRedirectURI(duri.toString());
                if (user == null) break block8;
                rundata.getUser().setTemp(TEMP_USER, (Object)user);
            }
        }
    }

    public void doDelete(RunData rundata, Context context) throws Exception {
        block6: {
            JetspeedUser user = null;
            try {
                user = JetspeedSecurity.getUser(rundata.getParameters().getString("entityid"));
                if (rundata.getUser().getUserName().equals(user.getUserName())) {
                    DynamicURI duri = new DynamicURI(rundata);
                    duri.addPathInfo("js_panename", "UserForm");
                    duri.addPathInfo("msgid", 4);
                    if (user != null) {
                        duri.addPathInfo("entityid", user.getUserName());
                    }
                    duri.addQueryData("mode", "delete");
                    rundata.setRedirectURI(duri.toString());
                    if (user != null) {
                        rundata.getUser().setTemp(TEMP_USER, (Object)user);
                    }
                    return;
                }
                JetspeedSecurity.removeUser(user.getUserName());
            }
            catch (Exception e) {
                logger.error("Exception", e);
                DynamicURI duri = new DynamicURI(rundata);
                duri.addPathInfo("js_panename", "UserForm");
                duri.addPathInfo("msgid", 1);
                if (user != null) {
                    duri.addPathInfo("entityid", user.getUserName());
                }
                duri.addQueryData("mode", "delete");
                rundata.setRedirectURI(duri.toString());
                if (user == null) break block6;
                rundata.getUser().setTemp(TEMP_USER, (Object)user);
            }
        }
    }
}

