/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.registry.base;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.jetspeed.om.registry.MimetypeMap;
import org.apache.jetspeed.util.MimeType;

public class BaseMimetypeMap
implements MimetypeMap,
Serializable {
    private Vector mimetypesVector = new Vector();
    private transient Vector mimes;

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        BaseMimetypeMap obj = (BaseMimetypeMap)object;
        Iterator i = this.mimetypesVector.iterator();
        Iterator i2 = obj.mimetypesVector.iterator();
        while (i.hasNext()) {
            String c1 = (String)i.next();
            String c2 = null;
            if (!i2.hasNext()) {
                return false;
            }
            c2 = (String)i2.next();
            if (c1.equals(c2)) continue;
            return false;
        }
        return !i2.hasNext();
    }

    public Iterator getMimetypes() {
        if (this.mimes == null) {
            this.buildMimetable();
        }
        return this.mimes.iterator();
    }

    public MimeType getPreferredMimetype() {
        if (this.mimes == null) {
            this.buildMimetable();
        }
        return (MimeType)this.mimes.get(0);
    }

    public void addMimetype(String name) {
        if (!this.mimetypesVector.contains(name)) {
            this.mimetypesVector.add(name);
            this.buildMimetable();
        }
    }

    public void removeMimetype(String name) {
        this.mimetypesVector.remove(name);
        this.buildMimetable();
    }

    protected void buildMimetable() {
        Vector<MimeType> types = new Vector<MimeType>();
        for (String mime : this.mimetypesVector) {
            types.add(new MimeType(mime));
        }
        this.mimes = types;
    }

    public Vector getMimetypesVector() {
        return this.mimetypesVector;
    }
}

