/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.registry.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.jetspeed.om.registry.InvalidEntryException;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.registry.RegistryException;
import org.apache.jetspeed.om.registry.SecurityEntry;
import org.apache.jetspeed.om.registry.base.BaseRegistry;
import org.apache.jetspeed.om.registry.base.BaseSecurityEntry;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class BaseSecurityRegistry
extends BaseRegistry {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(BaseSecurityRegistry.class.getName());

    public void setEntry(RegistryEntry entry) throws InvalidEntryException {
        try {
            Registry.addEntry(Registry.SECURITY, entry);
        }
        catch (RegistryException e) {
            logger.error("Exception", e);
        }
    }

    public void addEntry(RegistryEntry entry) throws InvalidEntryException {
        try {
            Registry.addEntry(Registry.SECURITY, entry);
        }
        catch (RegistryException e) {
            logger.error("Exception", e);
        }
    }

    public void removeEntry(String name) {
        Registry.removeEntry(Registry.SECURITY, name);
    }

    public void removeEntry(RegistryEntry entry) {
        if (entry != null) {
            Registry.removeEntry(Registry.SECURITY, entry.getName());
        }
    }

    public RegistryEntry createEntry() {
        return new BaseSecurityEntry();
    }

    public SecurityEntry getSecurityEntry(String name) {
        try {
            return (SecurityEntry)((Object)this.getEntry(name));
        }
        catch (InvalidEntryException e) {
            logger.error("Exception", e);
            return null;
        }
    }

    public SecurityEntry createSecurityEntry() {
        return (SecurityEntry)((Object)this.createEntry());
    }

    public SecurityEntry cloneSecurityEntry(String original, String newName) {
        SecurityEntry baseEntry = this.getSecurityEntry(original);
        if (baseEntry != null) {
            SecurityEntry newEntry = BaseSecurityRegistry.cloneEntry(baseEntry);
            newEntry.setName(newName);
            return newEntry;
        }
        return null;
    }

    private static SecurityEntry cloneEntry(SecurityEntry secEntry) {
        SecurityEntry clonedEntry = null;
        try {
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(100);
            ObjectOutputStream objectoutputstream = new ObjectOutputStream(bytearrayoutputstream);
            objectoutputstream.writeObject(secEntry);
            byte[] abyte0 = bytearrayoutputstream.toByteArray();
            objectoutputstream.close();
            ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(abyte0);
            ObjectInputStream objectinputstream = new ObjectInputStream(bytearrayinputstream);
            clonedEntry = (SecurityEntry)objectinputstream.readObject();
            objectinputstream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clonedEntry;
    }
}

