/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.security;

import org.apache.jetspeed.om.security.BaseJetspeedRole;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.services.security.RoleException;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;

public class JetspeedRoleFactory {
    private static final String CONFIG_ROLE_CLASSNAME = "role.class";
    private static String roleClassName = null;
    private static Class roleClass = null;

    public static Role getInstance() throws RoleException {
        return JetspeedRoleFactory.getInstance(true);
    }

    public static Role getInstance(boolean isNew) throws RoleException {
        Role role = null;
        if (null == roleClassName) {
            try {
                ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
                roleClassName = serviceConf.getString(CONFIG_ROLE_CLASSNAME);
                roleClass = Class.forName(roleClassName);
            }
            catch (Exception e) {
                throw new RoleException("RoleFactory: Failed to create a Class object for Role implementation: " + e.toString());
            }
        }
        try {
            role = (Role)roleClass.newInstance();
            if (role instanceof BaseJetspeedRole) {
                ((BaseJetspeedRole)role).setNew(isNew);
            }
        }
        catch (Exception e) {
            throw new RoleException("Failed instantiate an Role implementation object: " + e.toString());
        }
        return role;
    }
}

