/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.ecs.ConcreteElement;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.MetaInfo;
import org.apache.jetspeed.om.profile.PSMLDocument;
import org.apache.jetspeed.om.profile.Parameter;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.psml.PsmlParameter;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletInstance;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;

public class JetspeedPortletInstance
implements PortletInstance {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedPortletInstance.class.getName());
    private Profile m_profile = null;
    private Profile m_clonedProfile = null;
    private JetspeedRunData m_rundata = null;
    private Portlet m_portlet = null;

    public JetspeedPortletInstance(Portlet portlet, RunData data) {
        this(portlet, ((JetspeedRunData)data).getProfile());
        this.m_rundata = (JetspeedRunData)data;
        this.m_clonedProfile = ((JetspeedRunData)data).getCustomizedProfile();
    }

    public JetspeedPortletInstance(Portlet portlet, Profile profile) {
        this.m_portlet = portlet;
        this.m_profile = profile;
    }

    protected JetspeedPortletInstance() {
    }

    public String getAttribute(String name, String dftValue) {
        Entry entry = this.getEntry();
        if (entry == null) {
            return dftValue;
        }
        Parameter attr = entry.getParameter(name);
        if (attr != null) {
            return attr.getValue();
        }
        return dftValue;
    }

    public String getAttribute(String name) {
        Entry entry = this.getEntry();
        if (entry == null) {
            return "";
        }
        Parameter attr = entry.getParameter(name);
        if (attr != null) {
            return attr.getValue();
        }
        return "";
    }

    public void setAttribute(String name, String value) {
        this.setupForUpdate();
        Entry entry = this.getEntry();
        Parameter attr = entry.getParameter(name);
        if (value == null) {
            this.removeAttribute(name);
        } else if (attr != null) {
            attr.setValue(value);
        } else {
            PsmlParameter newAttr = new PsmlParameter();
            newAttr.setName(name);
            newAttr.setValue(value);
            entry.addParameter(newAttr);
        }
    }

    public void removeAttribute(String name) {
        this.setupForUpdate();
        Entry entry = this.getEntry();
        Iterator params = entry.getParameterIterator();
        int index = -1;
        int count = 0;
        while (params.hasNext()) {
            Parameter param = (Parameter)params.next();
            if (param.getName().equalsIgnoreCase(name)) {
                index = count;
                break;
            }
            ++count;
        }
        if (index != -1) {
            entry.removeParameter(index);
        }
    }

    public void removeAllAttributes() {
        this.setupForUpdate();
        Entry entry = this.getEntry();
        entry.removeAllParameter();
    }

    public Iterator getAttributes() {
        Entry entry = this.getEntry();
        return entry.getParameterIterator();
    }

    public Iterator getAttributeNames() {
        Iterator itr = this.getAttributes();
        ArrayList<String> list = new ArrayList<String>();
        while (itr.hasNext()) {
        }
        Parameter param = (Parameter)itr.next();
        list.add(param.getName());
        return list.iterator();
    }

    public PSMLDocument getDocument() {
        return this.getProfile().getDocument();
    }

    public Profile getProfile() {
        if (this.m_clonedProfile != null) {
            return this.m_clonedProfile;
        }
        return this.m_profile;
    }

    public Entry getEntry() {
        return this.getDocument().getEntryById(this.m_portlet.getID());
    }

    public String getDescription() {
        MetaInfo metaInfo;
        Entry entry = this.getEntry();
        String description = null;
        if (entry != null && (metaInfo = entry.getMetaInfo()) != null) {
            description = metaInfo.getDescription();
        }
        return this.m_portlet.getDescription(description);
    }

    public String getName() {
        return this.getEntry().getParent();
    }

    public String getTitle() {
        MetaInfo metaInfo;
        Entry entry = this.getEntry();
        String title = null;
        if (entry != null && (metaInfo = entry.getMetaInfo()) != null) {
            title = metaInfo.getTitle();
        }
        return this.m_portlet.getTitle(title);
    }

    public String getImage() {
        MetaInfo metaInfo;
        Entry entry = this.getEntry();
        String image = null;
        if (entry != null && (metaInfo = entry.getMetaInfo()) != null) {
            image = metaInfo.getImage();
            return image;
        }
        return this.m_portlet.getImage(image);
    }

    public Portlet getPortlet() {
        return this.m_portlet;
    }

    public ConcreteElement getContent() {
        return this.m_portlet.getContent((RunData)this.m_rundata);
    }

    public boolean isShowTitleBar() {
        return this.m_portlet.isShowTitleBar((RunData)this.m_rundata);
    }

    private void setupForUpdate() {
        if (this.m_clonedProfile != null) {
            return;
        }
        try {
            this.m_clonedProfile = (Profile)this.m_profile.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.warn("JetspeedPortletInstance: cannot clone Profile!: " + e);
        }
    }
}

