/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets.admin;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.StringElement;
import org.apache.ecs.html.A;
import org.apache.ecs.html.Center;
import org.apache.ecs.html.Form;
import org.apache.ecs.html.Input;
import org.apache.ecs.html.Option;
import org.apache.ecs.html.P;
import org.apache.ecs.html.Select;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TR;
import org.apache.ecs.html.Table;
import org.apache.ecs.html.TextArea;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.portlets.AbstractPortlet;
import org.apache.jetspeed.portal.portlets.admin.ContentMarkup;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.xml.api.jcm.Content;
import org.apache.jetspeed.xml.api.jcm.Entry;
import org.apache.jetspeed.xml.api.jcm.Item;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;

public class JetspeedContentAdmin
extends AbstractPortlet {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedContentAdmin.class.getName());
    public static final String PROVIDER_NAME_KEY = "provider-name";
    public static final String POST_ARTICLE = "Post Article";
    private Hashtable content = new Hashtable();

    public ConcreteElement getContent(RunData rundata) {
        ParameterParser params = rundata.getParameters();
        String provider = params.getString(PROVIDER_NAME_KEY);
        if (provider == null) {
            return this.getProviders(rundata);
        }
        if (params.getString(POST_ARTICLE) != null) {
            params.remove(PROVIDER_NAME_KEY);
            params.remove(POST_ARTICLE);
            return this.postArticle(provider, rundata);
        }
        params.remove(PROVIDER_NAME_KEY);
        return this.getForm(provider, rundata);
    }

    public String getURL(String provider) {
        return JetspeedResources.getString("content.provider." + provider + ".url");
    }

    public synchronized ConcreteElement postArticle(String provider, RunData rundata) {
        ElementContainer ec = new ElementContainer();
        ParameterParser params = rundata.getParameters();
        String topic = params.getString("topic", "");
        String title = params.getString("title", "");
        String link = params.getString("link", "");
        String description = params.getString("description", "");
        Item item = new Item();
        item.setTopic(topic);
        item.setTitle(title);
        item.setLink(link);
        item.setDescription(description);
        Content content = null;
        try {
            content = this.getContentMarkup(this.getURL(provider)).getContent();
            Vector<Item> v = new Vector<Item>();
            Item[] items = content.getChannel().getItem();
            for (int i = 0; i < items.length; ++i) {
                v.addElement(items[i]);
            }
            v.insertElementAt(item, 0);
            Object[] newItems = new Item[v.size()];
            v.copyInto(newItems);
            content.getChannel().removeAllItem();
            for (int i = 0; i < newItems.length; ++i) {
                content.getChannel().addItem((Item)newItems[i]);
            }
            this.getContentMarkup(this.getURL(provider)).save();
        }
        catch (Throwable t) {
            logger.error("Throwable", t);
            return new StringElement("Can't use this provider: " + t.getMessage());
        }
        ec.addElement("Your article '" + title + "' has been posted within '" + topic + "'");
        return ec;
    }

    public ConcreteElement getProviders(RunData rundata) {
        ElementContainer root = new ElementContainer();
        root.addElement((Element)new P().addElement("Select a content provider: "));
        Vector v = JetspeedResources.getVector((String)"content.provider.list");
        for (int i = 0; i < v.size(); ++i) {
            String provider = (String)v.elementAt(i);
            String title = JetspeedResources.getString("content.provider." + provider + ".title");
            DynamicURI uri = new DynamicURI(rundata);
            uri.addQueryData(rundata.getParameters());
            uri.addQueryData(PROVIDER_NAME_KEY, provider);
            P row = new P().addElement((Element)new A(uri.toString()).addElement(title)).addElement(" ( ").addElement((Element)new A(this.getBookmarklet(provider, rundata)).addElement("Bookmarklet")).addElement(" ) ");
            root.addElement((Element)row);
        }
        return root;
    }

    private ConcreteElement getForm(String provider, RunData rundata) {
        DynamicURI duri = new DynamicURI(rundata);
        Form form = new Form().setAction(duri.toString());
        Table table = new Table().setBorder(0);
        form.addElement((Element)table);
        ParameterParser params = rundata.getParameters();
        String topic = params.getString("topic", "");
        String title = params.getString("title", "");
        String link = params.getString("link", "");
        String description = params.getString("description", "");
        Content content = null;
        try {
            content = this.getContentMarkup(this.getURL(provider)).getContent();
        }
        catch (Exception e) {
            logger.error("Exception", e);
            return new StringElement("Can't use this provider: " + e.getMessage());
        }
        Select select = new Select();
        select.setName("topic");
        Entry[] topics = content.getChannel().getTopics().getEntry();
        for (int i = 0; i < topics.length; ++i) {
            String name = topics[i].getName();
            select.addElement((Element)new Option(name).addElement(name));
        }
        table.addElement((Element)this.getRow("Topic: ", (ConcreteElement)select));
        table.addElement((Element)this.getRow("Title: ", (ConcreteElement)new Input().setType("text").setName("title").setValue(title)));
        table.addElement((Element)this.getRow("Link: ", (ConcreteElement)new Input().setType("text").setName("link").setValue(link)));
        table.addElement((Element)new TR().addElement((Element)new TD().setColSpan(2).addElement((Element)new TextArea().setName("description").setCols(65).setRows(15).addElement(description))));
        form.addElement((Element)new Input().setType("hidden").setName(PROVIDER_NAME_KEY).setValue(provider));
        form.addElement((Element)new Input().setType("submit").setName(POST_ARTICLE).setValue(POST_ARTICLE));
        return new Center((Element)form);
    }

    private TR getRow(String title, ConcreteElement ce) {
        int TITLE_WIDTH = 30;
        TR tr = new TR().addElement((Element)new TD().setWidth(TITLE_WIDTH).addElement(title)).addElement((Element)new TD().addElement((Element)ce));
        return tr;
    }

    public ContentMarkup getContentMarkup(String url) throws Exception {
        ContentMarkup cm = (ContentMarkup)this.content.get(url);
        if (cm == null) {
            cm = new ContentMarkup(url);
            this.content.put(url, cm);
        }
        return cm;
    }

    public void init() throws PortletException {
        this.setTitle("Jetspeed Content");
        this.setDescription("Publish Jetspeed Content.");
    }

    private String getBookmarklet(String provider, RunData rundata) {
        ParameterParser params = rundata.getParameters();
        StringBuffer buff = new StringBuffer();
        buff.append("JavaScript:");
        buff.append("top.location = '" + rundata.getServerScheme() + "://" + rundata.getServerName() + (rundata.getServerPort() != 80 ? ":" + rundata.getServerPort() : "") + rundata.getScriptName() + "?select-panel=JetspeedContentAdmin");
        buff.append("&provider-name=" + provider);
        buff.append("&title=' + escape( document.title ) + '&link=' + escape( top.location );");
        return buff.toString();
    }

    public boolean getAllowEdit(RunData rundata) {
        return false;
    }

    public boolean getAllowMaximize(RunData rundata) {
        return false;
    }
}

