/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets.viewprocessor;

import java.util.Iterator;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.StringElement;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.portlets.GenericMVCContext;
import org.apache.jetspeed.portal.portlets.viewprocessor.ViewProcessor;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.TemplateLocator;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.util.ServiceUtil;
import org.apache.turbine.services.jsp.JspService;
import org.apache.turbine.util.RunData;

public class JSPViewProcessor
implements ViewProcessor {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JSPViewProcessor.class.getName());

    public Object processView(GenericMVCContext context) {
        Portlet portlet = (Portlet)context.get("portlet");
        RunData data = (RunData)context.get("data");
        HttpServletRequest request = data.getRequest();
        String template = (String)context.get("template");
        logger.info("JSPViewProcessor - processing template " + template);
        try {
            request.setAttribute("portlet", (Object)portlet);
            request.setAttribute("context", (Object)context);
            request.setAttribute("js_peid", (Object)portlet.getID());
            request.setAttribute("rundata", (Object)data);
            PortletEntry pe = (PortletEntry)Registry.getEntry(Registry.PORTLET, portlet.getName());
            if (pe.getURL() == null || pe.getURL().trim().length() == 0) {
                if (template != null && -1 == template.indexOf(".jsp")) {
                    template = template + ".jsp";
                }
                logger.info("JSPViewProcessor - locating template - " + data.toString() + " - " + template);
                String locatedTemplate = TemplateLocator.locatePortletTemplate(data, template);
                logger.info("JSPViewProcessor - located template: " + locatedTemplate);
                JspService service = (JspService)ServiceUtil.getServiceByName("JspService");
                service.addDefaultObjects(data);
                service.handleRequest(data, locatedTemplate);
            } else {
                Iterator names = portlet.getPortletConfig().getInitParameterNames();
                while (names.hasNext()) {
                    String name = (String)names.next();
                    String value = portlet.getPortletConfig().getInitParameter(name);
                    data.getParameters().setString(name, value);
                }
                template = pe.getURL();
                if (logger.isDebugEnabled()) {
                    logger.debug("JSPViewProcessor - serving jsp directly using: " + template);
                }
                RequestDispatcher dispatcher = data.getServletContext().getRequestDispatcher(template);
                data.getOut().flush();
                dispatcher.include((ServletRequest)data.getRequest(), (ServletResponse)data.getResponse());
            }
        }
        catch (Exception e) {
            String message = "JSPViewProcessor: Could not include the following JSP Page:  [" + template + "] :\n\t" + e.getMessage();
            logger.error(message, e);
            return new StringElement(message);
        }
        return new ElementContainer();
    }

    public void init(Portlet portlet) {
    }
}

