/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.Service;

public class ServiceHelper {
    private static final JetspeedLogger log = JetspeedLogFactoryService.getLogger(ServiceHelper.class.getName());

    public static Class loadModelClass(Service service, String configurationName) throws InitializationException {
        String className = service.getConfiguration().getString(configurationName, null);
        if (null == className) {
            throw new InitializationException(configurationName + " implementation configuration not found.");
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new InitializationException("Could not preload " + className + " implementation class.", (Throwable)e);
        }
    }

    public static Object createObject(Class classe) {
        Object object = null;
        try {
            object = classe.newInstance();
        }
        catch (Exception e) {
            log.error("Factory failed to create object: " + classe.getName(), e);
        }
        return object;
    }
}

