/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.jsp.tags;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.ecs.ConcreteElement;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.modules.ScreenLoader;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.RunData;

public class EcsScreenTag
extends TagSupport {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(EcsScreenTag.class.getName());

    public int doStartTag() throws JspException {
        RunData data = (RunData)this.pageContext.getAttribute("rundata", 2);
        String screenName = data.getScreen();
        if (screenName.equals("BaseJspScreen")) {
            screenName = TurbineResources.getString((String)"screen.homepage");
        }
        try {
            this.pageContext.getOut().flush();
            ConcreteElement screenElement = ScreenLoader.getInstance().eval(data, screenName);
            if (screenElement != null) {
                screenElement.setCodeSet(data.getResponse().getCharacterEncoding());
                screenElement.output(data.getResponse().getWriter());
            }
        }
        catch (Exception e) {
            String message = "Error processing ecs screen '" + screenName + "'.";
            logger.error(message, e);
            try {
                data.getOut().print("Error processing ecs screen '" + screenName + "'. See log for more information.");
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return 0;
    }
}

