/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.jsp.tags;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.ecs.ConcreteElement;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.template.JetspeedTool;
import org.apache.turbine.util.RunData;

public class JetspeedPaneTag
extends TagSupport {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedPaneTag.class.getName());
    private String name = null;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int doStartTag() throws JspException {
        JetspeedRunData data = (JetspeedRunData)this.pageContext.getAttribute("rundata", 2);
        if (this.name == null) {
            this.name = JetspeedResources.getString("screen.homepage");
        }
        try {
            this.pageContext.getOut().flush();
            ConcreteElement result = new ConcreteElement();
            if (data != null && data.getUser() != null) {
                JetspeedTool jt = new JetspeedTool((RunData)data);
                String jspeid = (String)data.getUser().getTemp("js_peid");
                if (jspeid != null) {
                    data.setMode(2);
                    result = jt.getPortletById(jspeid);
                } else {
                    result = jt.getPane(this.name);
                }
            }
            if (result != null) {
                result.setCodeSet(data.getResponse().getCharacterEncoding());
                result.output(data.getResponse().getWriter());
            }
        }
        catch (Exception e) {
            String message = "Error processing name '" + this.name + "'.";
            logger.error(message, e);
            try {
                data.getOut().print("Error processing ecs screen '" + this.name + "'. See log for more information.");
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return 0;
    }
}

