/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.persistence;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.PSMLDocument;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.portal.JetspeedPortletInstance;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.PortletInstance;
import org.apache.jetspeed.services.PortletFactory;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.persistence.PortalPersistenceException;
import org.apache.jetspeed.services.persistence.PortalPersistenceService;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.util.RunData;

public class JetspeedPortalPersistenceService
extends TurbineBaseService
implements PortalPersistenceService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedPortalPersistenceService.class.getName());

    public void init(RunData data) throws InitializationException {
        if (!(data instanceof JetspeedRunData)) {
            logger.error("[PortalPersistenceService] The current RunData implenetation does not implement the JetspeedRunData interface.");
            this.setInit(false);
            throw new InitializationException("The current RunData implenetation does not implement the JetspeedRunData interface.");
        }
        super.init(data);
    }

    public PortletInstance getInstance(Portlet portlet, Profile profile) {
        return new JetspeedPortletInstance(portlet, profile);
    }

    public PortletInstance getInstance(Portlet portlet, RunData data) {
        String attrKey = "portlet_instance:" + portlet.getID();
        PortletInstance instance = (PortletInstance)data.getRequest().getAttribute(attrKey);
        if (instance != null) {
            return instance;
        }
        instance = new JetspeedPortletInstance(portlet, data);
        data.getRequest().setAttribute(attrKey, (Object)instance);
        return instance;
    }

    public void store(PortletInstance pPortlet) throws PortalPersistenceException {
        Profile profile = pPortlet.getProfile();
        profile.setDocument(pPortlet.getDocument());
        if (!PsmlManager.store(profile)) {
            throw new PortalPersistenceException("Unable to write portlet information.");
        }
    }

    public List getInstances(Profile profile) throws PortletException {
        PSMLDocument doc = profile.getDocument();
        Portlets portlets = doc.getPortlets();
        ArrayList pList = new ArrayList();
        this.buildAllEntries(portlets, pList, profile);
        return pList;
    }

    public List getInstances(RunData data) throws PortletException {
        JetspeedRunData jData = (JetspeedRunData)data;
        return this.getInstances(jData.getProfile());
    }

    protected void buildAllEntries(Portlets portlets, ArrayList entries, Profile profile) throws PortletException {
        Iterator eItr = portlets.getEntriesIterator();
        while (eItr.hasNext()) {
            Object obj = eItr.next();
            Entry entry = (Entry)obj;
            Portlet portlet = PortletFactory.getPortlet(entry);
            entries.add(new JetspeedPortletInstance(portlet, profile));
        }
        if (portlets.getPortletsCount() > 0) {
            Iterator pItr = portlets.getPortletsIterator();
            while (pItr.hasNext()) {
                Portlets childPortlets = (Portlets)pItr.next();
                this.buildAllEntries(childPortlets, entries, profile);
            }
            return;
        }
    }
}

