/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.psmlmanager.db;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

public class DBUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(DBUtils.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Portlets bytesToPortlets(byte[] portletBytes, Mapping mapping) {
        StringReader reader = new StringReader(new String(portletBytes));
        try {
            Unmarshaller unmarshaller = new Unmarshaller(mapping);
            Portlets portlets = (Portlets)unmarshaller.unmarshal((Reader)reader);
            return portlets;
        }
        catch (MarshalException e) {
            logger.error("PSMLManager: Could not unmarshal the inputstream ", e);
        }
        catch (MappingException e) {
            logger.error("PSMLManager: Could not unmarshal the inputstream ", e);
        }
        catch (ValidationException e) {
            logger.error("PSMLManager: document is not valid", e);
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException e) {
                logger.error("", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] portletsToBytes(Portlets portlets, Mapping mapping) {
        if (portlets == null) {
            String message = "PSMLManager: Must specify portlets";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        StringWriter writer = new StringWriter();
        try {
            Marshaller marshaller = new Marshaller((Writer)writer);
            marshaller.setMapping(mapping);
            marshaller.marshal((Object)portlets);
            if (logger.isDebugEnabled()) {
                logger.debug("Portlets: " + writer.toString());
            }
            byte[] byArray = writer.toString().getBytes();
            return byArray;
        }
        catch (MarshalException e) {
            logger.error("PSMLManager: Could not marshal the stringwriter ", e);
        }
        catch (IOException e) {
            logger.error("PSMLManager: Could not marshal the stringwriter ", e);
        }
        catch (MappingException e) {
            logger.error("PSMLManager: Could not marshal the stringwriter ", e);
        }
        catch (ValidationException e) {
            logger.error("PSMLManager: document is not valid", e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                logger.error("", e);
            }
        }
        return null;
    }
}

