/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.security;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.Permission;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.security.CachedAcl;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.SecurityCacheService;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;

public class SecurityCacheImpl
extends TurbineBaseService
implements SecurityCacheService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(SecurityCacheImpl.class.getName());
    protected Map acls = new HashMap();
    protected Map perms = new HashMap();

    protected static SecurityCacheService getService() {
        return (SecurityCacheService)TurbineServices.getInstance().getService("SecurityCache");
    }

    public void load(String username) throws JetspeedSecurityException {
        CachedAcl acl = new CachedAcl(username);
        acl.setRoles(JetspeedSecurity.getRoles(username));
        this.acls.put(username, acl);
        if (this.perms.size() == 0) {
            this.loadRolePermissions();
        }
    }

    public void unload(String username) {
        this.acls.remove(username);
    }

    public Role getRole(String roleName) {
        return (Role)this.perms.get(roleName);
    }

    public Role getRole(String username, String roleName) {
        CachedAcl acl = (CachedAcl)this.acls.get(username);
        if (acl == null) {
            return null;
        }
        return acl.getRole(roleName);
    }

    public Role getRole(String username, String roleName, String groupName) {
        CachedAcl acl = (CachedAcl)this.acls.get(username);
        if (acl == null) {
            return null;
        }
        return acl.getRole(roleName, groupName);
    }

    public void addRole(Role role) {
        if (!this.perms.containsKey(role.getName())) {
            this.perms.put(role.getName(), new HashMap());
        }
    }

    public void addRole(String username, Role role) {
        CachedAcl acl = (CachedAcl)this.acls.get(username);
        if (null != acl) {
            acl.addRole(role);
        }
        if (!this.perms.containsKey(role.getName())) {
            this.perms.put(role.getName(), new HashMap());
        }
    }

    public void addRole(String username, Role role, Group group) {
        CachedAcl acl = (CachedAcl)this.acls.get(username);
        if (null != acl) {
            acl.addRole(role, group);
        }
        if (!this.perms.containsKey(role.getName())) {
            this.perms.put(role.getName(), new HashMap());
        }
    }

    public boolean hasRole(String username, String roleName) {
        return this.hasRole(username, roleName, "Jetspeed");
    }

    public boolean hasRole(String username, String roleName, String groupName) {
        CachedAcl acl = (CachedAcl)this.acls.get(username);
        if (null != acl) {
            return acl.hasRole(roleName, groupName);
        }
        return false;
    }

    public void removeRole(String username, String roleName) {
        this.removeRole(username, roleName, "Jetspeed");
    }

    public void removeRole(String username, String roleName, String groupName) {
        CachedAcl acl = (CachedAcl)this.acls.get(username);
        if (null != acl) {
            acl.removeRole(roleName, groupName);
        }
        this.perms.remove(roleName);
    }

    public CachedAcl getAcl(String username) {
        return (CachedAcl)this.acls.get(username);
    }

    public Iterator getRoles(String username) {
        CachedAcl acl = (CachedAcl)this.acls.get(username);
        if (null != acl) {
            return acl.getRoles();
        }
        return null;
    }

    public Permission getPermission(String roleName, String permissionName) {
        Map map = (Map)this.perms.get(roleName);
        if (null != map) {
            return (Permission)map.get(permissionName);
        }
        return null;
    }

    public void addPermission(String roleName, Permission permission) {
        Map map = (Map)this.perms.get(roleName);
        if (null != map) {
            map.put(permission.getName(), permission);
        }
    }

    public boolean hasPermission(String roleName, String permissionName) {
        Map map = (Map)this.perms.get(roleName);
        if (null != map) {
            return map.containsKey(permissionName);
        }
        return false;
    }

    public void removePermission(String roleName, String permissionName) {
        Map map = (Map)this.perms.get(roleName);
        if (null != map) {
            map.remove(permissionName);
        }
    }

    public Iterator getPermissions(String roleName) {
        Map map = (Map)this.perms.get(roleName);
        if (map != null) {
            return map.values().iterator();
        }
        return null;
    }

    public void removeAllRoles(String rolename) {
        for (CachedAcl acl : this.acls.values()) {
            acl.removeRole(rolename);
        }
        this.perms.remove(rolename);
    }

    public void removeAllPermissions(String permissionName) {
        for (Map map : this.perms.values()) {
            map.remove(permissionName);
        }
    }

    public void loadRolePermissions() {
        try {
            Iterator roles = JetspeedSecurity.getRoles();
            while (roles.hasNext()) {
                Role role = (Role)roles.next();
                HashMap<String, Permission> map = new HashMap<String, Permission>();
                Iterator prms = JetspeedSecurity.getPermissions(role.getName());
                while (prms.hasNext()) {
                    Permission perm = (Permission)prms.next();
                    map.put(perm.getName(), perm);
                }
                this.perms.put(role.getName(), map);
            }
        }
        catch (JetspeedSecurityException e) {
            logger.error("Exception", (Throwable)((Object)e));
        }
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        this.setInit(true);
    }
}

