/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.transformer;

import java.io.Reader;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.services.transformer.TransformerService;
import org.apache.jetspeed.util.rewriter.ClipperRewriter;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.util.Log;

public class JetspeedTransformerService
extends TurbineBaseService
implements TransformerService {
    protected ClipperRewriter rewriter = null;
    String convertedString;

    public void init(ServletConfig conf) {
        if (this.getInit()) {
            return;
        }
        this.rewriter = new ClipperRewriter();
        this.setInit(true);
    }

    public void init() {
        while (!this.getInit()) {
            try {
                Thread.sleep(500L);
                Log.info((String)"JetspeedTransformerService: Waiting for init()...");
            }
            catch (InterruptedException ie) {
                Log.error((Throwable)ie);
            }
        }
    }

    public String findElement(Reader htmlReader, String url, String element) {
        return this.clipElementsNumber(htmlReader, url, element, null, 1);
    }

    public String clipElements(Reader htmlReader, String url, String startElement, String stopElement) {
        return this.clipElementsNumber(htmlReader, url, startElement, stopElement, 1);
    }

    public String findElementNumber(Reader htmlReader, String url, String element, int tagNumber) {
        return this.clipElementsNumber(htmlReader, url, element, null, tagNumber);
    }

    public String clipElementsNumber(Reader htmlReader, String url, String startElement, String stopElement, int tagNumber) {
        this.rewriter.setStartElement(startElement);
        this.rewriter.setStopElement(stopElement);
        this.rewriter.setStartElementNumber(tagNumber);
        try {
            this.convertedString = this.rewriter.rewrite(htmlReader, url);
        }
        catch (Exception e) {
            Log.info((String)("Exception occurred:" + e.toString()));
            e.printStackTrace();
        }
        return this.convertedString;
    }
}

