/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.rewriter;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import org.apache.jetspeed.util.rewriter.Rewriter;
import org.apache.jetspeed.util.rewriter.SwingParserAdaptor;

public class ProxyRewriter
implements Rewriter {
    private String proxyRoot;
    private String baseURL;
    public static final String DEFAULT_PROXY_PARAM = "js_path";
    private static final char[] GIF = new char[]{'g', 'i', 'f'};
    private static final char[] PNG = new char[]{'p', 'n', 'g'};
    private static final char[] JPG = new char[]{'j', 'p', 'g'};
    protected static final char PATH_SEPARATOR = '/';

    public String rewrite(Reader input, String proxyRoot, String baseURL) throws MalformedURLException {
        String rewrittenHTML = "";
        this.proxyRoot = proxyRoot;
        this.baseURL = baseURL;
        SwingParserAdaptor parser = new SwingParserAdaptor(this);
        rewrittenHTML = parser.run(input);
        return rewrittenHTML;
    }

    public String generateNewUrl(String targetURL, HTML.Tag tag, HTML.Attribute attribute) {
        try {
            URL full = new URL(new URL(this.proxyRoot), targetURL);
            String fullPath = full.toString();
            StringBuffer buffer = new StringBuffer(this.proxyRoot.toString());
            buffer.append("?");
            buffer.append(DEFAULT_PROXY_PARAM);
            buffer.append("=");
            buffer.append(URLEncoder.encode(fullPath));
            String proxiedPath = buffer.toString().replace('&', '@');
            return proxiedPath;
        }
        catch (Throwable t) {
            System.err.println("HTMLRewriter: BASE=" + this.proxyRoot);
            System.err.println("target=" + targetURL);
            return URLEncoder.encode(targetURL);
        }
    }

    public boolean proxyAllTags() {
        return true;
    }

    public String rewrite(Reader input, String baseURL) throws MalformedURLException {
        String rewrittenHTML = "";
        this.baseURL = baseURL;
        SwingParserAdaptor parser = new SwingParserAdaptor(this);
        rewrittenHTML = parser.run(input);
        return rewrittenHTML;
    }

    public static byte[] rewriteScript(String script, String url, String proxyHost, String base) throws IOException {
        int baseLength = base.length();
        int totalScriptLength = script.length();
        CharArrayWriter writer = new CharArrayWriter(totalScriptLength + 100);
        char[] chars = script.toCharArray();
        boolean translating = false;
        for (int ix = 0; ix < chars.length; ++ix) {
            if (chars[ix] == '\"') {
                if (translating) {
                    translating = false;
                } else if (!translating) {
                    translating = true;
                    writer.write(chars[ix]);
                    if (!ProxyRewriter.findImage(chars, ix + 1)) continue;
                    String trans = ProxyRewriter.translate(proxyHost, base);
                    writer.write(trans);
                    if (chars[ix + 1] != '/' && base.charAt(baseLength - 1) != '/') {
                        writer.write(47);
                    }
                    if (chars[ix + 1] != '/' || base.charAt(baseLength - 1) != '/') continue;
                    ++ix;
                    continue;
                }
            }
            if (translating && chars[ix] == '&') {
                writer.write(64);
                continue;
            }
            writer.write(chars[ix]);
        }
        return writer.toString().getBytes();
    }

    public static String translate(String proxyURL, String targetURL) {
        StringBuffer buffer = new StringBuffer(proxyURL);
        buffer.append("?");
        buffer.append(DEFAULT_PROXY_PARAM);
        buffer.append("=");
        buffer.append(targetURL.replace('&', '@'));
        String proxiedPath = buffer.toString();
        return proxiedPath;
    }

    protected static boolean findImage(char[] chars, int ix) {
        for (int iy = ix; iy < chars.length; ++iy) {
            if (chars[iy] == '\"') {
                return false;
            }
            if (chars[iy] != '.') continue;
            int iw = 0;
            for (int iz = iy + 1; iz < chars.length && iw < 3; ++iz, ++iw) {
                if (chars[iz] == GIF[iw] || chars[iz] == PNG[iw] || chars[iz] == JPG[iw]) continue;
                return false;
            }
            return iw == 3;
        }
        return false;
    }

    public boolean enterSimpleTagEvent(HTML.Tag tag, MutableAttributeSet attrs) {
        return true;
    }

    public String exitSimpleTagEvent(HTML.Tag tag, MutableAttributeSet attrs) {
        return null;
    }

    public boolean enterStartTagEvent(HTML.Tag tag, MutableAttributeSet attrs) {
        return true;
    }

    public String exitStartTagEvent(HTML.Tag tag, MutableAttributeSet attrs) {
        return null;
    }

    public boolean enterEndTagEvent(HTML.Tag tag) {
        return true;
    }

    public String exitEndTagEvent(HTML.Tag tag) {
        return null;
    }

    public void convertTagEvent(HTML.Tag tag, MutableAttributeSet attrs) {
    }

    public boolean enterText(char[] values, int param) {
        return false;
    }
}

