/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.rewriter;

import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.Enumeration;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.jetspeed.util.rewriter.HTMLParserAdaptor;
import org.apache.jetspeed.util.rewriter.Rewriter;

public class SwingParserAdaptor
implements HTMLParserAdaptor {
    private Callback cb = new Callback();
    private String lineSeparator;
    private boolean skippingImplied = false;
    private Rewriter rewriter;

    public SwingParserAdaptor(Rewriter rewriter) {
        this.rewriter = rewriter;
        this.lineSeparator = System.getProperty("line.separator", "\r\n");
    }

    public String run(Reader reader) throws MalformedURLException {
        HTMLEditorKit.Parser parser = new ParserGetter().getParser();
        String res = "";
        try {
            parser.parse(reader, this.cb, true);
            res = this.cb.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MalformedURLException(e.toString());
        }
        return res;
    }

    class Callback
    extends HTMLEditorKit.ParserCallback {
        private boolean inForm = false;
        private boolean inScript = false;
        private boolean emit = true;
        private boolean simpleTag = false;
        private StringWriter result = new StringWriter();

        private Callback() {
        }

        public void handleText(char[] values, int param) {
            if (!this.emit) {
                return;
            }
            if (values[0] == '>') {
                return;
            }
            if (!SwingParserAdaptor.this.rewriter.enterText(values, param)) {
                return;
            }
            this.addToResult(values);
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet attrs, int param) {
            this.simpleTag = true;
            if (!SwingParserAdaptor.this.rewriter.enterSimpleTagEvent(tag, attrs)) {
                return;
            }
            if (!this.isValidFragmentTag(tag)) {
                return;
            }
            this.appendTagToResult(tag, attrs);
            if (tag.toString().equalsIgnoreCase("param") || tag.toString().equalsIgnoreCase("object") || tag.toString().equalsIgnoreCase("embed")) {
                this.result.write(SwingParserAdaptor.this.lineSeparator);
            }
            this.simpleTag = false;
            String appended = SwingParserAdaptor.this.rewriter.exitSimpleTagEvent(tag, attrs);
            if (null != appended) {
                this.result.write(appended);
            }
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet attrs, int position) {
            if (!SwingParserAdaptor.this.rewriter.enterStartTagEvent(tag, attrs)) {
                return;
            }
            if (tag == HTML.Tag.HEAD) {
                this.emit = false;
                return;
            }
            if (!this.isValidFragmentTag(tag)) {
                return;
            }
            this.appendTagToResult(tag, attrs);
            this.formatLine(tag);
            String appended = SwingParserAdaptor.this.rewriter.exitStartTagEvent(tag, attrs);
            if (null != appended) {
                this.result.write(appended);
            }
        }

        boolean isValidFragmentTag(HTML.Tag tag) {
            return true;
        }

        public void handleEndTag(HTML.Tag tag, int position) {
            if (!SwingParserAdaptor.this.rewriter.enterEndTagEvent(tag)) {
                return;
            }
            if (tag == HTML.Tag.HEAD) {
                this.emit = true;
                return;
            }
            if (!this.isValidFragmentTag(tag)) {
                return;
            }
            this.addToResult("</").addToResult(tag).addToResult(">");
            this.formatLine(tag);
            String appended = SwingParserAdaptor.this.rewriter.exitEndTagEvent(tag);
            if (null != appended) {
                this.result.write(appended);
            }
        }

        public void handleError(String str, int param) {
        }

        public void handleComment(char[] values, int param) {
        }

        public void handleEndOfLineString(String str) {
            this.addToResult(str);
        }

        private void formatLine(HTML.Tag tag) {
            if (tag.isBlock() || tag.breaksFlow() || tag == HTML.Tag.FRAME || tag == HTML.Tag.FRAMESET || tag == HTML.Tag.SCRIPT) {
                this.result.write(SwingParserAdaptor.this.lineSeparator);
            }
        }

        private Callback addToResult(Object txt) {
            try {
                this.result.write(txt.toString());
            }
            catch (Exception e) {
                System.err.println("Error parsing:" + e);
            }
            return this;
        }

        private Callback addToResult(char[] txt) {
            try {
                this.result.write(txt);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }

        public String getResult() {
            try {
                this.result.flush();
            }
            catch (Exception e) {
                // empty catch block
            }
            String res = " " + this.result.toString();
            return res;
        }

        public void flush() throws BadLocationException {
        }

        private void appendTagToResult(HTML.Tag tag, MutableAttributeSet attrs) {
            this.convertURLS(tag, attrs);
            Enumeration<?> e = attrs.getAttributeNames();
            this.addToResult("<").addToResult(tag);
            while (e.hasMoreElements()) {
                Object attr = e.nextElement();
                String value = attrs.getAttribute(attr).toString();
                this.addToResult(" ").addToResult(attr).addToResult("=\"").addToResult(value).addToResult("\"");
            }
            if (this.simpleTag) {
                this.addToResult("/>");
            } else {
                this.addToResult(">");
            }
        }

        private void convertURLS(HTML.Tag tag, MutableAttributeSet attrs) {
            SwingParserAdaptor.this.rewriter.convertTagEvent(tag, attrs);
            if (tag == HTML.Tag.A && attrs.getAttribute(HTML.Attribute.HREF) != null) {
                this.addProxiedConvertedAttribute(tag, HTML.Attribute.HREF, attrs);
            } else if ((tag == HTML.Tag.IMG || tag == HTML.Tag.INPUT) && attrs.getAttribute(HTML.Attribute.SRC) != null) {
                this.addConvertedAttribute(tag, HTML.Attribute.SRC, attrs, SwingParserAdaptor.this.rewriter.proxyAllTags());
            } else if (tag == HTML.Tag.OPTION && attrs.getAttribute(HTML.Attribute.VALUE) != null) {
                this.addProxiedConvertedAttribute(tag, HTML.Attribute.VALUE, attrs);
            } else if (tag == HTML.Tag.LINK && attrs.getAttribute(HTML.Attribute.HREF) != null) {
                this.addConvertedAttribute(tag, HTML.Attribute.HREF, attrs, SwingParserAdaptor.this.rewriter.proxyAllTags());
            } else if (tag == HTML.Tag.APPLET) {
                this.addConvertedAttribute(tag, HTML.Attribute.CODEBASE, attrs, SwingParserAdaptor.this.rewriter.proxyAllTags());
            } else if (tag == HTML.Tag.FRAME) {
                this.addProxiedConvertedAttribute(tag, HTML.Attribute.SRC, attrs);
            } else if (tag == HTML.Tag.SCRIPT) {
                String s;
                if (attrs.getAttribute(HTML.Attribute.SRC) != null && (s = attrs.getAttribute(HTML.Attribute.SRC).toString()).indexOf("%3E") == -1) {
                    this.addConvertedAttribute(tag, HTML.Attribute.SRC, attrs, SwingParserAdaptor.this.rewriter.proxyAllTags());
                }
            } else if (tag == HTML.Tag.FORM) {
                this.inForm = true;
                if (attrs.getAttribute(HTML.Attribute.ACTION) == null) {
                    attrs.addAttribute(HTML.Attribute.METHOD, "POST");
                } else {
                    attrs.addAttribute(HTML.Attribute.METHOD, "POST");
                    this.addProxiedConvertedAttribute(tag, HTML.Attribute.ACTION, attrs);
                }
            } else if (tag == HTML.Tag.AREA && attrs.getAttribute(HTML.Attribute.HREF) != null) {
                this.addProxiedConvertedAttribute(tag, HTML.Attribute.HREF, attrs);
            } else if (tag == HTML.Tag.BODY && attrs.getAttribute(HTML.Attribute.BACKGROUND) != null) {
                this.addConvertedAttribute(tag, HTML.Attribute.BACKGROUND, attrs, SwingParserAdaptor.this.rewriter.proxyAllTags());
            } else if (tag == HTML.Tag.TD && attrs.getAttribute(HTML.Attribute.BACKGROUND) != null) {
                this.addConvertedAttribute(tag, HTML.Attribute.BACKGROUND, attrs, SwingParserAdaptor.this.rewriter.proxyAllTags());
            }
        }

        private void addConvertedAttribute(HTML.Tag tag, HTML.Attribute attr, MutableAttributeSet attrs, boolean proxy) {
            if (proxy) {
                this.addProxiedConvertedAttribute(tag, attr, attrs);
            } else if (attrs.getAttribute(attr) != null) {
                attrs.addAttribute(attr, this.generateNewUrl(tag, attrs, attr, false));
            }
        }

        private void addProxiedConvertedAttribute(HTML.Tag tag, HTML.Attribute attr, MutableAttributeSet attrs) {
            if (attrs.getAttribute(attr) != null) {
                String attrSource = attrs.getAttribute(attr).toString();
                if (attrSource.startsWith("mailto:")) {
                    attrs.addAttribute(attr, this.generateNewUrl(tag, attrs, attr, true));
                } else if (attrSource.startsWith("javascript:")) {
                    attrs.addAttribute(attr, attrSource);
                } else {
                    attrs.addAttribute(attr, this.generateNewUrl(tag, attrs, attr, true));
                }
            }
        }

        private String generateNewUrl(HTML.Tag tag, MutableAttributeSet attrs, HTML.Attribute attr, boolean proxied) {
            String oldURL = attrs.getAttribute(attr).toString();
            return SwingParserAdaptor.this.rewriter.generateNewUrl(oldURL, tag, attr);
        }
    }

    class ParserGetter
    extends HTMLEditorKit {
        ParserGetter() {
        }

        public HTMLEditorKit.Parser getParser() {
            return super.getParser();
        }
    }
}

