/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.template;

import java.lang.reflect.Method;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;

public class ContentTemplateLink
extends DynamicURI
implements ApplicationTool {
    private String contextPath;
    private String pathToContent;
    private boolean useExternalForm = false;

    public ContentTemplateLink() {
    }

    public ContentTemplateLink(RunData data) {
        super(data);
        this.initForceSecure();
        this.initContextPath(data);
    }

    public void init(Object data) {
        super.init((RunData)data);
        this.initForceSecure();
        this.initContextPath(data);
    }

    protected void initContextPath(Object data) {
        try {
            Class<RunData> runDataClass = RunData.class;
            Method meth = runDataClass.getDeclaredMethod("getContextPath", null);
            this.contextPath = (String)meth.invoke(data, null);
        }
        catch (Exception e) {
            this.contextPath = "";
        }
    }

    protected void initForceSecure() {
        if (JetspeedResources.getBoolean("force.ssl", false)) {
            this.setSecure();
        }
    }

    public void refresh() {
    }

    public ContentTemplateLink getExternal() {
        this.useExternalForm = true;
        return this;
    }

    public ContentTemplateLink getAbsolute() {
        this.useExternalForm = false;
        return this;
    }

    public ContentTemplateLink setURI(String pathToContent) {
        this.pathToContent = pathToContent;
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.useExternalForm) {
            String scheme = this.getServerScheme();
            sb.append(this.getServerScheme());
            sb.append("://");
            sb.append(this.getServerName());
            int port = this.getServerPort();
            if ("http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443) {
                sb.append(":");
                sb.append(port);
            }
        }
        sb.append(this.contextPath);
        sb.append("/");
        if (this.pathToContent != null) {
            sb.append(this.pathToContent);
        }
        this.removePathInfo();
        this.removeQueryData();
        this.pathToContent = null;
        return sb.toString();
    }
}

