/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.fileio;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.account.EipMPost;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FileIOAccountPostCsvFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FileIOAccountPostCsvFormData.class.getName());
    private ALStringField post_name;
    private ALStringField zipcode1;
    private ALStringField zipcode2;
    private ALStringField address;
    private ALStringField post_out_telephone1;
    private ALStringField post_out_telephone2;
    private ALStringField post_out_telephone3;
    private ALStringField post_in_telephone;
    private ALStringField fax_number1;
    private ALStringField fax_number2;
    private ALStringField fax_number3;
    private List<ALEipUser> memberList;
    private boolean is_join_member = true;
    private int post_id;
    private ALStringField zipcode;
    private ALStringField post_out_telephone;
    private ALStringField fax_number;
    private boolean same_post;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
    }

    public void initField() {
        this.post_name = new ALStringField();
        this.post_name.setFieldName(ALLocalizationUtils.getl10n((String)"ACCOUNT_POST_NAME"));
        this.post_name.setTrim(true);
        this.post_name.setValue("");
        this.zipcode1 = new ALStringField();
        this.zipcode1.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_ZIPCODE"));
        this.zipcode1.setTrim(true);
        this.zipcode1.setValue("");
        this.zipcode2 = new ALStringField();
        this.zipcode2.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_ZIPCODE"));
        this.zipcode2.setTrim(true);
        this.zipcode2.setValue("");
        this.address = new ALStringField();
        this.address.setFieldName(ALLocalizationUtils.getl10n((String)"ACCOUNT_POST_ADDRESS"));
        this.address.setTrim(true);
        this.address.setValue("");
        this.post_out_telephone1 = new ALStringField();
        this.post_out_telephone1.setFieldName(ALLocalizationUtils.getl10n((String)"ACCOUNT_OUT_TELEPHONE"));
        this.post_out_telephone1.setTrim(true);
        this.post_out_telephone1.setValue("");
        this.post_out_telephone2 = new ALStringField();
        this.post_out_telephone2.setFieldName(ALLocalizationUtils.getl10n((String)"ACCOUNT_OUT_TELEPHONE"));
        this.post_out_telephone2.setTrim(true);
        this.post_out_telephone2.setValue("");
        this.post_out_telephone3 = new ALStringField();
        this.post_out_telephone3.setFieldName(ALLocalizationUtils.getl10n((String)"ACCOUNT_OUT_TELEPHONE"));
        this.post_out_telephone3.setTrim(true);
        this.post_out_telephone3.setValue("");
        this.post_in_telephone = new ALStringField();
        this.post_in_telephone.setFieldName(ALLocalizationUtils.getl10n((String)"ACCOUNT_IN_TELEPHONE"));
        this.post_in_telephone.setTrim(true);
        this.post_in_telephone.setValue("");
        this.fax_number1 = new ALStringField();
        this.fax_number1.setFieldName(ALLocalizationUtils.getl10n((String)"ACCOUNT_FAX_NUMBER"));
        this.fax_number1.setTrim(true);
        this.fax_number1.setValue("");
        this.fax_number2 = new ALStringField();
        this.fax_number2.setFieldName(ALLocalizationUtils.getl10n((String)"ACCOUNT_FAX_NUMBER"));
        this.fax_number2.setTrim(true);
        this.fax_number2.setValue("");
        this.fax_number3 = new ALStringField();
        this.fax_number3.setFieldName(ALLocalizationUtils.getl10n((String)"ACCOUNT_FAX_NUMBER"));
        this.fax_number3.setTrim(true);
        this.fax_number3.setValue("");
        this.zipcode = new ALStringField();
        this.zipcode.setFieldName(ALLocalizationUtils.getl10n((String)"ACCOUNT_ZIPCODE"));
        this.zipcode.setTrim(true);
        this.zipcode.setValue("");
        this.post_out_telephone = new ALStringField();
        this.post_out_telephone.setFieldName(ALLocalizationUtils.getl10n((String)"ACCOUNT_POST_EXTERNAL_NOMBER"));
        this.post_out_telephone.setTrim(true);
        this.post_out_telephone.setValue("");
        this.fax_number = new ALStringField();
        this.fax_number.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_FAX_NUMBER"));
        this.fax_number.setTrim(true);
        this.fax_number.setValue("");
        this.setSamePost(false);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            try {
                if ("update".equals(this.getMode())) {
                    this.post_id = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
                }
                if (this.is_join_member) {
                    Object[] str = rundata.getParameters().getStrings("member_to");
                    if (str == null) {
                        return res;
                    }
                    Expression exp = ExpressionFactory.inExp((String)"loginName", (Object[])str);
                    SelectQuery query = Database.query(TurbineUser.class, (Expression)exp);
                    List list = query.fetchList();
                    int size = list.size();
                    for (int i = 0; i < size; ++i) {
                        TurbineUser record = (TurbineUser)list.get(i);
                        ALEipUser user = new ALEipUser();
                        user.initField();
                        user.setName(record.getLoginName());
                        user.setAliasName(record.getFirstName(), record.getLastName());
                        this.memberList.add(user);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)"fileio", (Throwable)ex);
            }
        }
        return res;
    }

    protected void setValidator() {
        this.post_name.setNotNull(true);
        this.post_name.limitMaxLength(50);
        this.zipcode1.setCharacterType(2);
        this.zipcode1.limitLength(3, 3);
        this.zipcode2.setCharacterType(2);
        this.zipcode2.limitLength(4, 4);
        this.address.limitMaxLength(64);
        this.post_out_telephone1.setCharacterType(2);
        this.post_out_telephone1.limitMaxLength(5);
        this.post_out_telephone2.setCharacterType(2);
        this.post_out_telephone2.limitMaxLength(4);
        this.post_out_telephone3.setCharacterType(2);
        this.post_out_telephone3.limitMaxLength(4);
        this.post_in_telephone.setCharacterType(19);
        this.post_in_telephone.limitMaxLength(13);
        this.fax_number1.setCharacterType(2);
        this.fax_number1.limitMaxLength(5);
        this.fax_number2.setCharacterType(2);
        this.fax_number2.limitMaxLength(4);
        this.fax_number3.setCharacterType(2);
        this.fax_number3.limitMaxLength(4);
        this.zipcode.setCharacterType(19);
        this.zipcode.limitMaxLength(15);
        this.post_out_telephone.setCharacterType(19);
        this.post_out_telephone.limitMaxLength(15);
        this.fax_number.setCharacterType(19);
        this.fax_number.limitMaxLength(15);
        this.zipcode1.setNotNull(true);
        this.zipcode2.setNotNull(true);
        this.post_out_telephone1.setNotNull(true);
        this.post_out_telephone2.setNotNull(true);
        this.post_out_telephone3.setNotNull(true);
        this.fax_number1.setNotNull(true);
        this.fax_number2.setNotNull(true);
        this.fax_number3.setNotNull(true);
    }

    protected boolean validate(List<String> msgList) {
        ArrayList dummy = new ArrayList();
        if (!this.post_name.validate(msgList)) {
            this.post_name.setValue("");
        }
        if (!this.post_name.getValue().equals("") && this.getEipMPost() != null) {
            this.setSamePost(true);
            msgList.add(ALLocalizationUtils.getl10n((String)"ACCOUNT_POST_SAME_NAME"));
        }
        if (!this.address.validate(msgList)) {
            this.address.setValue(null);
        }
        if (!(this.post_out_telephone1.getValue().equals("") && this.post_out_telephone2.getValue().equals("") && this.post_out_telephone3.getValue().equals(""))) {
            if (!(this.post_out_telephone1.validate(dummy) && this.post_out_telephone2.validate(dummy) && this.post_out_telephone3.validate(dummy))) {
                msgList.add(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_ALERT_SET_TELEPHONE"));
                this.post_out_telephone.setValue(null);
            } else {
                this.post_out_telephone.setValue(new StringBuffer().append(this.post_out_telephone1.getValue()).append("-").append(this.post_out_telephone2.getValue()).append("-").append(this.post_out_telephone3.getValue()).toString());
            }
        }
        if (!this.post_in_telephone.toString().equals("") && !this.post_in_telephone.validate(msgList)) {
            this.post_in_telephone.setValue(null);
            msgList.add(ALLocalizationUtils.getl10n((String)"ACCOUNT_POST_SET_TELEPHON_ANEXTENSION_NOMBER"));
        }
        if (!(this.fax_number1.getValue().equals("") && this.fax_number2.getValue().equals("") && this.fax_number3.getValue().equals(""))) {
            if (!(this.fax_number1.validate(dummy) && this.fax_number2.validate(dummy) && this.fax_number3.validate(dummy))) {
                msgList.add(ALLocalizationUtils.getl10n((String)"ACCOUNT_POST_SET_FAX_NOMBER"));
                this.fax_number.setValue(null);
            } else {
                this.fax_number.setValue(new StringBuffer().append(this.fax_number1.getValue()).append("-").append(this.fax_number2.getValue()).append("-").append(this.fax_number3.getValue()).toString());
            }
        }
        if (!this.zipcode1.getValue().equals("") || !this.zipcode2.getValue().equals("")) {
            if (!this.zipcode1.validate(dummy) || !this.zipcode2.validate(dummy)) {
                msgList.add(ALLocalizationUtils.getl10n((String)"ACCOUNT_POST_SET_ZIP_CODE"));
                this.zipcode.setValue(null);
            } else {
                this.zipcode.setValue(new StringBuffer().append(this.zipcode1.getValue()).append("-").append(this.zipcode2.getValue()).toString());
            }
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            if (this.getEipMPost() != null) {
                return false;
            }
            TurbineGroup group = (TurbineGroup)Database.create(TurbineGroup.class);
            String name = this.post_name.getValue();
            String groupName = new StringBuffer().append(new Date().getTime()).append("_").append(ALEipUtils.getUserId((RunData)rundata)).toString();
            group.setGroupName(groupName);
            group.setOwnerId(Integer.valueOf(1));
            group.setGroupAliasName(name);
            group.setPublicFlag("1");
            JetspeedSecurity.addGroup((Group)group);
            EipMPost record = (EipMPost)Database.create(EipMPost.class);
            record.setPostName(this.post_name.getValue());
            record.setCompanyId(Integer.valueOf(1));
            record.setZipcode(this.zipcode.getValue());
            record.setAddress(this.address.getValue());
            record.setOutTelephone(this.post_out_telephone.getValue());
            record.setInTelephone(this.post_in_telephone.getValue());
            record.setFaxNumber(this.fax_number.getValue());
            record.setGroupName(groupName);
            Date now = new Date();
            record.setCreateDate(now);
            record.setUpdateDate(now);
            Database.commit();
            ALEipManager.getInstance().reloadPost();
            this.post_id = record.getPostId();
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"fileio", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    public ALStringField getPostName() {
        return this.post_name;
    }

    public ALStringField getAddress() {
        return this.address;
    }

    public ALStringField getFaxNumber1() {
        return this.fax_number1;
    }

    public ALStringField getFaxNumber2() {
        return this.fax_number2;
    }

    public ALStringField getFaxNumber3() {
        return this.fax_number3;
    }

    public ALStringField getOutTelephone1() {
        return this.post_out_telephone1;
    }

    public ALStringField getOutTelephone2() {
        return this.post_out_telephone2;
    }

    public ALStringField getOutTelephone3() {
        return this.post_out_telephone3;
    }

    public ALStringField getInTelephone() {
        return this.post_in_telephone;
    }

    public ALStringField getZipcode1() {
        return this.zipcode1;
    }

    public ALStringField getZipcode2() {
        return this.zipcode2;
    }

    public List<ALEipUser> getMemberList() {
        return this.memberList;
    }

    public List<ALEipUser> getUsers(String groupname) {
        try {
            return ALEipUtils.getUsers((String)groupname);
        }
        catch (Exception e) {
            logger.error((Object)"[ERROR}", (Throwable)e);
            return new ArrayList<ALEipUser>();
        }
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public void setJoinMember(boolean bool) {
        this.is_join_member = bool;
    }

    public boolean isJoinMember() {
        return this.is_join_member;
    }

    public int getPostId() {
        return this.post_id;
    }

    public ALStringField getZipcode() {
        return this.zipcode;
    }

    public ALStringField getOutTelephone() {
        return this.post_out_telephone;
    }

    public ALStringField getFaxNumber() {
        return this.fax_number;
    }

    public boolean getSamePost() {
        return this.same_post;
    }

    public void setSamePost(boolean flg) {
        this.same_post = flg;
    }

    private EipMPost getEipMPost() {
        SelectQuery query = Database.query(EipMPost.class);
        Expression exp = ExpressionFactory.matchExp((String)"postName", (Object)this.post_name);
        query.setQualifier(exp);
        List list = query.fetchList();
        if (list == null || list.size() == 0) {
            return null;
        }
        EipMPost post = (EipMPost)list.get(0);
        return post;
    }

    public void addItemToken(String token, int i) {
        switch (i) {
            case -1: {
                break;
            }
            case 0: {
                this.post_name.setValue(token);
                break;
            }
            case 1: {
                StringTokenizer st = new StringTokenizer(token, "-");
                if (st.hasMoreTokens()) {
                    this.zipcode1.setValue(st.nextToken());
                }
                if (!st.hasMoreTokens()) break;
                this.zipcode2.setValue(st.nextToken());
                break;
            }
            case 2: {
                this.address.setValue(token);
                break;
            }
            case 3: {
                StringTokenizer st = new StringTokenizer(token, "-");
                if (st.hasMoreTokens()) {
                    this.post_out_telephone1.setValue(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    this.post_out_telephone2.setValue(st.nextToken());
                }
                if (!st.hasMoreTokens()) break;
                this.post_out_telephone3.setValue(st.nextToken());
                break;
            }
            case 4: {
                this.post_in_telephone.setValue(token);
                break;
            }
            case 5: {
                StringTokenizer st = new StringTokenizer(token, "-");
                if (st.hasMoreTokens()) {
                    this.fax_number1.setValue(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    this.fax_number2.setValue(st.nextToken());
                }
                if (!st.hasMoreTokens()) break;
                this.fax_number3.setValue(st.nextToken());
                break;
            }
        }
    }
}

