/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DeleteDenyException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.property.ArcProperty;
import org.apache.cayenne.property.ClassDescriptor;
import org.apache.cayenne.property.CollectionProperty;
import org.apache.cayenne.property.Property;
import org.apache.cayenne.property.PropertyVisitor;
import org.apache.cayenne.property.SingleObjectArcProperty;

class ObjectContextDeleteAction {
    private ObjectContext context;

    ObjectContextDeleteAction(ObjectContext context) {
        this.context = context;
    }

    boolean performDelete(Persistent object) throws DeleteDenyException {
        int oldState = object.getPersistenceState();
        if (oldState == 1 || oldState == 6) {
            return false;
        }
        if (object.getObjectContext() == null) {
            throw new CayenneRuntimeException("Attempt to delete unregistered non-TRANSIENT object: " + object);
        }
        if (object.getObjectContext() != this.context) {
            throw new CayenneRuntimeException("Attempt to delete object regsitered in a different ObjectContext. Object: " + object + ", context: " + this.context);
        }
        if (oldState == 2) {
            this.deleteNew(object);
        } else {
            this.deletePersistent(object);
        }
        return true;
    }

    private void deleteNew(Persistent object) {
        object.setPersistenceState(1);
        this.processDeleteRules(object, 2);
        this.context.getGraphManager().unregisterNode(object.getObjectId());
    }

    private void deletePersistent(Persistent object) {
        int oldState = object.getPersistenceState();
        object.setPersistenceState(6);
        this.processDeleteRules(object, oldState);
        this.context.getGraphManager().nodeRemoved(object.getObjectId());
    }

    private void processDeleteRules(final Persistent object, final int oldState) {
        String entityName = object.getObjectId().getEntityName();
        final ObjEntity entity = this.context.getEntityResolver().lookupObjEntity(entityName);
        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(entityName);
        descriptor.visitProperties(new PropertyVisitor(){

            public boolean visitCollectionArc(CollectionProperty property) {
                ObjRelationship relationship = (ObjRelationship)entity.getRelationship(property.getName());
                ObjectContextDeleteAction.this.processRules(object, property, relationship.getDeleteRule(), oldState);
                return true;
            }

            public boolean visitSingleObjectArc(SingleObjectArcProperty property) {
                ObjRelationship relationship = (ObjRelationship)entity.getRelationship(property.getName());
                ObjectContextDeleteAction.this.processRules(object, property, relationship.getDeleteRule(), oldState);
                return true;
            }

            public boolean visitProperty(Property property) {
                return true;
            }
        });
    }

    private void processRules(Persistent object, ArcProperty property, int deleteRule, int oldState) {
        if (deleteRule == 0) {
            return;
        }
        Collection relatedObjects = this.relatedObjects(object, property);
        if (relatedObjects.isEmpty()) {
            return;
        }
        switch (deleteRule) {
            case 3: {
                object.setPersistenceState(oldState);
                String message = relatedObjects.size() == 1 ? "1 related object" : relatedObjects.size() + " related objects";
                throw new DeleteDenyException(object, property.getName(), message);
            }
            case 1: {
                ArcProperty reverseArc = property.getComplimentaryReverseArc();
                if (reverseArc == null) break;
                if (reverseArc instanceof CollectionProperty) {
                    Iterator iterator = relatedObjects.iterator();
                    while (iterator.hasNext()) {
                        Object relatedObject = iterator.next();
                        ((CollectionProperty)reverseArc).removeTarget(relatedObject, object, true);
                    }
                } else {
                    Iterator iterator = relatedObjects.iterator();
                    while (iterator.hasNext()) {
                        Object relatedObject = iterator.next();
                        ((SingleObjectArcProperty)reverseArc).setTarget(relatedObject, null, true);
                    }
                }
                break;
            }
            case 2: {
                Iterator iterator = relatedObjects.iterator();
                while (iterator.hasNext()) {
                    Persistent relatedObject = (Persistent)iterator.next();
                    this.performDelete(relatedObject);
                }
                break;
            }
            default: {
                object.setPersistenceState(oldState);
                throw new CayenneRuntimeException("Invalid delete rule: " + deleteRule);
            }
        }
    }

    private Collection relatedObjects(Object object, Property property) {
        Object related = property.readProperty(object);
        if (related == null) {
            return Collections.EMPTY_LIST;
        }
        if (property instanceof CollectionProperty) {
            Collection relatedCollection = (Collection)related;
            return relatedCollection.isEmpty() ? Collections.EMPTY_LIST : new ArrayList(relatedCollection);
        }
        return Collections.singleton(related);
    }
}

