/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataDomainDBDiffBuilder;
import org.apache.cayenne.access.DataDomainFlushAction;
import org.apache.cayenne.access.DataDomainSyncBucket;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.InsertBatchQuery;

class DataDomainInsertBucket
extends DataDomainSyncBucket {
    DataDomainInsertBucket(DataDomainFlushAction parent) {
        super(parent);
    }

    void appendQueriesInternal(Collection queries) {
        DataDomainDBDiffBuilder diffBuilder = new DataDomainDBDiffBuilder();
        EntitySorter sorter = this.parent.getDomain().getEntitySorter();
        sorter.sortDbEntities(this.dbEntities, false);
        Iterator i = this.dbEntities.iterator();
        while (i.hasNext()) {
            DbEntity dbEntity = (DbEntity)i.next();
            List objEntitiesForDbEntity = (List)this.objEntitiesByDbEntity.get(dbEntity);
            InsertBatchQuery batch = new InsertBatchQuery(dbEntity, 27);
            Iterator j = objEntitiesForDbEntity.iterator();
            while (j.hasNext()) {
                ObjEntity entity = (ObjEntity)j.next();
                diffBuilder.reset(entity, dbEntity);
                boolean isMasterDbEntity = entity.getDbEntity() == dbEntity;
                List objects = (List)(isMasterDbEntity ? this.objectsByEntity.get(entity) : this.objectsByEntity.remove(entity));
                if (objects.isEmpty()) continue;
                this.checkReadOnly(entity);
                if (isMasterDbEntity) {
                    this.createPermIdsForObjEntity(entity, objects);
                    sorter.sortObjectsForEntity(entity, objects, false);
                }
                Iterator k = objects.iterator();
                while (k.hasNext()) {
                    DataObject o = (DataObject)k.next();
                    Map snapshot = diffBuilder.buildDBDiff(this.parent.objectDiff(o.getObjectId()));
                    batch.add(snapshot, o.getObjectId());
                }
            }
            queries.add(batch);
        }
    }

    void createPermIdsForObjEntity(ObjEntity objEntity, List dataObjects) {
        if (dataObjects.isEmpty()) {
            return;
        }
        DbEntity dbEntity = objEntity.getDbEntity();
        DataNode node = this.parent.getDomain().lookupDataNode(dbEntity.getDataMap());
        Collection generatedPks = this.getAutogeneratedKeys(node, dbEntity);
        if (generatedPks.isEmpty()) {
            return;
        }
        PkGenerator pkGenerator = node.getAdapter().getPkGenerator();
        Iterator i = dataObjects.iterator();
        while (i.hasNext()) {
            DataObject object = (DataObject)i.next();
            ObjectId id = object.getObjectId();
            if (id == null || !id.isTemporary()) continue;
            Map idMap = id.getReplacementIdMap();
            boolean autoPkDone = false;
            Iterator it = generatedPks.iterator();
            while (it.hasNext()) {
                DbAttribute dbAttr = (DbAttribute)it.next();
                String dbAttrName = dbAttr.getName();
                if (idMap.containsKey(dbAttrName)) continue;
                ObjAttribute objAttr = objEntity.getAttributeForDbAttribute(dbAttr);
                if (objAttr != null) {
                    idMap.put(dbAttrName, object.readPropertyDirectly(objAttr.getName()));
                    continue;
                }
                if (autoPkDone) {
                    throw new CayenneRuntimeException("Primary Key autogeneration only works for a single attribute.");
                }
                try {
                    Object pkValue = pkGenerator.generatePkForDbEntity(node, dbEntity);
                    idMap.put(dbAttrName, pkValue);
                    autoPkDone = true;
                }
                catch (Exception ex) {
                    throw new CayenneRuntimeException("Error generating PK: " + ex.getMessage(), ex);
                }
            }
        }
    }

    Collection getAutogeneratedKeys(DataNode node, DbEntity entity) {
        boolean supportsGeneratedKeys = node.getAdapter().supportsGeneratedKeys();
        Iterator it = entity.getPrimaryKey().iterator();
        ArrayList<DbAttribute> generated = new ArrayList<DbAttribute>(1);
        while (it.hasNext()) {
            DbAttribute next = (DbAttribute)it.next();
            if (supportsGeneratedKeys && next.isGenerated() || this.isPropagated(next)) continue;
            generated.add(next);
        }
        return generated;
    }

    boolean isPropagated(DbAttribute attribute) {
        Iterator it = attribute.getEntity().getRelationships().iterator();
        while (it.hasNext()) {
            DbRelationship dbRel = (DbRelationship)it.next();
            if (!dbRel.isToMasterPK()) continue;
            Iterator joins = dbRel.getJoins().iterator();
            while (joins.hasNext()) {
                DbJoin join = (DbJoin)joins.next();
                if (!attribute.getName().equals(join.getSourceName())) continue;
                return true;
            }
        }
        return false;
    }
}

