/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.DataRowUtils;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.access.PrefetchProcessorNode;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.ObjEntity;

class ObjectResolver {
    DataContext context;
    ObjEntity entity;
    List primaryKey;
    EntityInheritanceTree inheritanceTree;
    boolean refreshObjects;
    boolean resolveInheritance;
    DataRowStore cache;

    ObjectResolver(DataContext context, ObjEntity entity, boolean refresh, boolean resolveInheritanceHierarchy) {
        this.init(context, entity, refresh, resolveInheritanceHierarchy);
    }

    void init(DataContext context, ObjEntity entity, boolean refresh, boolean resolveInheritanceHierarchy) {
        DbEntity dbEntity = entity.getDbEntity();
        if (dbEntity == null) {
            throw new CayenneRuntimeException("ObjEntity '" + entity.getName() + "' has no DbEntity.");
        }
        this.primaryKey = dbEntity.getPrimaryKey();
        if (this.primaryKey.size() == 0) {
            throw new CayenneRuntimeException("Won't be able to create ObjectId for '" + entity.getName() + "'. Reason: DbEntity '" + dbEntity.getName() + "' has no Primary Key defined.");
        }
        this.context = context;
        this.cache = context.getObjectStore().getDataRowCache();
        this.refreshObjects = refresh;
        this.entity = entity;
        this.inheritanceTree = context.getEntityResolver().lookupInheritanceTree(entity);
        this.resolveInheritance = this.inheritanceTree != null ? resolveInheritanceHierarchy : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List synchronizedObjectsFromDataRows(List rows) {
        ObjectStore objectStore = this.context.getObjectStore();
        synchronized (objectStore) {
            return this.objectsFromDataRows(rows);
        }
    }

    List objectsFromDataRows(List rows) {
        if (rows == null || rows.size() == 0) {
            return new ArrayList(1);
        }
        ArrayList<DataObject> results = new ArrayList<DataObject>(rows.size());
        Iterator it = rows.iterator();
        while (it.hasNext()) {
            results.add(this.objectFromDataRow((DataRow)it.next()));
        }
        this.cache.snapshotsUpdatedForObjects(results, rows, this.refreshObjects);
        return results;
    }

    List relatedObjectsFromDataRows(List rows, PrefetchProcessorNode node) {
        if (rows == null || rows.size() == 0) {
            return new ArrayList(1);
        }
        ObjEntity sourceObjEntity = (ObjEntity)node.getIncoming().getSourceEntity();
        String relatedIdPrefix = node.getIncoming().getReverseDbRelationshipPath() + ".";
        ArrayList<DataObject> results = new ArrayList<DataObject>(rows.size());
        Iterator it = rows.iterator();
        while (it.hasNext()) {
            DataRow row = (DataRow)it.next();
            DataObject object = this.objectFromDataRow(row);
            results.add(object);
            ObjectId id = this.createObjectId(row, sourceObjEntity, relatedIdPrefix);
            DataObject parentObject = (DataObject)this.context.getObjectStore().getNode(id);
            if (parentObject == null || parentObject.getPersistenceState() == 5) continue;
            node.linkToParent(object, parentObject);
        }
        this.cache.snapshotsUpdatedForObjects(results, rows, this.refreshObjects);
        return results;
    }

    DataObject objectFromDataRow(DataRow row) {
        ObjEntity objectEntity;
        if (this.resolveInheritance) {
            objectEntity = this.inheritanceTree.entityMatchingRow(row);
            if (objectEntity == null) {
                objectEntity = this.entity;
            }
        } else {
            objectEntity = this.entity;
        }
        ObjectId anId = this.createObjectId(row, objectEntity, null);
        DataObject object = (DataObject)this.context.localObject(anId, null);
        int state = object.getPersistenceState();
        switch (state) {
            case 3: 
            case 4: 
            case 6: {
                if (!this.refreshObjects) break;
                DataRowUtils.mergeObjectWithSnapshot(objectEntity, object, row);
                object.setSnapshotVersion(row.getVersion());
                break;
            }
            case 5: {
                DataRow cachedRow;
                if (!this.refreshObjects && (cachedRow = this.cache.getCachedSnapshot(anId)) != null) {
                    row = cachedRow;
                }
                DataRowUtils.mergeObjectWithSnapshot(objectEntity, object, row);
                object.setSnapshotVersion(row.getVersion());
                break;
            }
        }
        object.fetchFinished();
        return object;
    }

    ObjEntity getEntity() {
        return this.entity;
    }

    ObjectId createObjectId(DataRow dataRow, ObjEntity objEntity, String namePrefix) {
        boolean prefix;
        List pk = objEntity == this.entity ? this.primaryKey : objEntity.getDbEntity().getPrimaryKey();
        boolean bl = prefix = namePrefix != null && namePrefix.length() > 0;
        if (pk.size() == 1) {
            DbAttribute attribute = (DbAttribute)pk.get(0);
            String key = prefix ? namePrefix + attribute.getName() : attribute.getName();
            Object val = dataRow.get(key);
            if (val == null) {
                throw new CayenneRuntimeException("Null value for '" + key + "'. Snapshot: " + dataRow + ". Prefix: " + namePrefix);
            }
            return new ObjectId(objEntity.getName(), attribute.getName(), val);
        }
        HashMap idMap = new HashMap(pk.size() * 2);
        Iterator it = pk.iterator();
        while (it.hasNext()) {
            DbAttribute attribute = (DbAttribute)it.next();
            String key = prefix ? namePrefix + attribute.getName() : attribute.getName();
            Object val = dataRow.get(key);
            if (val == null) {
                throw new CayenneRuntimeException("Null value for '" + key + "'. Snapshot: " + dataRow + ". Prefix: " + namePrefix);
            }
            idMap.put(attribute.getName(), val);
        }
        return new ObjectId(objEntity.getName(), idMap);
    }
}

