/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.QueryTranslator;
import org.apache.cayenne.access.jdbc.BaseSQLAction;
import org.apache.cayenne.access.trans.DeleteTranslator;
import org.apache.cayenne.access.trans.InsertTranslator;
import org.apache.cayenne.access.trans.UpdateTranslator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.DeleteQuery;
import org.apache.cayenne.query.InsertQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.UpdateQuery;

public class UpdateAction
extends BaseSQLAction {
    protected Query query;

    public UpdateAction(Query query, DbAdapter adapter, EntityResolver entityResolver) {
        super(adapter, entityResolver);
        this.query = query;
    }

    protected QueryTranslator createTranslator(Connection connection) {
        QueryTranslator translator = this.checkDeprecatedQueries(this.query);
        if (translator == null) {
            if (this.query instanceof UpdateQuery) {
                translator = new UpdateTranslator();
            } else if (this.query instanceof DeleteQuery) {
                translator = new DeleteTranslator();
            } else {
                throw new CayenneRuntimeException("Can't make a translator for query " + this.query);
            }
        }
        translator.setAdapter(this.getAdapter());
        translator.setQuery(this.query);
        translator.setEntityResolver(this.getEntityResolver());
        translator.setConnection(connection);
        return translator;
    }

    final QueryTranslator checkDeprecatedQueries(Query query) {
        if (query instanceof InsertQuery) {
            return new InsertTranslator();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        QueryTranslator translator = this.createTranslator(connection);
        PreparedStatement statement = translator.createStatement();
        try {
            int count = statement.executeUpdate();
            QueryLogger.logUpdateCount(count);
            observer.nextCount(this.query, count);
        }
        finally {
            statement.close();
        }
    }
}

