/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.access.trans.BatchQueryBuilder;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.UpdateBatchQuery;

public class UpdateBatchQueryBuilder
extends BatchQueryBuilder {
    public UpdateBatchQueryBuilder(DbAdapter adapter) {
        super(adapter);
    }

    public String createSqlString(BatchQuery batch) {
        DbAttribute attribute;
        UpdateBatchQuery updateBatch = (UpdateBatchQuery)batch;
        String table = batch.getDbEntity().getFullyQualifiedName();
        List qualifierAttributes = updateBatch.getQualifierAttributes();
        List updatedDbAttributes = updateBatch.getUpdatedAttributes();
        StringBuffer query = new StringBuffer("UPDATE ");
        query.append(table).append(" SET ");
        int len = updatedDbAttributes.size();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                query.append(", ");
            }
            attribute = (DbAttribute)updatedDbAttributes.get(i);
            query.append(attribute.getName()).append(" = ?");
        }
        query.append(" WHERE ");
        Iterator i = qualifierAttributes.iterator();
        while (i.hasNext()) {
            attribute = (DbAttribute)i.next();
            this.appendDbAttribute(query, attribute);
            query.append(updateBatch.isNull(attribute) ? " IS NULL" : " = ?");
            if (!i.hasNext()) continue;
            query.append(" AND ");
        }
        return query.toString();
    }

    public void bindParameters(PreparedStatement statement, BatchQuery query) throws SQLException, Exception {
        DbAttribute attribute;
        Object value;
        int i;
        UpdateBatchQuery updateBatch = (UpdateBatchQuery)query;
        List qualifierAttributes = updateBatch.getQualifierAttributes();
        List updatedDbAttributes = updateBatch.getUpdatedAttributes();
        int len = updatedDbAttributes.size();
        int parameterIndex = 1;
        for (i = 0; i < len; ++i) {
            value = query.getValue(i);
            attribute = (DbAttribute)updatedDbAttributes.get(i);
            this.adapter.bindParameter(statement, value, parameterIndex++, attribute.getType(), attribute.getPrecision());
        }
        for (i = 0; i < qualifierAttributes.size(); ++i) {
            value = query.getValue(len + i);
            attribute = (DbAttribute)qualifierAttributes.get(i);
            if (updateBatch.isNull(attribute)) continue;
            this.adapter.bindParameter(statement, value, parameterIndex++, attribute.getType(), attribute.getPrecision());
        }
    }
}

