/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.util;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;

public class ResultDescriptor {
    protected String[] names;
    protected int[] jdbcTypes;
    protected ExtendedType[] converters;
    protected int[] idIndexes;
    protected int[] outParamIndexes;
    protected List dbAttributes = new ArrayList();
    protected List javaTypes = new ArrayList();
    protected ExtendedTypeMap typesMapping;
    protected ObjEntity rootEntity;
    protected boolean indexedIds;

    public static ResultDescriptor createDescriptor(ResultSet resultSet, ExtendedTypeMap typeConverters) {
        ResultDescriptor descriptor = new ResultDescriptor(typeConverters);
        try {
            ResultSetMetaData md = resultSet.getMetaData();
            int len = md.getColumnCount();
            if (len == 0) {
                throw new CayenneRuntimeException("No columns in ResultSet.");
            }
            for (int i = 0; i < len; ++i) {
                int pos = i + 1;
                String name = md.getColumnLabel(pos);
                int sqlType = md.getColumnType(pos);
                int precision = md.getScale(pos);
                int length = md.getColumnDisplaySize(pos);
                if (!(name != null && name.length() != 0 || (name = md.getColumnName(i + 1)) != null && name.length() != 0)) {
                    name = "column_" + (i + 1);
                }
                DbAttribute desc = new DbAttribute();
                desc.setName(name);
                desc.setType(md.getColumnType(i + 1));
                descriptor.addDbAttribute(desc);
                descriptor.addJavaType(TypesMapping.getJavaBySqlType(sqlType, length, precision));
            }
        }
        catch (SQLException sqex) {
            throw new CayenneRuntimeException("Error reading metadata.", sqex);
        }
        descriptor.index();
        return descriptor;
    }

    public static ResultDescriptor createDescriptor(ColumnDescriptor[] columns, ExtendedTypeMap typeConverters) {
        ResultDescriptor descriptor = new ResultDescriptor(typeConverters);
        int len = columns.length;
        descriptor.names = new String[len];
        descriptor.jdbcTypes = new int[len];
        descriptor.converters = new ExtendedType[len];
        int idWidth = 0;
        for (int i = 0; i < len; ++i) {
            descriptor.names[i] = columns[i].getName();
            descriptor.jdbcTypes[i] = columns[i].getJdbcType();
            descriptor.converters[i] = typeConverters.getRegisteredType(columns[i].getJavaClass());
            if (!columns[i].isPrimaryKey()) continue;
            ++idWidth;
        }
        return descriptor;
    }

    public static ResultDescriptor createDescriptor(Procedure procedure, ExtendedTypeMap typeConverters) {
        ResultDescriptor descriptor = new ResultDescriptor(typeConverters);
        Iterator it = procedure.getCallParameters().iterator();
        while (it.hasNext()) {
            descriptor.addDbAttribute(new ProcedureParameterWrapper((ProcedureParameter)it.next()));
        }
        descriptor.index();
        return descriptor;
    }

    public ResultDescriptor(ExtendedTypeMap typesMapping) {
        this(typesMapping, null);
    }

    public ResultDescriptor(ExtendedTypeMap typesMapping, ObjEntity rootEntity) {
        this.typesMapping = typesMapping;
        this.rootEntity = rootEntity;
    }

    public void addColumns(Collection dbAttributes) {
        this.dbAttributes.addAll(dbAttributes);
    }

    public void addDbAttribute(DbAttribute attr) {
        this.dbAttributes.add(attr);
    }

    public void addJavaTypes(Collection javaTypes) {
        this.javaTypes.addAll(javaTypes);
    }

    public void addJavaType(String javaType) {
        this.javaTypes.add(javaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indexIds(DbEntity entity) {
        if (!this.indexedIds) {
            ResultDescriptor resultDescriptor = this;
            synchronized (resultDescriptor) {
                if (!this.indexedIds) {
                    this.idIndexes = new int[0];
                    if (entity == null) {
                        return;
                    }
                    this.indexedIds = true;
                    int resultWidth = this.names.length;
                    int[] tmp = new int[resultWidth];
                    int j = 0;
                    for (int i = 0; i < resultWidth; ++i) {
                        DbAttribute attribute = (DbAttribute)entity.getAttribute(this.names[i]);
                        if (attribute == null || !attribute.isPrimaryKey()) continue;
                        tmp[j++] = i;
                    }
                    if (j > 0) {
                        this.idIndexes = new int[j];
                        System.arraycopy(tmp, 0, this.idIndexes, 0, j);
                    }
                }
            }
        }
    }

    public void index() {
        int i;
        if (this.javaTypes.size() > 0 && this.javaTypes.size() != this.dbAttributes.size()) {
            throw new IllegalArgumentException("DbAttributes and Java type arrays must have the same size.");
        }
        int resultWidth = this.dbAttributes.size();
        int outWidth = 0;
        this.names = new String[resultWidth];
        this.jdbcTypes = new int[resultWidth];
        for (i = 0; i < resultWidth; ++i) {
            ObjAttribute objAttr;
            DbAttribute attr = (DbAttribute)this.dbAttributes.get(i);
            this.jdbcTypes[i] = attr.getType();
            if (attr instanceof ProcedureParameterWrapper && ((ProcedureParameterWrapper)attr).getParameter().isOutParam()) {
                ++outWidth;
            }
            String name = null;
            if (this.rootEntity != null && (objAttr = this.rootEntity.getAttributeForDbAttribute(attr)) != null) {
                name = objAttr.getDbAttributePath();
            }
            if (name == null) {
                name = attr.getName();
            }
            this.names[i] = name;
        }
        if (outWidth == 0) {
            this.outParamIndexes = new int[0];
        } else {
            this.outParamIndexes = new int[outWidth];
            int j = 0;
            for (i = 0; i < resultWidth; ++i) {
                DbAttribute attr = (DbAttribute)this.dbAttributes.get(i);
                this.jdbcTypes[i] = attr.getType();
                if (!(attr instanceof ProcedureParameterWrapper) || !((ProcedureParameterWrapper)attr).getParameter().isOutParam()) continue;
                this.outParamIndexes[j++] = i;
            }
        }
        if (this.javaTypes.size() > 0) {
            this.initConvertersFromJavaTypes();
        } else if (this.rootEntity != null) {
            this.initConvertersFromMapping();
        } else {
            this.initDefaultConverters();
        }
    }

    protected void initConvertersFromJavaTypes() {
        int resultWidth = this.dbAttributes.size();
        this.converters = new ExtendedType[resultWidth];
        for (int i = 0; i < resultWidth; ++i) {
            this.converters[i] = this.typesMapping.getRegisteredType((String)this.javaTypes.get(i));
        }
    }

    protected void initDefaultConverters() {
        int resultWidth = this.dbAttributes.size();
        this.converters = new ExtendedType[resultWidth];
        for (int i = 0; i < resultWidth; ++i) {
            String javaType = TypesMapping.getJavaBySqlType(this.jdbcTypes[i]);
            this.converters[i] = this.typesMapping.getRegisteredType(javaType);
        }
    }

    protected void initConvertersFromMapping() {
        if (this.dbAttributes.size() == 0) {
            throw new IllegalArgumentException("DbAttributes list is empty.");
        }
        if (this.rootEntity == null) {
            throw new IllegalArgumentException("Root ObjEntity is null.");
        }
        int resultWidth = this.dbAttributes.size();
        this.converters = new ExtendedType[resultWidth];
        for (int i = 0; i < resultWidth; ++i) {
            String javaType = null;
            DbAttribute attr = (DbAttribute)this.dbAttributes.get(i);
            ObjAttribute objAttr = this.rootEntity.getAttributeForDbAttribute(attr);
            javaType = objAttr != null ? objAttr.getType() : TypesMapping.getJavaBySqlType(attr.getType());
            this.converters[i] = this.typesMapping.getRegisteredType(javaType);
        }
    }

    public ExtendedType[] getConverters() {
        return this.converters;
    }

    public int[] getIdIndexes(DbEntity entity) {
        this.indexIds(entity);
        return this.idIndexes;
    }

    public int[] getJdbcTypes() {
        return this.jdbcTypes;
    }

    public String[] getNames() {
        return this.names;
    }

    public int getResultWidth() {
        return this.dbAttributes.size();
    }

    public int[] getOutParamIndexes() {
        return this.outParamIndexes;
    }

    static class ProcedureParameterWrapper
    extends DbAttribute {
        ProcedureParameter parameter;

        ProcedureParameterWrapper(ProcedureParameter parameter) {
            this.parameter = parameter;
        }

        public int getMaxLength() {
            return this.parameter.getMaxLength();
        }

        public int getPrecision() {
            return this.parameter.getPrecision();
        }

        public int getType() {
            return this.parameter.getType();
        }

        public String getName() {
            return this.parameter.getName();
        }

        public Object getParent() {
            return this.parameter.getProcedure();
        }

        public ProcedureParameter getParameter() {
            return this.parameter;
        }
    }
}

