/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conn;

import java.io.Serializable;
import org.apache.cayenne.util.Util;

public class DataSourceInfo
implements Cloneable,
Serializable {
    protected String userName;
    protected String password;
    protected String jdbcDriver;
    protected String dataSourceUrl;
    protected String adapterClassName;
    protected int minConnections = 1;
    protected int maxConnections = 1;

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DataSourceInfo dsi = (DataSourceInfo)obj;
        if (!Util.nullSafeEquals(this.userName, dsi.userName)) {
            return false;
        }
        if (!Util.nullSafeEquals(this.password, dsi.password)) {
            return false;
        }
        if (!Util.nullSafeEquals(this.jdbcDriver, dsi.jdbcDriver)) {
            return false;
        }
        if (!Util.nullSafeEquals(this.dataSourceUrl, dsi.dataSourceUrl)) {
            return false;
        }
        if (!Util.nullSafeEquals(this.adapterClassName, dsi.adapterClassName)) {
            return false;
        }
        if (this.minConnections != dsi.minConnections) {
            return false;
        }
        return this.maxConnections == dsi.maxConnections;
    }

    public DataSourceInfo cloneInfo() {
        try {
            return (DataSourceInfo)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Cloning error", ex);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[").append(this.getClass().getName()).append(":").append("\n   user name: ").append(this.userName).append("\n   password: ");
        if (this.password == null) {
            buf.append("null");
        } else {
            buf.append("**********");
        }
        buf.append("\n   driver: ").append(this.jdbcDriver).append("\n   db adapter class: ").append(this.adapterClassName).append("\n   url: ").append(this.dataSourceUrl).append("\n   min. connections: ").append(this.minConnections).append("\n   max. connections: ").append(this.maxConnections).append("\n]");
        return buf.toString();
    }

    public String getAdapterClassName() {
        return this.adapterClassName;
    }

    public void setAdapterClassName(String adapterClassName) {
        this.adapterClassName = adapterClassName;
    }

    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
    }

    public int getMinConnections() {
        return this.minConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setDataSourceUrl(String dataSourceUrl) {
        this.dataSourceUrl = dataSourceUrl;
    }

    public String getDataSourceUrl() {
        return this.dataSourceUrl;
    }
}

