/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.ResultIterator;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.PkRange;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbKeyGenerator;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.util.IDUtil;
import org.apache.log4j.Level;

public class JdbcPkGenerator
implements PkGenerator {
    public static final int DEFAULT_PK_CACHE_SIZE = 20;
    protected static final String NEXT_ID = "NEXT_ID";
    protected static final ObjAttribute[] objDesc = new ObjAttribute[]{new ObjAttribute("nextId", Integer.class.getName(), null)};
    protected static final DbAttribute[] resultDesc = new DbAttribute[]{new DbAttribute("NEXT_ID", 4, null)};
    protected Map pkCache = new HashMap();
    protected int pkCacheSize = 20;

    public void createAutoPk(DataNode node, List dbEntities) throws Exception {
        if (!this.autoPkTableExists(node)) {
            this.runUpdate(node, this.pkTableCreateString());
        }
        this.runUpdate(node, this.pkDeleteString(dbEntities));
        Iterator it = dbEntities.iterator();
        while (it.hasNext()) {
            DbEntity ent = (DbEntity)it.next();
            this.runUpdate(node, this.pkCreateString(ent.getName()));
        }
    }

    public List createAutoPkStatements(List dbEntities) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.pkTableCreateString());
        list.add(this.pkDeleteString(dbEntities));
        Iterator it = dbEntities.iterator();
        while (it.hasNext()) {
            DbEntity ent = (DbEntity)it.next();
            list.add(this.pkCreateString(ent.getName()));
        }
        return list;
    }

    public void dropAutoPk(DataNode node, List dbEntities) throws Exception {
        if (this.autoPkTableExists(node)) {
            this.runUpdate(node, this.dropAutoPkString());
        }
    }

    public List dropAutoPkStatements(List dbEntities) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.dropAutoPkString());
        return list;
    }

    protected String pkTableCreateString() {
        StringBuffer buf = new StringBuffer();
        buf.append("CREATE TABLE AUTO_PK_SUPPORT (").append("  TABLE_NAME CHAR(100) NOT NULL,").append("  NEXT_ID INTEGER NOT NULL,").append("  PRIMARY KEY(TABLE_NAME)").append(")");
        return buf.toString();
    }

    protected String pkDeleteString(List dbEntities) {
        StringBuffer buf = new StringBuffer();
        buf.append("DELETE FROM AUTO_PK_SUPPORT WHERE TABLE_NAME IN (");
        int len = dbEntities.size();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            DbEntity ent = (DbEntity)dbEntities.get(i);
            buf.append('\'').append(ent.getName()).append('\'');
        }
        buf.append(')');
        return buf.toString();
    }

    protected String pkCreateString(String entName) {
        StringBuffer buf = new StringBuffer();
        buf.append("INSERT INTO AUTO_PK_SUPPORT").append(" (TABLE_NAME, NEXT_ID)").append(" VALUES ('").append(entName).append("', 200)");
        return buf.toString();
    }

    protected String pkSelectString(String entName) {
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT NEXT_ID FROM AUTO_PK_SUPPORT WHERE TABLE_NAME = '").append(entName).append('\'');
        return buf.toString();
    }

    protected String pkUpdateString(String entName) {
        StringBuffer buf = new StringBuffer();
        buf.append("UPDATE AUTO_PK_SUPPORT").append(" SET NEXT_ID = NEXT_ID + ").append(this.pkCacheSize).append(" WHERE TABLE_NAME = '").append(entName).append('\'');
        return buf.toString();
    }

    protected String dropAutoPkString() {
        return "DROP TABLE AUTO_PK_SUPPORT";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean autoPkTableExists(DataNode node) throws SQLException {
        Connection con = node.getDataSource().getConnection();
        boolean exists = false;
        try {
            DatabaseMetaData md = con.getMetaData();
            ResultSet tables = md.getTables(null, null, "AUTO_PK_SUPPORT", null);
            try {
                exists = tables.next();
            }
            finally {
                tables.close();
            }
        }
        finally {
            con.close();
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runUpdate(DataNode node, String sql) throws SQLException {
        QueryLogger.logQuery(sql, Collections.EMPTY_LIST);
        Connection con = node.getDataSource().getConnection();
        try {
            int n;
            Statement upd = con.createStatement();
            try {
                n = upd.executeUpdate(sql);
            }
            catch (Throwable throwable) {
                upd.close();
                throw throwable;
            }
            upd.close();
            return n;
        }
        finally {
            con.close();
        }
    }

    public String generatePkForDbEntityString(DbEntity ent) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.pkSelectString(ent.getName())).append('\n').append(this.pkUpdateString(ent.getName()));
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object generatePkForDbEntity(DataNode node, DbEntity ent) throws Exception {
        byte[] binPK = this.binaryPK(ent);
        if (binPK != null) {
            return binPK;
        }
        DbKeyGenerator pkGenerator = ent.getPrimaryKeyGenerator();
        int cacheSize = pkGenerator != null && pkGenerator.getKeyCacheSize() != null ? pkGenerator.getKeyCacheSize() : this.pkCacheSize;
        if (cacheSize <= 1) {
            return new Integer(this.pkFromDatabase(node, ent));
        }
        Map map = this.pkCache;
        synchronized (map) {
            PkRange r = (PkRange)this.pkCache.get(ent.getName());
            if (r == null) {
                r = new PkRange(1, 0);
                this.pkCache.put(ent.getName(), r);
            }
            if (r.isExhausted()) {
                int val = this.pkFromDatabase(node, ent);
                r.reset(val, val + cacheSize - 1);
            }
            return r.getNextPrimaryKey();
        }
    }

    protected byte[] binaryPK(DbEntity entity) {
        DbAttribute pk;
        List pkColumns = entity.getPrimaryKey();
        if (pkColumns.size() == 1 && (pk = (DbAttribute)pkColumns.get(0)).getMaxLength() > 0 && (pk.getType() == -2 || pk.getType() == -3)) {
            return IDUtil.pseudoUniqueSecureByteSequence(pk.getMaxLength());
        }
        return null;
    }

    protected int pkFromDatabase(DataNode node, DbEntity ent) throws Exception {
        String select = "SELECT #result('NEXT_ID' 'int' 'NEXT_ID') FROM AUTO_PK_SUPPORT WHERE TABLE_NAME = '" + ent.getName() + '\'';
        ArrayList<SQLTemplate> queries = new ArrayList<SQLTemplate>(2);
        queries.add(new SQLTemplate(ent, select));
        queries.add(new SQLTemplate(ent, this.pkUpdateString(ent.getName())));
        PkRetrieveProcessor observer = new PkRetrieveProcessor(ent.getName());
        node.performQueries(queries, observer);
        return observer.getId();
    }

    public int getPkCacheSize() {
        return this.pkCacheSize;
    }

    public void setPkCacheSize(int pkCacheSize) {
        this.pkCacheSize = pkCacheSize < 1 ? 1 : pkCacheSize;
    }

    public void reset() {
        this.pkCache.clear();
    }

    static {
        objDesc[0].setDbAttributePath(NEXT_ID);
    }

    final class PkRetrieveProcessor
    implements OperationObserver {
        Number id;
        String entityName;

        PkRetrieveProcessor(String entityName) {
            this.entityName = entityName;
        }

        public Level getLoggingLevel() {
            return null;
        }

        public boolean isIteratedResult() {
            return false;
        }

        public int getId() {
            if (this.id == null) {
                throw new CayenneRuntimeException("No key was retrieved for entity " + this.entityName);
            }
            return this.id.intValue();
        }

        public void nextDataRows(Query query, List dataRows) {
            if (dataRows == null || dataRows.size() == 0) {
                throw new CayenneRuntimeException("Error generating PK : entity not supported: " + this.entityName);
            }
            if (dataRows.size() > 1) {
                throw new CayenneRuntimeException("Error generating PK : too many rows for entity: " + this.entityName);
            }
            Map lastPk = (Map)dataRows.get(0);
            this.id = (Number)lastPk.get(JdbcPkGenerator.NEXT_ID);
        }

        public void nextCount(Query query, int resultCount) {
            if (resultCount != 1) {
                throw new CayenneRuntimeException("Error generating PK for entity '" + this.entityName + "': update count is wrong - " + resultCount);
            }
        }

        public void nextBatchCount(Query query, int[] resultCount) {
        }

        public void nextGeneratedDataRows(Query query, ResultIterator keysIterator) {
        }

        public void nextDataRows(Query q, ResultIterator it) {
        }

        public void nextQueryException(Query query, Exception ex) {
            throw new CayenneRuntimeException("Error generating PK for entity '" + this.entityName + "'.", ex);
        }

        public void nextGlobalException(Exception ex) {
            throw new CayenneRuntimeException("Error generating PK for entity: " + this.entityName, ex);
        }
    }
}

