/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.io.PrintWriter;
import org.apache.cayenne.exp.ASTCompiler;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;

public class UnaryExpression
extends Expression {
    protected Object operand;

    public UnaryExpression() {
    }

    public UnaryExpression(int type) {
        this.type = type;
    }

    public Expression notExp() {
        Expression exp = ExpressionFactory.expressionOfType(2);
        exp.setOperand(0, this);
        return exp;
    }

    public Object evaluate(Object o) {
        return ASTCompiler.compile(this).evaluateASTChain(o);
    }

    protected void flattenTree() {
    }

    protected boolean pruneNodeForPrunedChild(Object prunedChild) {
        return true;
    }

    public Expression shallowCopy() {
        return new UnaryExpression(this.type);
    }

    public final int getOperandCount() {
        return 1;
    }

    public Object getOperand(int index) {
        if (index == 0) {
            return this.operand;
        }
        throw new IllegalArgumentException("Invalid operand index for UnaryExpression: " + index);
    }

    public void setOperand(int index, Object value) {
        if (index == 0) {
            this.operand = value;
            return;
        }
        throw new IllegalArgumentException("Invalid operand index for UnaryExpression: " + index);
    }

    public void encodeAsString(PrintWriter pw) {
        for (int i = 0; i < this.getOperandCount(); ++i) {
            Object op;
            if (i > 0 || this.getOperandCount() == 1) {
                pw.print(" ");
                pw.print(this.expName());
                pw.print(" ");
            }
            if ((op = this.getOperand(i)) == null) {
                pw.print("<null>");
                continue;
            }
            if (op instanceof String) {
                pw.print("'" + op + "'");
                continue;
            }
            if (op instanceof Expression) {
                pw.print('(');
                ((Expression)op).encodeAsString(pw);
                pw.print(')');
                continue;
            }
            pw.print(String.valueOf(op));
        }
    }
}

