/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.layout;

import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.UnboundedFifoBuffer;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.Digraph;
import org.objectstyle.ashwood.graph.MapDigraph;
import org.objectstyle.ashwood.graph.layout.ArcStraightener;
import org.objectstyle.ashwood.graph.layout.Layer;
import org.objectstyle.ashwood.graph.layout.LayerVertex;
import org.objectstyle.ashwood.graph.layout.NestedSubgraph;
import org.objectstyle.ashwood.graph.layout.RankFunction;
import org.objectstyle.ashwood.graph.layout.SubgraphPartition;
import org.objectstyle.ashwood.util.Attribute;
import org.objectstyle.ashwood.util.IntPartition;

public class DefaultLayerPartition {
    private Layer[] layers;
    private RankFunction rankFunction;
    private IntPartition[] layerPartitions;
    private double horizontalSpacing = 1.0;
    private double verticalSpacing = 1.0;
    private int verticalAlignment = 0;
    private boolean alternatePendulumTraversals = false;
    private double rubberForceThreshold = 1.0;
    private Digraph longArcDigraph;
    private SubgraphPartition subgraphPartition;
    private boolean dummyFixed;

    public DefaultLayerPartition(Digraph digraph, RankFunction rankFunction, Attribute attribute, Set[] setArray) {
        this.createLayers(digraph, rankFunction, attribute, setArray);
    }

    public Layer getLayer(int n) {
        return this.layers[n];
    }

    public Object getUserVertex(int n, int n2) {
        return this.layers[n].getUserVertex(n2);
    }

    public void sort(int n, Comparator comparator) {
        this.layers[n].sort(comparator);
    }

    public void sort(int n) {
        this.sort(n, ComparatorUtils.NATURAL_COMPARATOR);
    }

    public void sortDownByMedian() {
        if (this.subgraphPartition != null) {
            this.subgraphPartition.groupVertices(this.layers[0]);
        }
        int n = 1;
        while (n < this.layers.length) {
            Layer layer = this.layers[n];
            int n2 = 0;
            while (n2 < layer.size()) {
                LayerVertex layerVertex = layer.getVertex(n2);
                layerVertex.predecessorMedianValue();
                ++n2;
            }
            this.sort(n);
            if (this.subgraphPartition != null) {
                this.subgraphPartition.groupVertices(layer);
            }
            ++n;
        }
        if (this.subgraphPartition != null) {
            this.subgraphPartition.untwineSubgraphs(this.layers);
        }
    }

    public void sortUpByMedian() {
        if (this.subgraphPartition != null) {
            this.subgraphPartition.groupVertices(this.layers[this.layers.length - 1]);
        }
        int n = this.layers.length - 2;
        while (n >= 0) {
            Layer layer = this.layers[n];
            int n2 = 0;
            while (n2 < layer.size()) {
                LayerVertex layerVertex = (LayerVertex)layer.get(n2);
                layerVertex.successorMedianValue();
                ++n2;
            }
            this.sort(n);
            if (this.subgraphPartition != null) {
                this.subgraphPartition.groupVertices(layer);
            }
            --n;
        }
        if (this.subgraphPartition != null) {
            this.subgraphPartition.untwineSubgraphs(this.layers);
        }
    }

    public void breadthFirstSort() {
        UnboundedFifoBuffer unboundedFifoBuffer = new UnboundedFifoBuffer();
        HashSet hashSet = new HashSet();
        unboundedFifoBuffer.addAll(this.layers[0]);
        hashSet.addAll(this.layers[0]);
        int[] nArray = new int[this.layers.length];
        while (!unboundedFifoBuffer.isEmpty()) {
            LayerVertex layerVertex = (LayerVertex)unboundedFifoBuffer.remove();
            int n = layerVertex.getRank();
            int n2 = nArray[n];
            nArray[n] = n2 + 1;
            layerVertex.setIndexInLayer(n2);
            int n3 = 0;
            while (n3 < layerVertex.outDegree()) {
                Object e = layerVertex.getSuccessors().get(n3);
                if (hashSet.add(e)) {
                    unboundedFifoBuffer.add(e);
                }
                ++n3;
            }
        }
        int n = 0;
        while (n < this.layers.length) {
            this.layers[n].sort();
            ++n;
        }
    }

    public int countCrossings(int n) {
        if (n == this.layers.length - 1) {
            return 0;
        }
        Layer layer = this.layers[n];
        int n2 = 0;
        int n3 = layer.size();
        int n4 = 0;
        while (n4 < n3 - 1) {
            LayerVertex layerVertex = layer.getVertex(n4);
            int[] nArray = layerVertex.getSuccessorIndices();
            int n5 = n4 + 1;
            while (n5 < n3) {
                LayerVertex layerVertex2 = layer.getVertex(n5);
                n2 += layerVertex2.countLeftCrossings(nArray);
                ++n5;
            }
            ++n4;
        }
        return n2;
    }

    public int countCrossings() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.layers.length - 1) {
            n += this.countCrossings(n2);
            ++n2;
        }
        return n;
    }

    public int getMaxRank() {
        return this.layers.length - 1;
    }

    public int getRankCount() {
        return this.layers.length;
    }

    private void createLayers(Digraph digraph, RankFunction rankFunction, Attribute attribute, Set[] setArray) {
        int n;
        Object object;
        Object object2;
        Object object3;
        int n2;
        Object object4;
        this.layers = new Layer[rankFunction.maxRank() + 1];
        int n3 = 0;
        while (n3 < this.layers.length) {
            this.layers[n3] = new Layer();
            this.layers[n3].setRank(n3);
            ++n3;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(digraph.order());
        this.longArcDigraph = new MapDigraph();
        Iterator iterator = digraph.vertexIterator();
        while (iterator.hasNext()) {
            object4 = iterator.next();
            n2 = rankFunction.intValue(object4);
            object3 = (LayerVertex)hashMap.get(object4);
            if (object3 == null) {
                object3 = new LayerVertex(object4, digraph.incomingSize(object4), digraph.outgoingSize(object4));
                if (attribute != null) {
                    ((LayerVertex)object3).setGeometry(attribute);
                }
                hashMap.put(object4, object3);
                this.layers[n2].add((LayerVertex)object3);
            }
            object2 = digraph.outgoingIterator(object4);
            while (object2.hasNext()) {
                object2.next();
                object = object2.getDestination();
                n = rankFunction.intValue(object);
                int n4 = n - n2;
                LayerVertex layerVertex = (LayerVertex)hashMap.get(object);
                if (layerVertex == null) {
                    layerVertex = new LayerVertex(object, digraph.incomingSize(object), digraph.outgoingSize(object));
                    if (attribute != null) {
                        layerVertex.setGeometry(attribute);
                    }
                    hashMap.put(object, layerVertex);
                    this.layers[n].add(layerVertex);
                }
                Object object5 = object3;
                int n5 = 1;
                while (n5 < n4) {
                    LayerVertex layerVertex2 = new LayerVertex(null, 1, 1);
                    if (n5 == 1) {
                        this.longArcDigraph.putArc(object3, layerVertex, layerVertex2);
                    }
                    ((LayerVertex)object5).getSuccessors().add(layerVertex2);
                    layerVertex2.getPredecessors().add(object5);
                    this.layers[n2 + n5].add(layerVertex2);
                    object5 = layerVertex2;
                    ++n5;
                }
                ((LayerVertex)object5).getSuccessors().add(layerVertex);
                layerVertex.getPredecessors().add(object5);
            }
        }
        if (setArray != null && setArray.length > 0) {
            object4 = new NestedSubgraph();
            ((NestedSubgraph)object4).setLabel("r");
            this.subgraphPartition = new SubgraphPartition();
            n2 = 0;
            while (n2 < setArray.length) {
                object3 = setArray[n2];
                object2 = new NestedSubgraph(object3.size());
                ((NestedSubgraph)object2).setLabel(String.valueOf(n2));
                object = object3.iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    LayerVertex layerVertex = (LayerVertex)hashMap.get(e);
                    ((NestedSubgraph)object2).add(layerVertex);
                }
                ((NestedSubgraph)object4).add((NestedSubgraph)object2);
                ++n2;
            }
            object3 = this.longArcDigraph.arcIterator();
            while (object3.hasNext()) {
                object2 = (LayerVertex)object3.next();
                object = (LayerVertex)object3.getOrigin();
                LayerVertex layerVertex = (LayerVertex)object3.getDestination();
                NestedSubgraph nestedSubgraph = ((LayerVertex)object).getParentSubgraph();
                if (nestedSubgraph == null || nestedSubgraph != layerVertex.getParentSubgraph()) continue;
                do {
                    nestedSubgraph.add((LayerVertex)object2);
                } while ((object2 = (LayerVertex)((LayerVertex)object2).getSuccessors().get(0)) != layerVertex);
            }
            int n6 = 0;
            while (n6 < this.layers.length) {
                object = this.layers[n6];
                n = 0;
                while (n < ((ArrayList)object).size()) {
                    LayerVertex layerVertex = ((Layer)object).getVertex(n);
                    if (layerVertex.getParentSubgraph() == null) {
                        ((NestedSubgraph)object4).add(layerVertex);
                    }
                    ++n;
                }
                ++n6;
            }
            this.subgraphPartition.setPartition((NestedSubgraph)object4);
        }
    }

    public Map makeOrderSnapshot() {
        HashMap<LayerVertex, Integer> hashMap = new HashMap<LayerVertex, Integer>();
        int n = 0;
        while (n < this.layers.length) {
            Layer layer = this.layers[n];
            int n2 = 0;
            while (n2 < layer.size()) {
                LayerVertex layerVertex = layer.getVertex(n2);
                hashMap.put(layerVertex, new Integer(layerVertex.getIndexInLayer()));
                ++n2;
            }
            ++n;
        }
        return hashMap;
    }

    public void restoreOrder(Map map) {
        int n = 0;
        while (n < this.layers.length) {
            Layer layer = this.layers[n];
            int n2 = 0;
            while (n2 < layer.size()) {
                LayerVertex layerVertex = layer.getVertex(n2);
                layerVertex.setIndexInLayer(map.get(layerVertex).hashCode());
                ++n2;
            }
            layer.sort();
            ++n;
        }
    }

    public void refreshIndices() {
        int n = 0;
        while (n < this.layers.length) {
            this.layers[n].refreshIndices();
            ++n;
        }
    }

    public double balanceMeasure() {
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        while (n2 < this.layers.length) {
            Layer layer = this.layers[n2];
            int n3 = 0;
            while (n3 < layer.size()) {
                LayerVertex layerVertex = layer.getVertex(n3);
                d += layerVertex.deflection();
                n += layerVertex.degree();
                ++n3;
            }
            ++n2;
        }
        if (n == 0) {
            return 0.0;
        }
        d = Math.abs(d) / (double)n;
        return d;
    }

    private void createLayerPartition(int n, boolean bl) {
        IntPartition intPartition = this.layerPartitions[n];
        intPartition.reset();
        LayerVertex layerVertex = null;
        double d = Double.NEGATIVE_INFINITY;
        int n2 = -1;
        Layer layer = this.layers[n];
        int n3 = 0;
        while (n3 < layer.size()) {
            LayerVertex layerVertex2 = (LayerVertex)layer.get(n3);
            double d2 = bl ? layerVertex2.predecessorPendulumForce() : layerVertex2.successorPendulumForce();
            int n4 = intPartition.findSetId(n3);
            if (!(!layerVertex2.isTouchingToLeft(layerVertex, this.horizontalSpacing) || this.dummyFixed && (layerVertex2.isDummy() || layerVertex.isDummy()) || !(d * d2 > 0.0) && d != d2)) {
                intPartition.joinSets(n2, n4);
            }
            n2 = intPartition.findSetId(n4);
            d = d2;
            layerVertex = layerVertex2;
            ++n3;
        }
    }

    private void joinRegions(int n, boolean bl) {
        int n2;
        IntPartition intPartition = this.layerPartitions[n];
        Layer layer = this.layers[n];
        int n3 = layer.size();
        do {
            n2 = intPartition.getSetCount();
            double d = Double.NEGATIVE_INFINITY;
            int n4 = -1;
            LayerVertex layerVertex = null;
            int n5 = 0;
            while (n5 < n3) {
                LayerVertex layerVertex2;
                int n6 = intPartition.findSetId(n5);
                int n7 = 0;
                double d2 = 0.0;
                LayerVertex layerVertex3 = (LayerVertex)layer.get(n5);
                do {
                    layerVertex2 = (LayerVertex)layer.get(n5);
                    d2 += bl ? layerVertex2.predecessorPendulumForce() : layerVertex2.successorPendulumForce();
                    ++n7;
                } while (++n5 < n3 && n6 == intPartition.findSetId(n5));
                d2 /= (double)n7;
                if (layerVertex3.isTouchingToLeft(layerVertex, this.horizontalSpacing) && (!this.dummyFixed || !layerVertex3.isDummy() && !layerVertex.isDummy()) && (d >= 0.0 && d2 <= 0.0 || d2 >= 0.0 && d > d2 || d < 0.0 && d2 < d)) {
                    intPartition.joinSets(n4, n6);
                }
                d = d2;
                n4 = intPartition.findSetId(n6);
                layerVertex = layerVertex2;
            }
        } while (n2 > intPartition.getSetCount());
    }

    private void move(int n, boolean bl) {
        IntPartition intPartition = this.layerPartitions[n];
        Layer layer = this.layers[n];
        int n2 = layer.size();
        int n3 = 0;
        while (n3 < n2) {
            LayerVertex layerVertex;
            int n4 = intPartition.findSetId(n3);
            int n5 = 0;
            double d = 0.0;
            LayerVertex layerVertex2 = (LayerVertex)layer.get(n3);
            int n6 = n3;
            do {
                layerVertex = (LayerVertex)layer.get(n3);
                d += bl ? layerVertex.predecessorPendulumForce() : layerVertex.successorPendulumForce();
                ++n5;
            } while (++n3 < n2 && n4 == intPartition.findSetId(n3));
            int n7 = n3 - 1;
            d /= (double)n5;
            double d2 = 0.0;
            if (d < 0.0) {
                if (n6 <= 0) {
                    d2 = d;
                } else {
                    LayerVertex layerVertex3 = (LayerVertex)layer.get(n6 - 1);
                    double d3 = this.horizontalSpacing;
                    d2 = -Math.min(-d, layerVertex2.distanceToLeft(layerVertex3) - d3);
                }
            } else if (d > 0.0) {
                if (n7 >= n2 - 1) {
                    d2 = d;
                } else {
                    LayerVertex layerVertex4 = (LayerVertex)layer.get(n7 + 1);
                    double d4 = this.horizontalSpacing;
                    d2 = Math.min(d, layerVertex4.distanceToLeft(layerVertex) - d4);
                }
            }
            if (d2 == 0.0) continue;
            int n8 = n6;
            while (n8 <= n7) {
                LayerVertex layerVertex5 = (LayerVertex)layer.get(n8);
                if (!this.dummyFixed || !layerVertex5.isDummy()) {
                    layerVertex5.moveX(d2);
                }
                ++n8;
            }
        }
    }

    private void balanceLayer(int n, boolean bl) {
        this.createLayerPartition(n, bl);
        this.joinRegions(n, bl);
        this.move(n, bl);
    }

    public void createSubgraphPartition() {
        if (this.subgraphPartition != null) {
            this.subgraphPartition.insertBorderSegments(this.layers);
        }
    }

    public int balancePendulum(int n) {
        double d;
        this.layerPartitions = new IntPartition[this.layers.length];
        int n2 = 0;
        while (n2 < this.layers.length) {
            this.layerPartitions[n2] = new IntPartition(this.layers[n2].size());
            ++n2;
        }
        double d2 = Double.POSITIVE_INFINITY;
        boolean bl = false;
        boolean bl2 = true;
        if (!this.dummyFixed) {
            this.initXPositions();
        }
        int n3 = 0;
        do {
            ++n3;
            d = d2;
            int n4 = bl2 ? 1 : this.layers.length - 2;
            int n5 = bl2 ? this.layers.length : -1;
            int n6 = bl2 ? 1 : -1;
            int n7 = n4;
            while (n7 != n5) {
                this.balanceLayer(n7, bl2);
                n7 += n6;
            }
            d2 = this.balanceMeasure();
            if (!this.alternatePendulumTraversals) continue;
            boolean bl3 = bl2 = !bl2;
        } while (d2 < d && n3 <= n);
        return n3;
    }

    private void initXPositions() {
        int n = 0;
        while (n < this.layers.length) {
            this.initXPositions(n);
            ++n;
        }
    }

    private void initXPositions(int n) {
        Layer layer = this.layers[n];
        int n2 = layer.size();
        double d = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            LayerVertex layerVertex = (LayerVertex)layer.get(n3);
            layerVertex.setCenterX(d + layerVertex.getWidth() / 2.0);
            d += layerVertex.getWidth() + this.horizontalSpacing;
            ++n3;
        }
    }

    public int balanceRubberBends(int n) {
        boolean bl;
        double d = Double.POSITIVE_INFINITY;
        int n2 = 0;
        do {
            ++n2;
            bl = true;
            int n3 = 0;
            while (n3 < this.layers.length) {
                Layer layer = this.layers[n3];
                int n4 = layer.size();
                double d2 = 0.0;
                int n5 = 0;
                while (n5 < n4) {
                    double d3;
                    LayerVertex layerVertex = (LayerVertex)layer.get(n5);
                    if (!(this.dummyFixed && layerVertex.isDummy() || !(Math.abs(d3 = layerVertex.rubberForce()) > this.rubberForceThreshold))) {
                        LayerVertex layerVertex2;
                        bl = false;
                        if (d3 < 0.0) {
                            if (n5 == 0) {
                                layerVertex.moveX(d3);
                            } else {
                                layerVertex2 = (LayerVertex)layer.get(n5 - 1);
                                layerVertex.moveX(-Math.min(-d3, layerVertex.distanceToLeft(layerVertex2) - this.horizontalSpacing));
                            }
                        } else if (n5 == n4 - 1) {
                            layerVertex.moveX(d3);
                        } else {
                            layerVertex2 = (LayerVertex)layer.get(n5 + 1);
                            layerVertex.moveX(Math.min(d3, layerVertex2.distanceToLeft(layerVertex) - this.horizontalSpacing));
                        }
                        double d4 = this.balanceMeasure();
                        if (d <= d4) {
                            return n2;
                        }
                        d = d4;
                    }
                    ++n5;
                }
                ++n3;
            }
        } while (!bl && n2 <= n);
        return n2;
    }

    public boolean isAlternatePendulumTraversals() {
        return this.alternatePendulumTraversals;
    }

    public void setAlternatePendulumTraversals(boolean bl) {
        this.alternatePendulumTraversals = bl;
    }

    public double getRubberForceThreshold() {
        return this.rubberForceThreshold;
    }

    public void setRubberForceThreshold(double d) {
        this.rubberForceThreshold = d;
    }

    public double getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(double d) {
        this.horizontalSpacing = d;
    }

    public double getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public void setVerticalSpacing(double d) {
        this.verticalSpacing = d;
    }

    public void positionLayers() {
        double d = 0.0;
        switch (this.verticalAlignment) {
            case 1: {
                int n = 0;
                while (n < this.layers.length) {
                    Layer layer = this.layers[n];
                    int n2 = layer.size();
                    double d2 = 0.0;
                    int n3 = 0;
                    while (n3 < n2) {
                        LayerVertex layerVertex = (LayerVertex)layer.get(n3);
                        layerVertex.setCenterY(d + layerVertex.getHeight() / 2.0);
                        d2 = Math.max(d2, layerVertex.getHeight());
                        ++n3;
                    }
                    d += d2 + this.verticalSpacing;
                    ++n;
                }
                break;
            }
            case 3: {
                int n = 0;
                while (n < this.layers.length) {
                    Layer layer = this.layers[n];
                    int n4 = layer.size();
                    double d3 = 0.0;
                    int n5 = 0;
                    while (n5 < n4) {
                        LayerVertex layerVertex = (LayerVertex)layer.get(n5);
                        d3 = Math.max(d3, layerVertex.getHeight());
                        ++n5;
                    }
                    d += d3;
                    int n6 = 0;
                    while (n6 < n4) {
                        LayerVertex layerVertex = (LayerVertex)layer.get(n6);
                        layerVertex.setCenterY(d - layerVertex.getHeight() / 2.0);
                        ++n6;
                    }
                    d += this.verticalSpacing;
                    ++n;
                }
                break;
            }
            default: {
                int n = 0;
                while (n < this.layers.length) {
                    Layer layer = this.layers[n];
                    int n7 = layer.size();
                    double d4 = 0.0;
                    int n8 = 0;
                    while (n8 < n7) {
                        LayerVertex layerVertex = (LayerVertex)layer.get(n8);
                        d4 = Math.max(d4, layerVertex.getHeight() / 2.0);
                        ++n8;
                    }
                    d += d4;
                    int n9 = 0;
                    while (n9 < n7) {
                        LayerVertex layerVertex = (LayerVertex)layer.get(n9);
                        layerVertex.setCenterY(d);
                        ++n9;
                    }
                    d += d4 + this.verticalSpacing;
                    ++n;
                }
                break block0;
            }
        }
    }

    public void positionDummies() {
        ArcStraightener arcStraightener = new ArcStraightener();
        arcStraightener.positionDummies(this.layers, this.horizontalSpacing);
    }

    public void updateGeometry(Attribute attribute, Rectangle2D rectangle2D) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        int n = 0;
        while (n < this.layers.length) {
            Layer layer = this.layers[n];
            int n2 = layer.size();
            int n3 = 0;
            while (n3 < n2) {
                LayerVertex layerVertex = (LayerVertex)layer.get(n3);
                d = Math.min(d, layerVertex.getMinX());
                d2 = Math.min(d2, layerVertex.getMinY());
                d3 = Math.max(d3, layerVertex.getMaxX());
                d4 = Math.max(d4, layerVertex.getMaxY());
                if (!layerVertex.isDummy()) {
                    layerVertex.updateGeometry(attribute);
                }
                ++n3;
            }
            ++n;
        }
        rectangle2D.setFrame(d, d2, d3 - d, d4 - d2);
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    public Digraph positionArcs() {
        MapDigraph mapDigraph = new MapDigraph();
        ArcIterator arcIterator = this.longArcDigraph.arcIterator();
        while (arcIterator.hasNext()) {
            LayerVertex layerVertex = (LayerVertex)arcIterator.next();
            LayerVertex layerVertex2 = (LayerVertex)arcIterator.getOrigin();
            LayerVertex layerVertex3 = (LayerVertex)arcIterator.getDestination();
            int n = layerVertex3.getRank() - layerVertex2.getRank() + 1;
            ArrayList<Point> arrayList = new ArrayList<Point>(n);
            double d = layerVertex2.getCenterX();
            double d2 = layerVertex.getCenterX();
            double d3 = layerVertex2.getCenterY();
            double d4 = layerVertex.getCenterY();
            double d5 = layerVertex2.getHeight() / 2.0;
            double d6 = (d2 - d) * d5 / (d4 - d3) + d;
            double d7 = d3 + d5;
            arrayList.add(new Point((int)d6, (int)d7));
            LayerVertex layerVertex4 = layerVertex;
            int n2 = 0;
            do {
                layerVertex = layerVertex4;
                layerVertex4 = layerVertex.getSuccessor(0);
                if (n > 4 && ++n2 > 1 && n2 < n - 2) continue;
                d2 = layerVertex.getCenterX();
                d4 = layerVertex.getCenterY();
                if (n >= 4) {
                    if (n2 == 1) {
                        d4 -= layerVertex2.getHeight() / 2.0;
                    } else if (n2 == n - 2) {
                        d4 += layerVertex3.getHeight() / 2.0;
                    }
                }
                arrayList.add(new Point((int)d2, (int)d4));
            } while (layerVertex4 != layerVertex3);
            d = layerVertex3.getCenterX();
            d3 = layerVertex3.getCenterY();
            d5 = layerVertex3.getHeight() / 2.0;
            d6 = (d2 - d) * d5 / (d3 - d4) + d;
            d7 = d3 - d5;
            arrayList.add(new Point((int)d6, (int)d7));
            mapDigraph.putArc(layerVertex2.getUserVertex(), layerVertex3.getUserVertex(), arrayList);
        }
        return mapDigraph;
    }

    public void setDummyFixed(boolean bl) {
        this.dummyFixed = bl;
    }

    public boolean isDummyFixed() {
        return this.dummyFixed;
    }

    public void printLayers() {
        int n = 0;
        while (n < this.layers.length) {
            System.out.print("l[" + this.layers[n].getRank() + "]: ");
            int n2 = 0;
            while (n2 < this.layers[n].size()) {
                LayerVertex layerVertex = this.layers[n].getVertex(n2);
                String string = layerVertex.getParentSubgraph() != null ? layerVertex.getParentSubgraph().getLabel() : "?";
                System.out.print(string + "." + layerVertex + "{" + layerVertex.getRank() + "," + layerVertex.getIndexInLayer() + "}, ");
                ++n2;
            }
            System.out.println();
            ++n;
        }
    }
}

