/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.system;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.config.ALConfigHandler;
import com.aimluck.eip.services.config.ALConfigService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.system.util.SystemUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class SystemNetworkFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)SystemNetworkFormData.class.getName());
    private ALStringField protocol;
    private ALStringField ipaddress;
    private ALNumberField port;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
    }

    public void initField() {
        this.protocol = new ALStringField();
        this.protocol.setFieldName(ALLocalizationUtils.getl10n((String)"SYSTEM_SETFIELDNAME_PROTOCOL"));
        this.protocol.setTrim(true);
        this.ipaddress = new ALStringField();
        this.ipaddress.setFieldName(ALLocalizationUtils.getl10n((String)"SYSTEM_SETFIELDNAME_IPADDRESS"));
        this.ipaddress.setTrim(true);
        this.port = new ALNumberField();
        this.port.setFieldName(ALLocalizationUtils.getl10n((String)"SYSTEM_SETFIELDNAME_PORT"));
        this.port.setValue(80L);
    }

    protected void setValidator() {
        this.protocol.setNotNull(true);
        this.ipaddress.setNotNull(true);
        this.port.setNotNull(true);
        this.port.limitValue(1L, 65535L);
    }

    protected boolean validate(List<String> msgList) {
        this.protocol.validate(msgList);
        this.ipaddress.validate(msgList);
        this.port.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMCompany record = SystemUtils.getEipMCompany(rundata, context);
            if (record == null) {
                return false;
            }
            this.protocol.setValue(ALConfigService.get((ALConfigHandler.Property)ALConfigHandler.Property.ACCESS_GLOBAL_URL_PROTOCOL));
            this.ipaddress.setValue(record.getIpaddress());
            this.port.setValue(record.getPort().longValue());
        }
        catch (Exception ex) {
            logger.error((Object)"system", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMCompany record = SystemUtils.getEipMCompany(rundata, context);
            if (record == null) {
                return false;
            }
            ALConfigService.put((ALConfigHandler.Property)ALConfigHandler.Property.ACCESS_GLOBAL_URL_PROTOCOL, (String)this.protocol.getValue());
            record.setIpaddress(this.ipaddress.getValue());
            record.setPort(Integer.valueOf((int)this.port.getValue()));
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(record.getCompanyId().intValue(), 4, "\u793e\u5916\u30a2\u30c9\u30ec\u30b9\u3092" + this.protocol.getValue() + "://" + this.ipaddress.getValue() + ":" + (int)this.port.getValue() + "\u306b\u66f4\u65b0");
            ALEipManager.getInstance().reloadCompany();
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"system", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    public ALStringField getProtocol() {
        return this.protocol;
    }

    public ALStringField getIpaddress() {
        return this.ipaddress;
    }

    public ALNumberField getPort() {
        return this.port;
    }
}

